/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.CollectionAttributeCopier;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.Index;

public class IndexingConfiguration
extends AbstractTypedPropertiesConfiguration
implements Matchable<IndexingConfiguration> {
    public static final AttributeDefinition<Index> INDEX = AttributeDefinition.builder((String)"index", (Object)((Object)Index.NONE)).immutable().build();
    public static final AttributeDefinition<Boolean> AUTO_CONFIG = AttributeDefinition.builder((String)"autoConfig", (Object)false).immutable().build();
    public static final AttributeDefinition<Set<Class<?>>> INDEXED_ENTITIES = AttributeDefinition.builder((String)"indexed-entities", null, Set.class).copier(CollectionAttributeCopier.INSTANCE).initializer(HashSet::new).immutable().build();
    private static final String DIRECTORY_PROVIDER_KEY = "directory_provider";
    @Deprecated
    private static final String RAM_DIRECTORY_PROVIDER = "ram";
    private static final String LOCAL_HEAP_DIRECTORY_PROVIDER = "local-heap";
    private static final String LOCAL_HEAP_DIRECTORY_PROVIDER_FQN = "org.hibernate.search.store.impl.RAMDirectoryProvider";
    private final Attribute<Index> index;
    private final Attribute<Boolean> autoConfig;
    private final Attribute<Set<Class<?>>> indexedEntities;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(IndexingConfiguration.class, AbstractTypedPropertiesConfiguration.attributeSet(), new AttributeDefinition[]{INDEX, AUTO_CONFIG, INDEXED_ENTITIES});
    }

    IndexingConfiguration(AttributeSet attributes) {
        super(attributes);
        this.index = attributes.attribute(INDEX);
        this.autoConfig = attributes.attribute(AUTO_CONFIG);
        this.indexedEntities = attributes.attribute(INDEXED_ENTITIES);
    }

    @Deprecated
    public boolean enabled() {
        return this.index().isEnabled();
    }

    @Deprecated
    public boolean indexLocalOnly() {
        return this.index().isLocalOnly();
    }

    public TypedProperties properties() {
        return super.properties();
    }

    public Index index() {
        return (Index)((Object)this.index.get());
    }

    public boolean autoConfig() {
        return (Boolean)this.autoConfig.get();
    }

    public Set<Class<?>> indexedEntities() {
        return (Set)this.indexedEntities.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean indexShareable() {
        TypedProperties properties = this.properties();
        boolean hasRamDirectoryProvider = false;
        for (Object objKey : properties.keySet()) {
            String key = (String)objKey;
            if (!key.endsWith(DIRECTORY_PROVIDER_KEY)) continue;
            String directoryImplementationName = String.valueOf(properties.get((Object)key)).trim();
            if (LOCAL_HEAP_DIRECTORY_PROVIDER.equalsIgnoreCase(directoryImplementationName) || RAM_DIRECTORY_PROVIDER.equalsIgnoreCase(directoryImplementationName) || LOCAL_HEAP_DIRECTORY_PROVIDER_FQN.equals(directoryImplementationName)) {
                hasRamDirectoryProvider = true;
                continue;
            }
            return true;
        }
        return !hasRamDirectoryProvider;
    }

    public String toString() {
        return "IndexingConfiguration [attributes=" + this.attributes + "]";
    }
}

