/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import javax.sql.DataSource;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.jdbc.store.sql.PropertySQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.jboss.as.controller.services.path.AbsolutePathService;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.messaging.activemq.BroadcastGroupAdd;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupAdd;
import org.wildfly.extension.messaging.activemq.ElytronSecurityManager;
import org.wildfly.extension.messaging.activemq.RemoteTransportDefinition;
import org.wildfly.extension.messaging.activemq.ServerDefinition;
import org.wildfly.extension.messaging.activemq.TransportConfigOperationHandlers;
import org.wildfly.extension.messaging.activemq.WildFlySecurityManager;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;

class ActiveMQServerService
implements Service<ActiveMQServer> {
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String SOCKET_REF = RemoteTransportDefinition.SOCKET_BINDING.getName();
    private Configuration configuration;
    private ActiveMQServer server;
    private final PathConfig pathConfig;
    private final List<Interceptor> incomingInterceptors;
    private final List<Interceptor> outgoingInterceptors;
    private final Map<String, Supplier<SocketBinding>> socketBindings;
    private final Map<String, Supplier<OutboundSocketBinding>> outboundSocketBindings;
    private final Map<String, Supplier<SocketBinding>> groupBindings;
    private final Supplier<PathManager> pathManager;
    private final Optional<Supplier<MBeanServer>> mbeanServer;
    private final Optional<Supplier<DataSource>> dataSource;
    private final Map<String, String> clusterNames;
    private final Map<String, Supplier<CommandDispatcherFactory>> commandDispatcherFactories;
    private final Optional<Supplier<SecurityDomain>> elytronSecurityDomain;
    private final Optional<Supplier<SecurityDomainContext>> securityDomainContext;
    private Map<String, InjectedValue<ExceptionSupplier<CredentialSource, Exception>>> bridgeCredentialSource = new HashMap<String, InjectedValue<ExceptionSupplier<CredentialSource, Exception>>>();
    private InjectedValue<ExceptionSupplier<CredentialSource, Exception>> clusterCredentialSource = new InjectedValue();

    public ActiveMQServerService(Configuration configuration, PathConfig pathConfig, Supplier<PathManager> pathManager, List<Interceptor> incomingInterceptors, List<Interceptor> outgoingInterceptors, Map<String, Supplier<SocketBinding>> socketBindings, Map<String, Supplier<OutboundSocketBinding>> outboundSocketBindings, Map<String, Supplier<SocketBinding>> groupBindings, Map<String, Supplier<CommandDispatcherFactory>> commandDispatcherFactories, Map<String, String> clusterNames, Optional<Supplier<SecurityDomain>> elytronSecurityDomain, Optional<Supplier<SecurityDomainContext>> securityDomainContext, Optional<Supplier<MBeanServer>> mbeanServer, Optional<Supplier<DataSource>> dataSource) {
        this.configuration = configuration;
        this.pathConfig = pathConfig;
        this.dataSource = dataSource;
        this.mbeanServer = mbeanServer;
        this.pathManager = pathManager;
        this.elytronSecurityDomain = elytronSecurityDomain;
        this.securityDomainContext = securityDomainContext;
        this.incomingInterceptors = incomingInterceptors;
        this.outgoingInterceptors = outgoingInterceptors;
        this.socketBindings = socketBindings;
        this.outboundSocketBindings = outboundSocketBindings;
        this.groupBindings = groupBindings;
        this.commandDispatcherFactories = commandDispatcherFactories;
        this.clusterNames = clusterNames;
        if (configuration != null) {
            for (BridgeConfiguration bridgeConfiguration : configuration.getBridgeConfigurations()) {
                this.bridgeCredentialSource.put(bridgeConfiguration.getName(), (InjectedValue<ExceptionSupplier<CredentialSource, Exception>>)new InjectedValue());
            }
        }
    }

    public synchronized void start(StartContext context) throws StartException {
        boolean supportsAIO;
        ClassLoader origTCCL = org.wildfly.security.manager.WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        JournalType jtype = this.configuration.getJournalType();
        if (jtype == JournalType.ASYNCIO && !(supportsAIO = AIOSequentialFileFactory.isSupported())) {
            String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
            if (osName.contains("nux")) {
                MessagingLogger.ROOT_LOGGER.aioInfoLinux();
            } else {
                MessagingLogger.ROOT_LOGGER.aioInfo();
            }
            this.configuration.setJournalType(JournalType.NIO);
        }
        this.configuration.setBindingsDirectory(this.pathConfig.resolveBindingsPath(this.pathManager.get()));
        this.configuration.setLargeMessagesDirectory(this.pathConfig.resolveLargeMessagePath(this.pathManager.get()));
        this.configuration.setJournalDirectory(this.pathConfig.resolveJournalPath(this.pathManager.get()));
        this.configuration.setPagingDirectory(this.pathConfig.resolvePagingPath(this.pathManager.get()));
        this.pathConfig.registerCallbacks(this.pathManager.get());
        try {
            Object securityManager;
            String clusterName;
            CommandDispatcherFactory commandDispatcherFactory;
            String name;
            Set acceptors = this.configuration.getAcceptorConfigurations();
            Collection<TransportConfiguration> connectors = this.configuration.getConnectorConfigurations().values();
            List broadcastGroups = this.configuration.getBroadcastGroupConfigurations();
            Map discoveryGroups = this.configuration.getDiscoveryGroupConfigurations();
            TransportConfigOperationHandlers.processConnectorBindings(connectors, this.socketBindings, this.outboundSocketBindings);
            if (acceptors != null) {
                for (TransportConfiguration transportConfiguration : acceptors) {
                    Object socketRef = transportConfiguration.getParams().remove(SOCKET_REF);
                    if (socketRef == null) continue;
                    name = socketRef.toString();
                    SocketBinding binding = this.socketBindings.get(name).get();
                    if (binding == null) {
                        throw MessagingLogger.ROOT_LOGGER.failedToFindConnectorSocketBinding(transportConfiguration.getName());
                    }
                    binding.getSocketBindings().getNamedRegistry().registerBinding(ManagedBinding.Factory.createSimpleManagedBinding((SocketBinding)binding));
                    InetSocketAddress socketAddress = binding.getSocketAddress();
                    transportConfiguration.getParams().put(HOST, socketAddress.getAddress().getHostAddress());
                    transportConfiguration.getParams().put(PORT, socketAddress.getPort());
                }
            }
            if (broadcastGroups != null) {
                ArrayList newConfigs = new ArrayList();
                for (BroadcastGroupConfiguration config : broadcastGroups) {
                    name = config.getName();
                    String key = "broadcast" + name;
                    if (this.commandDispatcherFactories.containsKey(key)) {
                        commandDispatcherFactory = this.commandDispatcherFactories.get(key).get();
                        clusterName = this.clusterNames.get(key);
                        newConfigs.add(BroadcastGroupAdd.createBroadcastGroupConfiguration(name, config, commandDispatcherFactory, clusterName));
                        continue;
                    }
                    Supplier<SocketBinding> bindingSupplier = this.groupBindings.get(key);
                    if (bindingSupplier == null) {
                        throw MessagingLogger.ROOT_LOGGER.failedToFindBroadcastSocketBinding(name);
                    }
                    SocketBinding binding = bindingSupplier.get();
                    binding.getSocketBindings().getNamedRegistry().registerBinding(ManagedBinding.Factory.createSimpleManagedBinding((SocketBinding)binding));
                    newConfigs.add(BroadcastGroupAdd.createBroadcastGroupConfiguration(name, config, binding));
                }
                this.configuration.getBroadcastGroupConfigurations().clear();
                this.configuration.getBroadcastGroupConfigurations().addAll(newConfigs);
            }
            if (discoveryGroups != null) {
                this.configuration.setDiscoveryGroupConfigurations(new HashMap());
                for (Map.Entry entry : discoveryGroups.entrySet()) {
                    DiscoveryGroupConfiguration config;
                    String name2 = (String)entry.getKey();
                    String key = "discovery" + name2;
                    if (this.commandDispatcherFactories.containsKey(key)) {
                        commandDispatcherFactory = this.commandDispatcherFactories.get(key).get();
                        clusterName = this.clusterNames.get(key);
                        config = DiscoveryGroupAdd.createDiscoveryGroupConfiguration(name2, (DiscoveryGroupConfiguration)entry.getValue(), commandDispatcherFactory, clusterName);
                    } else {
                        Supplier<SocketBinding> binding = this.groupBindings.get(key);
                        if (binding == null) {
                            throw MessagingLogger.ROOT_LOGGER.failedToFindDiscoverySocketBinding(name2);
                        }
                        config = DiscoveryGroupAdd.createDiscoveryGroupConfiguration(name2, (DiscoveryGroupConfiguration)entry.getValue(), binding.get());
                        binding.get().getSocketBindings().getNamedRegistry().registerBinding(ManagedBinding.Factory.createSimpleManagedBinding((SocketBinding)binding.get()));
                    }
                    this.configuration.getDiscoveryGroupConfigurations().put(name2, config);
                }
            }
            if (this.elytronSecurityDomain.isPresent()) {
                securityManager = new ElytronSecurityManager(this.elytronSecurityDomain.get().get());
            } else {
                assert (this.securityDomainContext.isPresent());
                securityManager = new WildFlySecurityManager(this.securityDomainContext.get().get());
            }
            this.setBridgePasswordsFromCredentialSource();
            this.setClusterPasswordFromCredentialSource();
            if (this.dataSource.isPresent()) {
                DataSource dataSource = this.dataSource.get().get();
                DatabaseStorageConfiguration dbConfiguration = (DatabaseStorageConfiguration)this.configuration.getStoreConfiguration();
                dbConfiguration.setDataSource(dataSource);
                PropertySQLProvider.Factory sqlProviderFactory = new PropertySQLProvider.Factory(dataSource);
                dbConfiguration.setSqlProvider((SQLProvider.Factory)sqlProviderFactory);
                this.configuration.setStoreConfiguration((StoreConfiguration)dbConfiguration);
                MessagingLogger.ROOT_LOGGER.infof("use JDBC store for Artemis server, bindingsTable:%s", dbConfiguration.getBindingsTableName());
            }
            MBeanServer mBeanServer = this.mbeanServer.isPresent() ? this.mbeanServer.get().get() : null;
            this.server = new ActiveMQServerImpl(this.configuration, mBeanServer, (ActiveMQSecurityManager)securityManager);
            if (ServerDefinition.CLUSTER_PASSWORD.getDefaultValue().asString().equals(this.server.getConfiguration().getClusterPassword())) {
                this.server.getConfiguration().setClusterPassword(UUID.randomUUID().toString());
            }
            for (Interceptor incomingInterceptor : this.incomingInterceptors) {
                this.server.getServiceRegistry().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
            }
            for (Interceptor outgoingInterceptor : this.outgoingInterceptors) {
                this.server.getServiceRegistry().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
            }
        }
        catch (Exception e) {
            throw MessagingLogger.ROOT_LOGGER.failedToStartService(e);
        }
        finally {
            org.wildfly.security.manager.WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)origTCCL);
        }
    }

    public synchronized void stop(StopContext context) {
        try {
            if (this.server != null) {
                for (Supplier<SocketBinding> binding : this.socketBindings.values()) {
                    if (binding == null) continue;
                    binding.get().getSocketBindings().getNamedRegistry().unregisterBinding(binding.get().getName());
                }
                for (Supplier<SocketBinding> binding : this.groupBindings.values()) {
                    if (binding == null) continue;
                    binding.get().getSocketBindings().getNamedRegistry().unregisterBinding(binding.get().getName());
                }
            }
            this.pathConfig.closeCallbacks(this.pathManager.get());
        }
        catch (Exception e) {
            throw MessagingLogger.ROOT_LOGGER.failedToShutdownServer(e, "Artemis");
        }
    }

    public synchronized ActiveMQServer getValue() throws IllegalStateException {
        ActiveMQServer server = this.server;
        if (server == null) {
            throw new IllegalStateException();
        }
        return server;
    }

    CommandDispatcherFactory getCommandDispatcherFactory(String key) {
        return this.commandDispatcherFactories.get(key).get();
    }

    public InjectedValue<ExceptionSupplier<CredentialSource, Exception>> getBridgeCredentialSourceSupplierInjector(String name) {
        if (this.bridgeCredentialSource.containsKey(name)) {
            return this.bridgeCredentialSource.get(name);
        }
        InjectedValue injector = new InjectedValue();
        this.bridgeCredentialSource.put(name, (InjectedValue<ExceptionSupplier<CredentialSource, Exception>>)injector);
        return injector;
    }

    public InjectedValue<ExceptionSupplier<CredentialSource, Exception>> getClusterCredentialSourceSupplierInjector() {
        return this.clusterCredentialSource;
    }

    private void setBridgePasswordsFromCredentialSource() {
        if (this.configuration != null) {
            for (BridgeConfiguration bridgeConfiguration : this.configuration.getBridgeConfigurations()) {
                this.setNewPassword((ExceptionSupplier<CredentialSource, Exception>)((ExceptionSupplier)this.getBridgeCredentialSourceSupplierInjector(bridgeConfiguration.getName()).getOptionalValue()), arg_0 -> ((BridgeConfiguration)bridgeConfiguration).setPassword(arg_0));
            }
        }
    }

    private void setClusterPasswordFromCredentialSource() {
        if (this.configuration != null) {
            this.setNewPassword((ExceptionSupplier<CredentialSource, Exception>)((ExceptionSupplier)this.getClusterCredentialSourceSupplierInjector().getOptionalValue()), arg_0 -> ((Configuration)this.configuration).setClusterPassword(arg_0));
        }
    }

    private void setNewPassword(ExceptionSupplier<CredentialSource, Exception> credentialSourceSupplier, Consumer<String> passwordConsumer) {
        if (credentialSourceSupplier != null) {
            try {
                char[] password;
                CredentialSource credentialSource = (CredentialSource)credentialSourceSupplier.get();
                if (credentialSource != null && (password = ((ClearPassword)((PasswordCredential)credentialSource.getCredential(PasswordCredential.class)).getPassword(ClearPassword.class)).getPassword()) != null) {
                    passwordConsumer.accept(new String(password));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class PathConfig {
        private final String bindingsPath;
        private final String bindingsRelativeToPath;
        private final String journalPath;
        private final String journalRelativeToPath;
        private final String largeMessagePath;
        private final String largeMessageRelativeToPath;
        private final String pagingPath;
        private final String pagingRelativeToPath;
        private final List<PathManager.Callback.Handle> callbackHandles = new ArrayList<PathManager.Callback.Handle>();

        public PathConfig(String bindingsPath, String bindingsRelativeToPath, String journalPath, String journalRelativeToPath, String largeMessagePath, String largeMessageRelativeToPath, String pagingPath, String pagingRelativeToPath) {
            this.bindingsPath = bindingsPath;
            this.bindingsRelativeToPath = bindingsRelativeToPath;
            this.journalPath = journalPath;
            this.journalRelativeToPath = journalRelativeToPath;
            this.largeMessagePath = largeMessagePath;
            this.largeMessageRelativeToPath = largeMessageRelativeToPath;
            this.pagingPath = pagingPath;
            this.pagingRelativeToPath = pagingRelativeToPath;
        }

        String resolveBindingsPath(PathManager pathManager) {
            return this.resolve(pathManager, this.bindingsPath, this.bindingsRelativeToPath);
        }

        String resolveJournalPath(PathManager pathManager) {
            return this.resolve(pathManager, this.journalPath, this.journalRelativeToPath);
        }

        String resolveLargeMessagePath(PathManager pathManager) {
            return this.resolve(pathManager, this.largeMessagePath, this.largeMessageRelativeToPath);
        }

        String resolvePagingPath(PathManager pathManager) {
            return this.resolve(pathManager, this.pagingPath, this.pagingRelativeToPath);
        }

        String resolve(PathManager pathManager, String path, String relativeToPath) {
            String relativeTo = AbsolutePathService.isAbsoluteUnixOrWindowsPath((String)path) ? null : relativeToPath;
            return pathManager.resolveRelativePathEntry(path, relativeTo);
        }

        synchronized void registerCallbacks(PathManager pathManager) {
            if (this.bindingsRelativeToPath != null) {
                this.callbackHandles.add(pathManager.registerCallback(this.bindingsRelativeToPath, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED}));
            }
            if (this.journalRelativeToPath != null) {
                this.callbackHandles.add(pathManager.registerCallback(this.journalRelativeToPath, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED}));
            }
            if (this.largeMessageRelativeToPath != null) {
                this.callbackHandles.add(pathManager.registerCallback(this.largeMessageRelativeToPath, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED}));
            }
            if (this.pagingRelativeToPath != null) {
                this.callbackHandles.add(pathManager.registerCallback(this.pagingRelativeToPath, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED}));
            }
        }

        synchronized void closeCallbacks(PathManager pathManager) {
            for (PathManager.Callback.Handle callbackHandle : this.callbackHandles) {
                callbackHandle.remove();
            }
            this.callbackHandles.clear();
        }
    }
}

