/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.output.changelog;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.OfflineConnection;
import liquibase.database.core.DB2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGenerator;
import liquibase.diff.output.changelog.ChangeGeneratorFactory;
import liquibase.diff.output.changelog.ChangedObjectChangeGenerator;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.diff.output.changelog.UnexpectedObjectChangeGenerator;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogFactory;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.ChangeLogSerializerFactory;
import liquibase.serializer.core.xml.XMLChangeLogSerializer;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.DatabaseObjectComparator;
import liquibase.structure.core.Column;
import liquibase.util.DependencyUtil;
import liquibase.util.StringUtils;

public class DiffToChangeLog {
    private String idRoot = String.valueOf(new Date().getTime());
    private boolean overriddenIdRoot = false;
    private int changeNumber = 1;
    private String changeSetContext;
    private String changeSetAuthor;
    private String changeSetPath;
    private DiffResult diffResult;
    private DiffOutputControl diffOutputControl;
    private static Set<Class> loggedOrderFor = new HashSet<Class>();

    public DiffToChangeLog(DiffResult diffResult, DiffOutputControl diffOutputControl) {
        this.diffResult = diffResult;
        this.diffOutputControl = diffOutputControl;
    }

    public DiffToChangeLog(DiffOutputControl diffOutputControl) {
        this.diffOutputControl = diffOutputControl;
    }

    public void setDiffResult(DiffResult diffResult) {
        this.diffResult = diffResult;
    }

    public void setChangeSetContext(String changeSetContext) {
        this.changeSetContext = changeSetContext;
    }

    public void print(String changeLogFile) throws ParserConfigurationException, IOException, DatabaseException {
        this.changeSetPath = changeLogFile;
        ChangeLogSerializer changeLogSerializer = ChangeLogSerializerFactory.getInstance().getSerializer(changeLogFile);
        this.print(changeLogFile, changeLogSerializer);
    }

    public void print(PrintStream out) throws ParserConfigurationException, IOException, DatabaseException {
        this.print(out, (ChangeLogSerializer)new XMLChangeLogSerializer());
    }

    public void print(String changeLogFile, ChangeLogSerializer changeLogSerializer) throws ParserConfigurationException, IOException, DatabaseException {
        this.changeSetPath = changeLogFile;
        File file = new File(changeLogFile);
        if (!file.exists()) {
            LogFactory.getLogger().info(file + " does not exist, creating");
            FileOutputStream stream = new FileOutputStream(file);
            this.print(new PrintStream((OutputStream)stream, true, LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding()), changeLogSerializer);
            stream.close();
        } else {
            String line;
            LogFactory.getLogger().info(file + " exists, appending");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.print(new PrintStream((OutputStream)out, true, LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding()), changeLogSerializer);
            String xml = new String(out.toByteArray(), LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding());
            String innerXml = xml.replaceFirst("(?ms).*<databaseChangeLog[^>]*>", "");
            innerXml = innerXml.replaceFirst("bblacha", "Bart");
            innerXml = innerXml.replaceFirst("</databaseChangeLog>", "");
            innerXml = innerXml.trim();
            if ("".equals(innerXml)) {
                LogFactory.getLogger().info("No changes found, nothing to do");
                return;
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            long offset = 0L;
            boolean foundEndTag = false;
            while ((line = randomAccessFile.readLine()) != null) {
                int index = line.indexOf("</databaseChangeLog>");
                if (index >= 0) {
                    foundEndTag = true;
                    break;
                }
                offset = randomAccessFile.getFilePointer();
            }
            String lineSeparator = LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputLineSeparator();
            if (foundEndTag) {
                randomAccessFile.seek(offset);
                randomAccessFile.writeBytes("    ");
                randomAccessFile.write(innerXml.getBytes(LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding()));
                randomAccessFile.writeBytes(lineSeparator);
                randomAccessFile.writeBytes("</databaseChangeLog>" + lineSeparator);
            } else {
                randomAccessFile.seek(0L);
                randomAccessFile.write(xml.getBytes(LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding()));
            }
            randomAccessFile.close();
        }
    }

    public void print(PrintStream out, ChangeLogSerializer changeLogSerializer) throws ParserConfigurationException, IOException, DatabaseException {
        List<ChangeSet> changeSets = this.generateChangeSets();
        changeLogSerializer.write(changeSets, out);
        out.flush();
    }

    public List<ChangeSet> generateChangeSets() {
        Change[] changes;
        ObjectQuotingStrategy quotingStrategy;
        ChangeGeneratorFactory changeGeneratorFactory = ChangeGeneratorFactory.getInstance();
        DatabaseObjectComparator comparator = new DatabaseObjectComparator();
        String created = null;
        if (LiquibaseConfiguration.getInstance().getProperty(GlobalConfiguration.class, "generateChangeSetCreatedValues").getValue(Boolean.class).booleanValue()) {
            created = new SimpleDateFormat("yyyy-MM-dd HH:mmZ").format(new Date());
        }
        ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>();
        List<Class<? extends DatabaseObject>> types = this.getOrderedOutputTypes(MissingObjectChangeGenerator.class);
        ArrayList<DatabaseObject> missingObjects = new ArrayList<DatabaseObject>();
        for (Class<? extends DatabaseObject> clazz : types) {
            for (DatabaseObject databaseObject : this.diffResult.getMissingObjects(clazz, new DatabaseObjectComparator(){

                @Override
                public int compare(DatabaseObject o1, DatabaseObject o2) {
                    int i;
                    if (o1 instanceof Column && o1.getAttribute("order", Integer.class) != null && o2.getAttribute("order", Integer.class) != null && (i = ((Integer)((Object)o1.getAttribute("order", Integer.class))).compareTo((Integer)((Object)o2.getAttribute("order", Integer.class)))) != 0) {
                        return i;
                    }
                    return super.compare(o1, o2);
                }
            })) {
                if (databaseObject == null || this.diffResult.getReferenceSnapshot().getDatabase().isLiquibaseObject(databaseObject) || this.diffResult.getReferenceSnapshot().getDatabase().isSystemObject(databaseObject)) continue;
                missingObjects.add(databaseObject);
            }
        }
        for (DatabaseObject databaseObject : this.sortMissingObjects(missingObjects, this.diffResult.getReferenceSnapshot().getDatabase())) {
            quotingStrategy = this.diffOutputControl.getObjectQuotingStrategy();
            Change[] changeArray = changeGeneratorFactory.fixMissing(databaseObject, this.diffOutputControl, this.diffResult.getReferenceSnapshot().getDatabase(), this.diffResult.getComparisonSnapshot().getDatabase());
            this.addToChangeSets(changeArray, changeSets, quotingStrategy, created);
        }
        types = this.getOrderedOutputTypes(UnexpectedObjectChangeGenerator.class);
        for (Class clazz : types) {
            quotingStrategy = this.diffOutputControl.getObjectQuotingStrategy();
            for (DatabaseObject databaseObject : this.diffResult.getUnexpectedObjects(clazz, comparator)) {
                if (this.diffResult.getComparisonSnapshot().getDatabase().isLiquibaseObject(databaseObject) || this.diffResult.getComparisonSnapshot().getDatabase().isSystemObject(databaseObject)) continue;
                changes = changeGeneratorFactory.fixUnexpected(databaseObject, this.diffOutputControl, this.diffResult.getReferenceSnapshot().getDatabase(), this.diffResult.getComparisonSnapshot().getDatabase());
                this.addToChangeSets(changes, changeSets, quotingStrategy, created);
            }
        }
        types = this.getOrderedOutputTypes(ChangedObjectChangeGenerator.class);
        for (Class clazz : types) {
            quotingStrategy = this.diffOutputControl.getObjectQuotingStrategy();
            for (Map.Entry entry : this.diffResult.getChangedObjects(clazz, comparator).entrySet()) {
                if (this.diffResult.getReferenceSnapshot().getDatabase().isLiquibaseObject((DatabaseObject)entry.getKey()) || this.diffResult.getReferenceSnapshot().getDatabase().isSystemObject((DatabaseObject)entry.getKey())) continue;
                changes = changeGeneratorFactory.fixChanged((DatabaseObject)entry.getKey(), entry.getValue(), this.diffOutputControl, this.diffResult.getReferenceSnapshot().getDatabase(), this.diffResult.getComparisonSnapshot().getDatabase());
                this.addToChangeSets(changes, changeSets, quotingStrategy, created);
            }
        }
        return changeSets;
    }

    private List<DatabaseObject> sortMissingObjects(Collection<DatabaseObject> missingObjects, Database database) {
        if (this.diffOutputControl.getSchemaComparisons() != null && missingObjects.size() > 0 && this.supportsSortingObjects(database) && database.getConnection() != null && !(database.getConnection() instanceof OfflineConnection)) {
            ArrayList<String> schemas = new ArrayList<String>();
            for (CompareControl.SchemaComparison comparison : this.diffOutputControl.getSchemaComparisons()) {
                String schemaName = comparison.getReferenceSchema().getSchemaName();
                if (schemaName == null) {
                    schemaName = database.getDefaultSchemaName();
                }
                schemas.add(schemaName);
            }
            if (schemas.size() == 0) {
                schemas.add(database.getDefaultSchemaName());
            }
            try {
                final ArrayList dependencyOrder = new ArrayList();
                DependencyUtil.NodeValueListener<String> nameListener = new DependencyUtil.NodeValueListener<String>(){

                    @Override
                    public void evaluating(String nodeValue) {
                        dependencyOrder.add(nodeValue);
                    }
                };
                DependencyUtil.DependencyGraph<String> graph = new DependencyUtil.DependencyGraph<String>(nameListener);
                this.addDependencies(graph, schemas, missingObjects, database);
                graph.computeDependencies();
                if (dependencyOrder.size() > 0) {
                    ArrayList<DatabaseObject> toSort = new ArrayList<DatabaseObject>();
                    ArrayList<DatabaseObject> toNotSort = new ArrayList<DatabaseObject>();
                    for (DatabaseObject obj : missingObjects) {
                        if (!(obj instanceof Column)) {
                            String name;
                            String schemaName = null;
                            if (obj.getSchema() != null) {
                                schemaName = obj.getSchema().getName();
                            }
                            if (dependencyOrder.contains(name = schemaName + "." + obj.getName())) {
                                toSort.add(obj);
                                continue;
                            }
                            toNotSort.add(obj);
                            continue;
                        }
                        toNotSort.add(obj);
                    }
                    Collections.sort(toSort, new Comparator<DatabaseObject>(){

                        @Override
                        public int compare(DatabaseObject o1, DatabaseObject o2) {
                            String o1Schema = null;
                            if (o1.getSchema() != null) {
                                o1Schema = o1.getSchema().getName();
                            }
                            String o2Schema = null;
                            if (o2.getSchema() != null) {
                                o2Schema = o2.getSchema().getName();
                            }
                            Integer o1Order = dependencyOrder.indexOf(o1Schema + "." + o1.getName());
                            int o2Order = dependencyOrder.indexOf(o2Schema + "." + o2.getName());
                            return o1Order.compareTo(o2Order);
                        }
                    });
                    toSort.addAll(toNotSort);
                    return toSort;
                }
            }
            catch (DatabaseException e) {
                LogFactory.getInstance().getLog().debug("Cannot get object dependencies: " + e.getMessage());
            }
        }
        return new ArrayList<DatabaseObject>(missingObjects);
    }

    protected boolean supportsSortingObjects(Database database) {
        return database instanceof DB2Database || database instanceof MSSQLDatabase;
    }

    protected void addDependencies(DependencyUtil.DependencyGraph<String> graph, List<String> schemas, Collection<DatabaseObject> missingObjects, Database database) throws DatabaseException {
        block4: {
            block3: {
                if (!(database instanceof DB2Database)) break block3;
                Executor executor = ExecutorService.getInstance().getExecutor(database);
                List<Map<String, ?>> rs = executor.queryForList(new RawSqlStatement("select TABSCHEMA, TABNAME, BSCHEMA, BNAME from syscat.tabdep where (" + StringUtils.join(schemas, " OR ", (StringUtils.StringUtilsFormatter)new StringUtils.StringUtilsFormatter<String>(){

                    @Override
                    public String toString(String obj) {
                        return "TABSCHEMA='" + obj + "'";
                    }
                }) + ")"));
                for (Map<String, ?> row : rs) {
                    String tabName = StringUtils.trimToNull((String)row.get("TABSCHEMA")) + "." + StringUtils.trimToNull((String)row.get("TABNAME"));
                    String bName = StringUtils.trimToNull((String)row.get("BSCHEMA")) + "." + StringUtils.trimToNull((String)row.get("BNAME"));
                    graph.add(bName, tabName);
                }
                break block4;
            }
            if (!(database instanceof MSSQLDatabase) || database.getDatabaseMajorVersion() < 9) break block4;
            Executor executor = ExecutorService.getInstance().getExecutor(database);
            String sql = "select object_schema_name(referencing_id) as referencing_schema_name, object_name(referencing_id) as referencing_name, object_name(referenced_id) as referenced_name, object_schema_name(referenced_id) as referenced_schema_name  from sys.sql_expression_dependencies depz where (" + StringUtils.join(schemas, " OR ", (StringUtils.StringUtilsFormatter)new StringUtils.StringUtilsFormatter<String>(){

                @Override
                public String toString(String obj) {
                    return "object_schema_name(referenced_id)='" + obj + "'";
                }
            }) + ")";
            sql = sql + " UNION select object_schema_name(object_id) as referencing_schema_name, object_name(object_id) as referencing_name, object_name(parent_object_id) as referenced_name, object_schema_name(parent_object_id) as referenced_schema_name from sys.objects where parent_object_id > 0 and is_ms_shipped=0 and (" + StringUtils.join(schemas, " OR ", (StringUtils.StringUtilsFormatter)new StringUtils.StringUtilsFormatter<String>(){

                @Override
                public String toString(String obj) {
                    return "object_schema_name(object_id)='" + obj + "'";
                }
            }) + ")";
            sql = sql + " UNION select object_schema_name(fk.object_id) as referencing_schema_name, fk.name as referencing_name, i.name as referenced_name, object_schema_name(i.object_id) as referenced_schema_name from sys.foreign_keys fk join sys.indexes i on fk.referenced_object_id=i.object_id and fk.key_index_id=i.index_id where fk.is_ms_shipped=0 and (" + StringUtils.join(schemas, " OR ", (StringUtils.StringUtilsFormatter)new StringUtils.StringUtilsFormatter<String>(){

                @Override
                public String toString(String obj) {
                    return "object_schema_name(fk.object_id)='" + obj + "'";
                }
            }) + ")";
            sql = sql + " UNION select object_schema_name(i.object_id) as referencing_schema_name, object_name(i.object_id) as referencing_name, s.name as referenced_name, null as referenced_schema_name from sys.indexes i join sys.partition_schemes s on i.data_space_id = s.data_space_id";
            sql = sql + " UNION select null as referencing_schema_name, s.name as referencing_name, f.name as referenced_name, null as referenced_schema_name from sys.partition_functions f join sys.partition_schemes s on s.function_id=f.function_id";
            sql = sql + " UNION select null as referencing_schema_name, s.name as referencing_name, fg.name as referenced_name, null as referenced_schema_name from sys.partition_schemes s join sys.destination_data_spaces ds on s.data_space_id=ds.partition_scheme_id join sys.filegroups fg on ds.data_space_id=fg.data_space_id";
            sql = sql + " UNION select distinct null as referencing_schema_name, f.name as referencing_name, ds.name as referenced_name, null as referenced_schema_name from sys.database_files f join sys.data_spaces ds on f.data_space_id=ds.data_space_id where f.data_space_id > 1";
            sql = sql + " UNION select object_schema_name(t.object_id) as referencing_schema_name, t.name as referencing_name, ds.name as referenced_name, null as referenced_schema_name from sys.tables t join sys.data_spaces ds on t.filestream_data_space_id=ds.data_space_id where t.filestream_data_space_id > 1";
            sql = sql + " UNION select object_schema_name(i.object_id) as referencing_schema_name, i.name as referencing_name, ds.name as referenced_name, null as referenced_schema_name from sys.indexes i join sys.data_spaces ds on i.data_space_id=ds.data_space_id where i.data_space_id > 1";
            sql = sql + " UNION select object_schema_name(i.object_id) as referencing_schema_name, i.name as referencing_name, object_name(i.object_id) as referenced_name, object_schema_name(i.object_id) as referenced_schema_name from sys.indexes i where " + StringUtils.join(schemas, " OR ", (StringUtils.StringUtilsFormatter)new StringUtils.StringUtilsFormatter<String>(){

                @Override
                public String toString(String obj) {
                    return "object_schema_name(i.object_id)='" + obj + "'";
                }
            });
            List<Map<String, ?>> rs = executor.queryForList(new RawSqlStatement(sql = sql + " UNION SELECT SCHEMA_NAME(SCHEMA_ID) as referencing_schema_name, name as referencing_name, PARSENAME(BASE_OBJECT_NAME,1) AS referenced_name, (CASE WHEN PARSENAME(BASE_OBJECT_NAME,2) IS NULL THEN schema_name(schema_id) else PARSENAME(BASE_OBJECT_NAME,2) END) AS referenced_schema_name FROM SYS.SYNONYMS WHERE is_ms_shipped='false' AND " + StringUtils.join(schemas, " OR ", (StringUtils.StringUtilsFormatter)new StringUtils.StringUtilsFormatter<String>(){

                @Override
                public String toString(String obj) {
                    return "SCHEMA_NAME(SCHEMA_ID)='" + obj + "'";
                }
            })));
            if (rs.size() > 0) {
                for (Map<String, ?> row : rs) {
                    String tabName;
                    String bName = StringUtils.trimToNull((String)row.get("REFERENCED_SCHEMA_NAME")) + "." + StringUtils.trimToNull((String)row.get("REFERENCED_NAME"));
                    if (bName.equals(tabName = StringUtils.trimToNull((String)row.get("REFERENCING_SCHEMA_NAME")) + "." + StringUtils.trimToNull((String)row.get("REFERENCING_NAME")))) continue;
                    graph.add(bName, tabName);
                }
            }
        }
    }

    protected List<Class<? extends DatabaseObject>> getOrderedOutputTypes(Class<? extends ChangeGenerator> generatorType) {
        Database comparisonDatabase = this.diffResult.getComparisonSnapshot().getDatabase();
        DependencyGraph graph = new DependencyGraph();
        for (Class<? extends DatabaseObject> type : this.diffResult.getReferenceSnapshot().getSnapshotControl().getTypesToInclude()) {
            graph.addType(type);
        }
        List<Class<? extends DatabaseObject>> types = graph.sort(comparisonDatabase, generatorType);
        if (!loggedOrderFor.contains(generatorType)) {
            String log = generatorType.getSimpleName() + " type order: ";
            for (Class<? extends DatabaseObject> type : types) {
                log = log + "    " + type.getName();
            }
            LogFactory.getLogger().debug(log);
            loggedOrderFor.add(generatorType);
        }
        return types;
    }

    private void addToChangeSets(Change[] changes, List<ChangeSet> changeSets, ObjectQuotingStrategy quotingStrategy, String created) {
        if (changes != null) {
            String changeSetContext = this.changeSetContext;
            if (this.diffOutputControl.getContext() != null) {
                changeSetContext = this.diffOutputControl.getContext().toString().replaceFirst("^\\(", "").replaceFirst("\\)$", "");
            }
            ChangeSet changeSet = new ChangeSet(this.generateId(changes), this.getChangeSetAuthor(), false, false, this.changeSetPath, changeSetContext, null, false, quotingStrategy, null);
            changeSet.setCreated(created);
            if (this.diffOutputControl.getLabels() != null) {
                changeSet.setLabels(this.diffOutputControl.getLabels());
            }
            for (Change change : changes) {
                changeSet.addChange(change);
            }
            changeSets.add(changeSet);
        }
    }

    protected String getChangeSetAuthor() {
        if (this.changeSetAuthor != null) {
            return this.changeSetAuthor;
        }
        String author = System.getProperty("user.name");
        if (StringUtils.trimToNull(author) == null) {
            return "diff-generated";
        }
        return author + " (generated)";
    }

    public void setChangeSetAuthor(String changeSetAuthor) {
        this.changeSetAuthor = changeSetAuthor;
    }

    public String getChangeSetPath() {
        return this.changeSetPath;
    }

    public void setChangeSetPath(String changeSetPath) {
        this.changeSetPath = changeSetPath;
    }

    public void setIdRoot(String idRoot) {
        this.idRoot = idRoot;
        this.overriddenIdRoot = true;
    }

    protected String generateId(Change[] changes) {
        String desc = "";
        if (LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getGeneratedChangeSetIdsContainDescription().booleanValue()) {
            if (!this.overriddenIdRoot) {
                this.idRoot = Long.toString(Long.decode(this.idRoot), 36);
                this.idRoot = this.idRoot.substring(this.idRoot.length() - 4);
                this.overriddenIdRoot = true;
            }
            if (changes != null && changes.length > 0) {
                desc = " (" + StringUtils.join(changes, " :: ", (StringUtils.StringUtilsFormatter)new StringUtils.StringUtilsFormatter<Change>(){

                    @Override
                    public String toString(Change obj) {
                        return obj.getDescription();
                    }
                }) + ")";
            }
            if (desc.length() > 150) {
                desc = desc.substring(0, 146) + "...)";
            }
        }
        return this.idRoot + "-" + this.changeNumber++ + desc;
    }

    private static class DependencyGraph {
        private Map<Class<? extends DatabaseObject>, Node> allNodes = new HashMap<Class<? extends DatabaseObject>, Node>();

        private DependencyGraph() {
        }

        private void addType(Class<? extends DatabaseObject> type) {
            this.allNodes.put(type, new Node(type));
        }

        public List<Class<? extends DatabaseObject>> sort(Database database, Class<? extends ChangeGenerator> generatorType) {
            ChangeGeneratorFactory changeGeneratorFactory = ChangeGeneratorFactory.getInstance();
            for (Class<? extends DatabaseObject> type : this.allNodes.keySet()) {
                for (Class<? extends DatabaseObject> clazz : changeGeneratorFactory.runBeforeTypes(type, database, generatorType)) {
                    this.getNode(type).addEdge(this.getNode(clazz));
                }
                for (Class clazz : changeGeneratorFactory.runAfterTypes(type, database, generatorType)) {
                    this.getNode(clazz).addEdge(this.getNode(type));
                }
            }
            ArrayList<Node> returnNodes = new ArrayList<Node>();
            TreeSet<Node> nodesWithNoIncomingEdges = new TreeSet<Node>(new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    return o1.type.getName().compareTo(o2.type.getName());
                }
            });
            for (Node node : this.allNodes.values()) {
                if (node.inEdges.size() != 0) continue;
                nodesWithNoIncomingEdges.add(node);
            }
            while (!nodesWithNoIncomingEdges.isEmpty()) {
                Node node = (Node)nodesWithNoIncomingEdges.iterator().next();
                nodesWithNoIncomingEdges.remove(node);
                returnNodes.add(node);
                Iterator<Edge> iterator = node.outEdges.iterator();
                while (iterator.hasNext()) {
                    Edge edge = iterator.next();
                    Node nodePointedTo = edge.to;
                    iterator.remove();
                    nodePointedTo.inEdges.remove(edge);
                    if (!nodePointedTo.inEdges.isEmpty()) continue;
                    nodesWithNoIncomingEdges.add(nodePointedTo);
                }
            }
            for (Node node : this.allNodes.values()) {
                if (node.inEdges.isEmpty()) continue;
                String message = "Could not resolve " + generatorType.getSimpleName() + " dependencies due to dependency cycle. Dependencies: \n";
                for (Node node2 : this.allNodes.values()) {
                    TreeSet<String> fromTypes = new TreeSet<String>();
                    TreeSet<String> toTypes = new TreeSet<String>();
                    for (Edge edge : node2.inEdges) {
                        fromTypes.add(edge.from.type.getSimpleName());
                    }
                    for (Edge edge : node2.outEdges) {
                        toTypes.add(edge.to.type.getSimpleName());
                    }
                    String from = StringUtils.join(fromTypes, ",");
                    String to = StringUtils.join(toTypes, ",");
                    message = message + "    [" + from + "] -> " + node2.type.getSimpleName() + " -> [" + to + "]\n";
                }
                throw new UnexpectedLiquibaseException(message);
            }
            ArrayList<Class<? extends DatabaseObject>> returnList = new ArrayList<Class<? extends DatabaseObject>>();
            for (Node node : returnNodes) {
                returnList.add(node.type);
            }
            return returnList;
        }

        private Node getNode(Class<? extends DatabaseObject> type) {
            Node node = this.allNodes.get(type);
            if (node == null) {
                node = new Node(type);
            }
            return node;
        }

        static class Edge {
            public final Node from;
            public final Node to;

            public Edge(Node from, Node to) {
                this.from = from;
                this.to = to;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof Edge)) {
                    return false;
                }
                Edge e = (Edge)obj;
                return e.from == this.from && e.to == this.to;
            }

            public int hashCode() {
                return (this.from.toString() + "." + this.to.toString()).hashCode();
            }
        }

        static class Node {
            public final Class<? extends DatabaseObject> type;
            public final HashSet<Edge> inEdges;
            public final HashSet<Edge> outEdges;

            public Node(Class<? extends DatabaseObject> type) {
                this.type = type;
                this.inEdges = new HashSet();
                this.outEdges = new HashSet();
            }

            public Node addEdge(Node node) {
                Edge e = new Edge(this, node);
                this.outEdges.add(e);
                node.inEdges.add(e);
                return this;
            }

            public String toString() {
                return this.type.getName();
            }
        }
    }
}

