/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.saml.mappers.SAMLRoleNameMapper;
import org.keycloak.provider.ProviderConfigProperty;

public class RoleNameMapper
implements SAMLRoleNameMapper,
ProtocolMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String ROLE_CONFIG = "role";
    public static String NEW_ROLE_NAME = "new.role.name";
    public static final String PROVIDER_ID = "saml-role-name-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Role Name Mapper";
    }

    public String getDisplayCategory() {
        return "Role Mapper";
    }

    public String getHelpText() {
        return "Map an assigned role to a new name";
    }

    @Override
    public String mapName(ProtocolMapperModel model, RoleModel roleModel) {
        RoleContainerModel container = roleModel.getContainer();
        ClientModel app = null;
        if (container instanceof ClientModel) {
            app = (ClientModel)container;
        }
        String role = (String)model.getConfig().get(ROLE_CONFIG);
        String newName = (String)model.getConfig().get(NEW_ROLE_NAME);
        int scopeIndex = role.indexOf(46);
        if (scopeIndex > -1 && app != null) {
            String clientId = app.getClientId();
            if (!role.startsWith(clientId + ".")) {
                return null;
            }
            role = role.substring(clientId.length() + 1);
        } else if (app != null) {
            return null;
        }
        if (roleModel.getName().equals(role)) {
            return newName;
        }
        return null;
    }

    public static ProtocolMapperModel create(String name, String role, String newName) {
        String mapperId = PROVIDER_ID;
        ProtocolMapperModel mapper = new ProtocolMapperModel();
        mapper.setName(name);
        mapper.setProtocolMapper(mapperId);
        mapper.setProtocol("saml");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(ROLE_CONFIG, role);
        config.put(NEW_ROLE_NAME, newName);
        mapper.setConfig(config);
        return mapper;
    }

    public String getProtocol() {
        return "saml";
    }

    public void close() {
    }

    public void init(Config.Scope config) {
    }

    public final ProtocolMapper create(KeycloakSession session) {
        throw new RuntimeException("UNSUPPORTED METHOD");
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(ROLE_CONFIG);
        property.setLabel("Role");
        property.setHelpText("Role name you want changed.  Click 'Select Role' button to browse roles, or just type it in the textbox.  To reference an application role the syntax is appname.approle, i.e. myapp.myrole");
        property.setType("Role");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(NEW_ROLE_NAME);
        property.setLabel("New Role Name");
        property.setHelpText("The new role name.");
        property.setType("String");
        configProperties.add(property);
    }
}

