/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.evaluation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.Realm;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.representations.idm.authorization.Logic;

public class DefaultEvaluation
implements Evaluation {
    private final ResourcePermission permission;
    private final EvaluationContext executionContext;
    private final Decision decision;
    private Policy policy;
    private final Policy parentPolicy;
    private final AuthorizationProvider authorizationProvider;
    private Map<Policy, Map<Object, Decision.Effect>> decisionCache;
    private final Realm realm;
    private Decision.Effect effect;

    public DefaultEvaluation(ResourcePermission permission, EvaluationContext executionContext, Policy parentPolicy, Decision decision, AuthorizationProvider authorizationProvider, Map<Policy, Map<Object, Decision.Effect>> decisionCache) {
        this(permission, executionContext, parentPolicy, null, decision, authorizationProvider, decisionCache);
    }

    public DefaultEvaluation(ResourcePermission permission, EvaluationContext executionContext, Decision decision, AuthorizationProvider authorizationProvider) {
        this(permission, executionContext, null, null, decision, authorizationProvider, Collections.emptyMap());
    }

    public DefaultEvaluation(ResourcePermission permission, EvaluationContext executionContext, Policy parentPolicy, Policy policy, Decision decision, AuthorizationProvider authorizationProvider, Map<Policy, Map<Object, Decision.Effect>> decisionCache) {
        this.permission = permission;
        this.executionContext = executionContext;
        this.parentPolicy = parentPolicy;
        this.policy = policy;
        this.decision = decision;
        this.authorizationProvider = authorizationProvider;
        this.decisionCache = decisionCache;
        this.realm = this.createRealm();
    }

    @Override
    public ResourcePermission getPermission() {
        return this.permission;
    }

    @Override
    public EvaluationContext getContext() {
        return this.executionContext;
    }

    @Override
    public void grant() {
        if (this.policy != null && Logic.NEGATIVE.equals((Object)this.policy.getLogic())) {
            this.setEffect(Decision.Effect.DENY);
        } else {
            this.setEffect(Decision.Effect.PERMIT);
        }
    }

    @Override
    public void deny() {
        if (this.policy != null && Logic.NEGATIVE.equals((Object)this.policy.getLogic())) {
            this.setEffect(Decision.Effect.PERMIT);
        } else {
            this.setEffect(Decision.Effect.DENY);
        }
    }

    @Override
    public Policy getPolicy() {
        if (this.policy == null) {
            return this.parentPolicy;
        }
        return this.policy;
    }

    @Override
    public Realm getRealm() {
        return this.realm;
    }

    @Override
    public AuthorizationProvider getAuthorizationProvider() {
        return this.authorizationProvider;
    }

    public Policy getParentPolicy() {
        return this.parentPolicy;
    }

    public Decision.Effect getEffect() {
        return this.effect;
    }

    public Map<Policy, Map<Object, Decision.Effect>> getDecisionCache() {
        return this.decisionCache;
    }

    @Override
    public void denyIfNoEffect() {
        if (this.effect == null) {
            this.deny();
        }
    }

    private Realm createRealm() {
        return new Realm(){

            @Override
            public boolean isUserInGroup(String id, String groupId, boolean checkParent) {
                KeycloakSession session = DefaultEvaluation.this.authorizationProvider.getKeycloakSession();
                UserModel user = this.getUser(id, session);
                if (Objects.isNull(user)) {
                    return false;
                }
                RealmModel realm = session.getContext().getRealm();
                GroupModel group = KeycloakModelUtils.findGroupByPath(realm, groupId);
                if (Objects.isNull(group)) {
                    return false;
                }
                if (checkParent) {
                    return RoleUtils.isMember((Set)user.getGroups(), (GroupModel)group);
                }
                return user.isMemberOf(group);
            }

            private UserModel getUser(String id, KeycloakSession session) {
                RealmModel realm = session.getContext().getRealm();
                UserModel user = session.users().getUserById(id, realm);
                if (Objects.isNull(user)) {
                    user = session.users().getUserByUsername(id, realm);
                }
                if (Objects.isNull(user)) {
                    user = session.users().getUserByEmail(id, realm);
                }
                if (Objects.isNull(user)) {
                    user = session.users().getServiceAccount(realm.getClientById(id));
                }
                return user;
            }

            @Override
            public boolean isUserInRealmRole(String id, String roleName) {
                KeycloakSession session = DefaultEvaluation.this.authorizationProvider.getKeycloakSession();
                UserModel user = this.getUser(id, session);
                if (Objects.isNull(user)) {
                    return false;
                }
                Set roleMappings = user.getRoleMappings().stream().filter(role -> !role.isClientRole()).collect(Collectors.toSet());
                return RoleUtils.hasRole(roleMappings, (RoleModel)session.getContext().getRealm().getRole(roleName));
            }

            @Override
            public boolean isUserInClientRole(String id, String clientId, String roleName) {
                KeycloakSession session = DefaultEvaluation.this.authorizationProvider.getKeycloakSession();
                RealmModel realm = session.getContext().getRealm();
                UserModel user = this.getUser(id, session);
                if (Objects.isNull(user)) {
                    return false;
                }
                Set roleMappings = user.getRoleMappings().stream().filter(role -> role.isClientRole() && ((ClientModel)ClientModel.class.cast(role.getContainer())).getClientId().equals(clientId)).collect(Collectors.toSet());
                if (roleMappings.isEmpty()) {
                    return false;
                }
                RoleModel role2 = realm.getClientById(((ClientModel)ClientModel.class.cast(((RoleModel)roleMappings.iterator().next()).getContainer())).getId()).getRole(roleName);
                if (Objects.isNull(role2)) {
                    return false;
                }
                return RoleUtils.hasRole(roleMappings, (RoleModel)role2);
            }

            @Override
            public boolean isGroupInRole(String id, String role) {
                KeycloakSession session = DefaultEvaluation.this.authorizationProvider.getKeycloakSession();
                RealmModel realm = session.getContext().getRealm();
                GroupModel group = KeycloakModelUtils.findGroupByPath(realm, id);
                return RoleUtils.hasRoleFromGroup((GroupModel)group, (RoleModel)realm.getRole(role), (boolean)false);
            }

            @Override
            public List<String> getUserRealmRoles(String id) {
                return this.getUser(id, DefaultEvaluation.this.authorizationProvider.getKeycloakSession()).getRoleMappings().stream().filter(role -> !role.isClientRole()).map(RoleModel::getName).collect(Collectors.toList());
            }

            @Override
            public List<String> getUserClientRoles(String id, String clientId) {
                return this.getUser(id, DefaultEvaluation.this.authorizationProvider.getKeycloakSession()).getRoleMappings().stream().filter(role -> role.isClientRole()).map(RoleModel::getName).collect(Collectors.toList());
            }

            @Override
            public List<String> getUserGroups(String id) {
                return this.getUser(id, DefaultEvaluation.this.authorizationProvider.getKeycloakSession()).getGroups().stream().map(ModelToRepresentation::buildGroupPath).collect(Collectors.toList());
            }

            @Override
            public Map<String, List<String>> getUserAttributes(String id) {
                return Collections.unmodifiableMap(this.getUser(id, DefaultEvaluation.this.authorizationProvider.getKeycloakSession()).getAttributes());
            }
        };
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
        this.effect = null;
    }

    public void setEffect(Decision.Effect effect) {
        this.effect = effect;
        this.decision.onDecision(this);
    }
}

