/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RepeatableReadEntry
extends ReadCommittedEntry {
    private static final Log log = LogFactory.getLog(RepeatableReadEntry.class);
    private static final boolean trace = log.isTraceEnabled();
    protected Object oldValue;
    protected Metadata oldMetadata;

    public RepeatableReadEntry(Object key, Object value, Metadata metadata) {
        super(key, value, metadata);
        this.oldValue = value;
        this.oldMetadata = metadata;
    }

    @Override
    public void setSkipLookup(boolean skipLookup) {
        this.setFlag(skipLookup, ReadCommittedEntry.Flags.SKIP_LOOKUP);
    }

    @Override
    public boolean skipLookup() {
        return this.isFlagSet(ReadCommittedEntry.Flags.SKIP_LOOKUP);
    }

    @Override
    public RepeatableReadEntry clone() {
        return (RepeatableReadEntry)super.clone();
    }

    @Override
    public final Object setValue(Object value) {
        super.setValue(value);
        this.setSkipLookup(true);
        return this.oldValue;
    }

    @Override
    public void resetCurrentValue() {
        this.value = this.oldValue;
        this.metadata = this.oldMetadata;
    }

    @Override
    public void updatePreviousValue() {
        this.oldValue = this.value;
        this.oldMetadata = this.metadata;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Metadata getOldMetadata() {
        return this.oldMetadata;
    }

    @Override
    public void setRead() {
        this.setFlag(ReadCommittedEntry.Flags.READ);
    }

    @Override
    public boolean isRead() {
        return this.isFlagSet(ReadCommittedEntry.Flags.READ);
    }
}

