/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.ConsumerThread;
import org.apache.activemq.artemis.cli.commands.messages.DestAbstract;

@Command(name="browser", description="It will browse messages on an instance")
public class Browse
extends DestAbstract {
    @Option(name={"--filter"}, description="filter to be used with the consumer")
    String filter;

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        System.out.println("Consumer:: filter = " + this.filter);
        ConnectionFactory factory = this.createConnectionFactory();
        try {
            try (Connection connection = factory.createConnection();){
                ConsumerThread[] threadsArray = new ConsumerThread[this.threads];
                for (int i = 0; i < this.threads; ++i) {
                    Session session = this.txBatchSize > 0 ? connection.createSession(true, 0) : connection.createSession(false, 1);
                    Destination dest = this.lookupDestination(session);
                    threadsArray[i] = new ConsumerThread(session, dest, i);
                    threadsArray[i].setVerbose(this.verbose).setSleep(this.sleep).setMessageCount(this.messageCount).setFilter(this.filter).setBrowse(true);
                }
                for (ConsumerThread thread : threadsArray) {
                    thread.start();
                }
                connection.start();
                int received = 0;
                for (ConsumerThread thread : threadsArray) {
                    thread.join();
                    received += thread.getReceived();
                }
                Object object = received;
                return object;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (factory instanceof AutoCloseable) {
                ((AutoCloseable)factory).close();
            }
        }
    }
}

