/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.idm.parsers;

import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.parsers.AbstractParser;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.config.idm.ConfigBuilderMethodType;
import org.picketlink.config.idm.IDMType;

public class IDMConfigParser
extends AbstractParser {
    public static final String ROOT_ELEMENT = "PicketLinkIDM";

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)ROOT_ELEMENT);
        IDMType idmType = new IDMType();
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            if (xmlEvent instanceof StartElement) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                String methodName = StaxParserUtil.getStartElementName((StartElement)startElement);
                LinkedHashMap<String, String> methodParams = new LinkedHashMap<String, String>();
                Iterator<Attribute> attributes = startElement.getAttributes();
                while (attributes.hasNext()) {
                    Attribute attribute = attributes.next();
                    String attrName = attribute.getName().getLocalPart();
                    String attrValue = StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true);
                    methodParams.put(attrName, attrValue);
                }
                ConfigBuilderMethodType configBuilderMethod = new ConfigBuilderMethodType(methodName, methodParams);
                idmType.addConfigBuilderMethod(configBuilderMethod);
                continue;
            }
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (!endElementName.equals(ROOT_ELEMENT)) continue;
                break;
            }
            StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
        }
        return idmType;
    }

    public boolean supports(QName qname) {
        return false;
    }
}

