/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.entities;

import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.keycloak.authorization.jpa.entities.PolicyEntity;
import org.keycloak.authorization.jpa.entities.ResourceEntity;
import org.keycloak.authorization.jpa.entities.ResourceServerEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;

@Entity
@Table(name="RESOURCE_SERVER_PERM_TICKET", uniqueConstraints={@UniqueConstraint(columnNames={"OWNER", "RESOURCE_SERVER_ID", "RESOURCE_ID", "SCOPE_ID"})})
@NamedQueries(value={@NamedQuery(name="findPermissionIdByResource", query="select p.id from PermissionTicketEntity p inner join p.resource r where p.resourceServer.id = :serverId and (r.resourceServer.id = :serverId and r.id = :resourceId)"), @NamedQuery(name="findPermissionIdByScope", query="select p.id from PermissionTicketEntity p inner join p.scope s where p.resourceServer.id = :serverId and (s.resourceServer.id = :serverId and s.id = :scopeId)"), @NamedQuery(name="findPermissionTicketIdByServerId", query="select p.id from PermissionTicketEntity p where  p.resourceServer.id = :serverId "), @NamedQuery(name="findGrantedResources", query="select distinct(r.id) from ResourceEntity r inner join PermissionTicketEntity p on r.id = p.resource.id where p.grantedTimestamp is not null and p.requester = :requester order by r.id"), @NamedQuery(name="findGrantedResourcesByName", query="select distinct(r.id) from ResourceEntity r inner join PermissionTicketEntity p on r.id = p.resource.id where p.grantedTimestamp is not null and p.requester = :requester and lower(r.name) like :resourceName order by r.id"), @NamedQuery(name="findGrantedOwnerResources", query="select distinct(r.id) from ResourceEntity r inner join PermissionTicketEntity p on r.id = p.resource.id where p.grantedTimestamp is not null and p.owner = :owner order by r.id")})
public class PermissionTicketEntity {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    private String id;
    @Column(name="OWNER")
    private String owner;
    @Column(name="REQUESTER")
    private String requester;
    @Column(name="CREATED_TIMESTAMP")
    private Long createdTimestamp;
    @Column(name="GRANTED_TIMESTAMP")
    private Long grantedTimestamp;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="RESOURCE_ID")
    private ResourceEntity resource;
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="SCOPE_ID")
    private ScopeEntity scope;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="RESOURCE_SERVER_ID")
    private ResourceServerEntity resourceServer;
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="POLICY_ID")
    private PolicyEntity policy;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public ResourceEntity getResource() {
        return this.resource;
    }

    public void setResource(ResourceEntity resource) {
        this.resource = resource;
    }

    public ScopeEntity getScope() {
        return this.scope;
    }

    public void setScope(ScopeEntity scope) {
        this.scope = scope;
    }

    public ResourceServerEntity getResourceServer() {
        return this.resourceServer;
    }

    public void setResourceServer(ResourceServerEntity resourceServer) {
        this.resourceServer = resourceServer;
    }

    public void setRequester(String requester) {
        this.requester = requester;
    }

    public String getRequester() {
        return this.requester;
    }

    public Long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public void setCreatedTimestamp(Long createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    public Long getGrantedTimestamp() {
        return this.grantedTimestamp;
    }

    public void setGrantedTimestamp(long grantedTimestamp) {
        this.grantedTimestamp = grantedTimestamp;
    }

    public boolean isGranted() {
        return this.grantedTimestamp != null;
    }

    public PolicyEntity getPolicy() {
        return this.policy;
    }

    public void setPolicy(PolicyEntity policy) {
        this.policy = policy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionTicketEntity that = (PermissionTicketEntity)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

