/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.Properties;
import org.codehaus.jackson.JsonNode;
import org.keycloak.Config;
import org.keycloak.util.StringPropertyReplacer;

public class JsonConfigProvider
implements Config.ConfigProvider {
    private Properties properties;
    private JsonNode config;

    public JsonConfigProvider(JsonNode config, Properties properties) {
        this.config = config;
        this.properties = properties;
    }

    public String getProvider(String spi) {
        JsonNode n = JsonConfigProvider.getNode(this.config, spi, "provider");
        return n != null ? this.replaceProperties(n.getTextValue()) : null;
    }

    public Config.Scope scope(String ... path) {
        return new JsonScope(JsonConfigProvider.getNode(this.config, path));
    }

    private static JsonNode getNode(JsonNode root, String ... path) {
        if (root == null) {
            return null;
        }
        JsonNode n = root;
        for (String p : path) {
            if ((n = n.get(p)) != null) continue;
            return null;
        }
        return n;
    }

    private String replaceProperties(String value) {
        return StringPropertyReplacer.replaceProperties((String)value, (Properties)this.properties);
    }

    public class JsonScope
    implements Config.Scope {
        private JsonNode config;

        public JsonScope(JsonNode config) {
            this.config = config;
        }

        public String get(String key) {
            return this.get(key, null);
        }

        public String get(String key, String defaultValue) {
            if (this.config == null) {
                return defaultValue;
            }
            JsonNode n = this.config.get(key);
            if (n == null) {
                return defaultValue;
            }
            return JsonConfigProvider.this.replaceProperties(n.getTextValue());
        }

        public String[] getArray(String key) {
            if (this.config == null) {
                return null;
            }
            JsonNode n = this.config.get(key);
            if (n == null) {
                return null;
            }
            if (n.isArray()) {
                String[] a = new String[n.size()];
                for (int i = 0; i < a.length; ++i) {
                    a[i] = JsonConfigProvider.this.replaceProperties(n.get(i).getTextValue());
                }
                return a;
            }
            return new String[]{JsonConfigProvider.this.replaceProperties(n.getTextValue())};
        }

        public Integer getInt(String key) {
            return this.getInt(key, null);
        }

        public Integer getInt(String key, Integer defaultValue) {
            if (this.config == null) {
                return defaultValue;
            }
            JsonNode n = this.config.get(key);
            if (n == null) {
                return defaultValue;
            }
            if (n.isTextual()) {
                return Integer.parseInt(JsonConfigProvider.this.replaceProperties(n.getTextValue()));
            }
            return n.getIntValue();
        }

        public Long getLong(String key) {
            return this.getLong(key, null);
        }

        public Long getLong(String key, Long defaultValue) {
            if (this.config == null) {
                return defaultValue;
            }
            JsonNode n = this.config.get(key);
            if (n == null) {
                return defaultValue;
            }
            if (n.isTextual()) {
                return Long.parseLong(JsonConfigProvider.this.replaceProperties(n.getTextValue()));
            }
            return n.getLongValue();
        }

        public Boolean getBoolean(String key) {
            return this.getBoolean(key, null);
        }

        public Boolean getBoolean(String key, Boolean defaultValue) {
            if (this.config == null) {
                return defaultValue;
            }
            JsonNode n = this.config.get(key);
            if (n == null) {
                return defaultValue;
            }
            if (n.isTextual()) {
                return Boolean.parseBoolean(JsonConfigProvider.this.replaceProperties(n.getTextValue()));
            }
            return n.getBooleanValue();
        }

        public Config.Scope scope(String ... path) {
            return new JsonScope(JsonConfigProvider.getNode(this.config, path));
        }
    }
}

