/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap;

import org.jboss.logging.Logger;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.LDAPUtils;
import org.keycloak.federation.ldap.idm.model.LDAPUser;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;

public class WritableLDAPUserModelDelegate
extends UserModelDelegate
implements UserModel {
    private static final Logger logger = Logger.getLogger(WritableLDAPUserModelDelegate.class);
    protected LDAPFederationProvider provider;

    public WritableLDAPUserModelDelegate(UserModel delegate, LDAPFederationProvider provider) {
        super(delegate);
        this.provider = provider;
    }

    public void setUsername(String username) {
        LDAPIdentityStore ldapIdentityStore = this.provider.getLdapIdentityStore();
        LDAPUser ldapUser = LDAPUtils.getUser(ldapIdentityStore, this.delegate.getUsername());
        if (ldapUser == null) {
            throw new IllegalStateException("User not found in LDAP storage!");
        }
        ldapUser.setLoginName(username);
        ldapIdentityStore.update(ldapUser);
        this.delegate.setUsername(username);
    }

    public void setLastName(String lastName) {
        LDAPIdentityStore ldapIdentityStore = this.provider.getLdapIdentityStore();
        LDAPUser ldapUser = LDAPUtils.getUser(ldapIdentityStore, this.delegate.getUsername());
        if (ldapUser == null) {
            throw new IllegalStateException("User not found in LDAP storage!");
        }
        ldapUser.setLastName(lastName);
        ldapIdentityStore.update(ldapUser);
        this.delegate.setLastName(lastName);
    }

    public void setFirstName(String first) {
        LDAPIdentityStore ldapIdentityStore = this.provider.getLdapIdentityStore();
        LDAPUser ldapUser = LDAPUtils.getUser(ldapIdentityStore, this.delegate.getUsername());
        if (ldapUser == null) {
            throw new IllegalStateException("User not found in LDAP storage!");
        }
        ldapUser.setFirstName(first);
        ldapIdentityStore.update(ldapUser);
        this.delegate.setFirstName(first);
    }

    public void updateCredential(UserCredentialModel cred) {
        if (!this.provider.getSupportedCredentialTypes(this.delegate).contains(cred.getType())) {
            this.delegate.updateCredential(cred);
            return;
        }
        LDAPIdentityStore ldapIdentityStore = this.provider.getLdapIdentityStore();
        LDAPUser ldapUser = LDAPUtils.getUser(ldapIdentityStore, this.delegate.getUsername());
        if (ldapUser == null) {
            throw new IllegalStateException("User " + this.delegate.getUsername() + " not found in LDAP storage!");
        }
        if (cred.getType().equals("password")) {
            LDAPUtils.updatePassword(ldapIdentityStore, this.delegate, cred.getValue());
        } else {
            logger.warnf("Don't know how to update credential of type [%s] for user [%s]", (Object)cred.getType(), (Object)this.delegate.getUsername());
        }
    }

    public void setEmail(String email) {
        LDAPIdentityStore ldapIdentityStore = this.provider.getLdapIdentityStore();
        LDAPUser ldapUser = LDAPUtils.getUser(ldapIdentityStore, this.delegate.getUsername());
        if (ldapUser == null) {
            throw new IllegalStateException("User not found in LDAP storage!");
        }
        ldapUser.setEmail(email);
        ldapIdentityStore.update(ldapUser);
        this.delegate.setEmail(email);
    }
}

