/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import twitter4j.TwitterException;
import twitter4j.conf.ConfigurationContext;
import twitter4j.internal.http.HttpClientConfiguration;
import twitter4j.internal.http.HttpResponseImpl;
import twitter4j.internal.logging.Logger;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.org.json.JSONTokener;

public abstract class HttpResponse {
    private static final Logger logger = Logger.getLogger(HttpResponseImpl.class);
    protected final HttpClientConfiguration CONF;
    protected int statusCode;
    protected String responseAsString = null;
    protected InputStream is;
    private boolean streamConsumed = false;
    private JSONObject json = null;
    private JSONArray jsonArray = null;

    HttpResponse() {
        this.CONF = ConfigurationContext.getInstance();
    }

    public HttpResponse(HttpClientConfiguration conf) {
        this.CONF = conf;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public abstract String getResponseHeader(String var1);

    public abstract Map<String, List<String>> getResponseHeaderFields();

    public InputStream asStream() {
        if (this.streamConsumed) {
            throw new IllegalStateException("Stream has already been consumed.");
        }
        return this.is;
    }

    public String asString() throws TwitterException {
        if (null == this.responseAsString) {
            BufferedReader br = null;
            InputStream stream = null;
            try {
                String line;
                stream = this.asStream();
                if (null == stream) {
                    String string = null;
                    return string;
                }
                br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                StringBuilder buf = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    buf.append(line).append("\n");
                }
                this.responseAsString = buf.toString();
                logger.debug(this.responseAsString);
                stream.close();
                this.streamConsumed = true;
            }
            catch (IOException ioe) {
                throw new TwitterException(ioe.getMessage(), ioe);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException ignore) {}
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ignore) {}
                }
                this.disconnectForcibly();
            }
        }
        return this.responseAsString;
    }

    public JSONObject asJSONObject() throws TwitterException {
        if (this.json == null) {
            Reader reader = null;
            try {
                if (this.responseAsString == null) {
                    reader = this.asReader();
                    this.json = new JSONObject(new JSONTokener(reader));
                } else {
                    this.json = new JSONObject(this.responseAsString);
                }
                if (this.CONF.isPrettyDebugEnabled()) {
                    logger.debug(this.json.toString(1));
                } else {
                    logger.debug(this.responseAsString != null ? this.responseAsString : this.json.toString());
                }
            }
            catch (JSONException jsone) {
                if (this.responseAsString == null) {
                    throw new TwitterException(jsone.getMessage(), jsone);
                }
                throw new TwitterException(jsone.getMessage() + ":" + this.responseAsString, jsone);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ignore) {}
                }
                this.disconnectForcibly();
            }
        }
        return this.json;
    }

    public JSONArray asJSONArray() throws TwitterException {
        if (this.jsonArray == null) {
            Reader reader = null;
            try {
                if (this.responseAsString == null) {
                    reader = this.asReader();
                    this.jsonArray = new JSONArray(new JSONTokener(reader));
                } else {
                    this.jsonArray = new JSONArray(this.responseAsString);
                }
                if (this.CONF.isPrettyDebugEnabled()) {
                    logger.debug(this.jsonArray.toString(1));
                } else {
                    logger.debug(this.responseAsString != null ? this.responseAsString : this.jsonArray.toString());
                }
            }
            catch (JSONException jsone) {
                if (logger.isDebugEnabled()) {
                    throw new TwitterException(jsone.getMessage() + ":" + this.responseAsString, jsone);
                }
                throw new TwitterException(jsone.getMessage(), jsone);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ignore) {}
                }
                this.disconnectForcibly();
            }
        }
        return this.jsonArray;
    }

    public Reader asReader() {
        try {
            return new BufferedReader(new InputStreamReader(this.is, "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            return new InputStreamReader(this.is);
        }
    }

    private void disconnectForcibly() {
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract void disconnect() throws IOException;

    public String toString() {
        return "HttpResponse{statusCode=" + this.statusCode + ", responseAsString='" + this.responseAsString + '\'' + ", is=" + this.is + ", streamConsumed=" + this.streamConsumed + '}';
    }
}

