/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.ParameterRole;
import freemarker.core.ParseException;
import freemarker.core.TemplateElement;
import freemarker.core._MiscTemplateException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;

public final class LibraryLoad
extends TemplateElement {
    private Expression templateName;
    private String namespace;
    private final String templatePath;

    LibraryLoad(Template template, Expression templateName, String namespace) {
        int lastSlash;
        this.namespace = namespace;
        String templatePath1 = template.getName();
        if (templatePath1 == null) {
            templatePath1 = "";
        }
        this.templatePath = (lastSlash = templatePath1.lastIndexOf(47)) == -1 ? "" : templatePath1.substring(0, lastSlash + 1);
        this.templateName = templateName;
    }

    void accept(Environment env) throws TemplateException, IOException {
        Template importedTemplate;
        String templateNameString = this.templateName.evalAndCoerceToString(env);
        try {
            if (!env.isClassicCompatible() && templateNameString.indexOf("://") <= 0) {
                int protIndex;
                templateNameString = templateNameString.length() > 0 && templateNameString.charAt(0) == '/' ? ((protIndex = this.templatePath.indexOf("://")) > 0 ? this.templatePath.substring(0, protIndex + 2) + templateNameString : templateNameString.substring(1)) : this.templatePath + templateNameString;
            }
            importedTemplate = env.getTemplateForImporting(templateNameString);
        }
        catch (ParseException pe) {
            throw new _MiscTemplateException((Throwable)pe, env, new Object[]{"Error parsing imported template ", templateNameString});
        }
        catch (IOException ioe) {
            throw new _MiscTemplateException((Throwable)ioe, env, new Object[]{"Error reading imported template ", templateNameString});
        }
        env.importLib(importedTemplate, this.namespace);
    }

    protected String dump(boolean canonical) {
        StringBuffer buf = new StringBuffer();
        if (canonical) {
            buf.append('<');
        }
        buf.append(this.getNodeTypeSymbol());
        buf.append(' ');
        buf.append(this.templateName);
        buf.append(" as ");
        buf.append(this.namespace);
        if (canonical) {
            buf.append("/>");
        }
        return buf.toString();
    }

    String getNodeTypeSymbol() {
        return "#import";
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.templateName;
            }
            case 1: {
                return this.namespace;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.TEMPLATE_NAME;
            }
            case 1: {
                return ParameterRole.NAMESPACE;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public String getTemplateName() {
        return this.templateName.toString();
    }
}

