/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.ParameterRole;
import freemarker.core.ParseException;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;

final class MixedContent
extends TemplateElement {
    MixedContent() {
        this.nestedElements = new ArrayList();
    }

    void addElement(TemplateElement element) {
        this.nestedElements.add(element);
    }

    TemplateElement postParseCleanup(boolean stripWhitespace) throws ParseException {
        super.postParseCleanup(stripWhitespace);
        if (this.nestedElements.size() == 1) {
            return (TemplateElement)this.nestedElements.get(0);
        }
        return this;
    }

    void accept(Environment env) throws TemplateException, IOException {
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            TemplateElement element = (TemplateElement)this.nestedElements.get(i);
            env.visit(element);
        }
    }

    protected String dump(boolean canonical) {
        if (canonical) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.nestedElements.size(); ++i) {
                TemplateElement element = (TemplateElement)this.nestedElements.get(i);
                buf.append(element.getCanonicalForm());
            }
            return buf.toString();
        }
        if (this.parent == null) {
            return "root";
        }
        return this.getNodeTypeSymbol();
    }

    String getNodeTypeSymbol() {
        return "#mixed_content";
    }

    int getParameterCount() {
        return 0;
    }

    Object getParameterValue(int idx) {
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        throw new IndexOutOfBoundsException();
    }

    boolean isShownInStackTrace() {
        return false;
    }

    boolean isIgnorable() {
        return this.nestedElements == null || this.nestedElements.size() == 0;
    }
}

