/*
 * Decompiled with CFR 0.152.
 */
package freemarker.log;

import freemarker.log.LoggerFactory;
import freemarker.log._NullLoggerFactory;
import freemarker.template.utility.ClassUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class Logger {
    public static final int LIBRARY_AUTO = -1;
    public static final int LIBRARY_NONE = 0;
    public static final int LIBRARY_JAVA = 1;
    public static final int LIBRARY_AVALON = 2;
    public static final int LIBRARY_LOG4J = 3;
    public static final int LIBRARY_COMMONS = 4;
    public static final int LIBRARY_SLF4J = 5;
    private static final String[] LIBINIT = new String[]{"freemarker.log.Logger", "_Null", "java.util.logging.Logger", "_JDK14", "org.apache.log.Logger", "_Avalon", "org.apache.log4j.Logger", "_Log4J", "org.apache.commons.logging.Log", "CommonsLogging", "org.slf4j.Logger", "SLF4J"};
    private static int logLibrary;
    private static LoggerFactory factory;
    private static String categoryPrefix;
    private static final Map loggers;
    static /* synthetic */ Class class$freemarker$log$Logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void selectLoggerLibrary(int library) throws ClassNotFoundException {
        Class clazz = class$freemarker$log$Logger == null ? (class$freemarker$log$Logger = Logger.class$("freemarker.log.Logger")) : class$freemarker$log$Logger;
        synchronized (clazz) {
            if (library < -1 || library * 2 >= LIBINIT.length) {
                throw new IllegalArgumentException();
            }
            logLibrary = library;
            factory = Logger.createFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCategoryPrefix(String prefix) {
        Class clazz = class$freemarker$log$Logger == null ? (class$freemarker$log$Logger = Logger.class$("freemarker.log.Logger")) : class$freemarker$log$Logger;
        synchronized (clazz) {
            if (prefix == null) {
                throw new IllegalArgumentException();
            }
            categoryPrefix = prefix;
        }
    }

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void info(String var1);

    public abstract void info(String var1, Throwable var2);

    public abstract void warn(String var1);

    public abstract void warn(String var1, Throwable var2);

    public abstract void error(String var1);

    public abstract void error(String var1, Throwable var2);

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isWarnEnabled();

    public abstract boolean isErrorEnabled();

    public abstract boolean isFatalEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String category) {
        Object object;
        if (factory == null) {
            object = class$freemarker$log$Logger == null ? (class$freemarker$log$Logger = Logger.class$("freemarker.log.Logger")) : class$freemarker$log$Logger;
            synchronized (object) {
                if (factory == null) {
                    try {
                        Logger.selectLoggerLibrary(-1);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e.getMessage());
                    }
                }
            }
        }
        category = categoryPrefix + category;
        object = loggers;
        synchronized (object) {
            Logger logger = (Logger)loggers.get(category);
            if (logger == null) {
                logger = factory.getLogger(category);
                loggers.put(category, logger);
            }
            return logger;
        }
    }

    private static LoggerFactory createFactory() throws ClassNotFoundException {
        if (logLibrary == -1) {
            for (int i = LIBINIT.length / 2 - 1; i > 0; --i) {
                if (i == 5 || i == 4) continue;
                try {
                    return Logger.createFactory(i);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            System.err.println("*** WARNING: FreeMarker logging suppressed.");
            return new _NullLoggerFactory();
        }
        return Logger.createFactory(logLibrary);
    }

    private static LoggerFactory createFactory(int library) throws ClassNotFoundException {
        String loggerClassName = LIBINIT[library * 2];
        String factoryType = LIBINIT[library * 2 + 1];
        try {
            ClassUtil.forName(loggerClassName);
            return (LoggerFactory)Class.forName("freemarker.log." + factoryType + "LoggerFactory").newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new InstantiationError(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        categoryPrefix = "";
        loggers = new HashMap();
    }
}

