/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.facebook;

import org.codehaus.jackson.JsonNode;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.util.JsonSimpleHttp;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.social.SocialIdentityProvider;

public class FacebookIdentityProvider
extends AbstractOAuth2IdentityProvider
implements SocialIdentityProvider {
    public static final String AUTH_URL = "https://graph.facebook.com/oauth/authorize";
    public static final String TOKEN_URL = "https://graph.facebook.com/oauth/access_token";
    public static final String PROFILE_URL = "https://graph.facebook.com/me";
    public static final String DEFAULT_SCOPE = "email";

    public FacebookIdentityProvider(OAuth2IdentityProviderConfig config) {
        super(config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(PROFILE_URL);
    }

    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        try {
            JsonNode profile = JsonSimpleHttp.asJson((SimpleHttp)SimpleHttp.doGet((String)PROFILE_URL).header("Authorization", "Bearer " + accessToken));
            String id = this.getJsonProperty(profile, "id");
            BrokeredIdentityContext user = new BrokeredIdentityContext(id);
            String email = this.getJsonProperty(profile, DEFAULT_SCOPE);
            user.setEmail(email);
            String username = this.getJsonProperty(profile, "username");
            if (username == null) {
                username = email != null ? email : id;
            }
            user.setUsername(username);
            String firstName = this.getJsonProperty(profile, "first_name");
            String lastName = this.getJsonProperty(profile, "last_name");
            lastName = lastName == null ? "" : " " + lastName;
            user.setName(firstName + lastName);
            user.setIdpConfig((IdentityProviderModel)this.getConfig());
            user.setIdp((IdentityProvider)this);
            return user;
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user profile from facebook.", (Throwable)e);
        }
    }

    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }
}

