/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.resource.ClassLoaderResourceAccessor;

public class CommandLineResourceAccessor
extends ClassLoaderResourceAccessor {
    public CommandLineResourceAccessor(ClassLoader loader) {
        super(loader);
    }

    @Override
    public Set<InputStream> getResourcesAsStream(String path) throws IOException {
        Set<InputStream> resourcesAsStream = super.getResourcesAsStream(path);
        if (resourcesAsStream == null) {
            for (String altPath : this.getAlternatePaths(path)) {
                resourcesAsStream = super.getResourcesAsStream(altPath);
                if (resourcesAsStream == null) continue;
                return resourcesAsStream;
            }
        }
        return resourcesAsStream;
    }

    @Override
    public Set<String> list(String relativeTo, String path, boolean includeFiles, boolean includeDirectories, boolean recursive) throws IOException {
        HashSet<String> contents = new HashSet<String>();
        contents.addAll(super.list(relativeTo, path, includeFiles, includeDirectories, recursive));
        for (String altPath : this.getAlternatePaths(path)) {
            contents.addAll(super.list(relativeTo, altPath, includeFiles, includeDirectories, recursive));
        }
        if (contents.size() == 0) {
            return null;
        }
        return contents;
    }

    protected List<String> getAlternatePaths(String path) {
        ArrayList<String> alternatePaths = new ArrayList<String>();
        if (path.startsWith("/")) {
            alternatePaths.add(path.substring(1));
        }
        return alternatePaths;
    }
}

