/*
 * Decompiled with CFR 0.152.
 */
package liquibase.serializer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.serializer.ReflectionSerializer;
import liquibase.util.ObjectUtil;

public abstract class AbstractLiquibaseSerializable
implements LiquibaseSerializable {
    private Set<String> serializableFields;

    @Override
    public void load(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        for (ParsedNode childNode : parsedNode.getChildren()) {
            if (!this.shouldAutoLoad(childNode)) continue;
            try {
                if (!this.getSerializableFields().contains(childNode.getName())) continue;
                Object value = childNode.getValue();
                if (value != null) {
                    value = value.toString();
                }
                ObjectUtil.setProperty(this, childNode.getName(), (String)value);
            }
            catch (Exception e) {
                throw new ParsedNodeException("Error setting property", e);
            }
        }
        if (parsedNode.getValue() != null) {
            for (String field : this.getSerializableFields()) {
                if (this.getSerializableFieldType(field) != LiquibaseSerializable.SerializationType.DIRECT_VALUE) continue;
                ObjectUtil.setProperty(this, field, parsedNode.getValue(String.class));
            }
        }
    }

    protected boolean shouldAutoLoad(ParsedNode node) {
        return true;
    }

    @Override
    public ParsedNode serialize() throws ParsedNodeException {
        ParsedNode node = new ParsedNode(null, this.getSerializedObjectName());
        for (String field : this.getSerializableFields()) {
            Object fieldValue = this.getSerializableFieldValue(field);
            if ((fieldValue = this.serializeValue(fieldValue)) == null) continue;
            LiquibaseSerializable.SerializationType type = this.getSerializableFieldType(field);
            if (type == LiquibaseSerializable.SerializationType.DIRECT_VALUE) {
                node.setValue(fieldValue);
                continue;
            }
            if (type == LiquibaseSerializable.SerializationType.NAMED_FIELD || type == LiquibaseSerializable.SerializationType.NESTED_OBJECT) {
                if (fieldValue instanceof ParsedNode) {
                    node.addChild((ParsedNode)fieldValue);
                    continue;
                }
                node.addChild(new ParsedNode(null, field).setValue(fieldValue));
                continue;
            }
            throw new UnexpectedLiquibaseException("Unknown type: " + (Object)((Object)type));
        }
        return node;
    }

    @Override
    public Set<String> getSerializableFields() {
        return ReflectionSerializer.getInstance().getFields(this);
    }

    @Override
    public Object getSerializableFieldValue(String field) {
        return ReflectionSerializer.getInstance().getValue(this, field);
    }

    @Override
    public LiquibaseSerializable.SerializationType getSerializableFieldType(String field) {
        return LiquibaseSerializable.SerializationType.NAMED_FIELD;
    }

    protected Object serializeValue(Object value) throws ParsedNodeException {
        if (value instanceof Collection) {
            ArrayList<Object> returnList = new ArrayList<Object>();
            for (Object obj : (Collection)value) {
                Object objValue = this.serializeValue(obj);
                if (objValue == null) continue;
                returnList.add(objValue);
            }
            if (((Collection)value).size() == 0) {
                return null;
            }
            return returnList;
        }
        if (value instanceof LiquibaseSerializable) {
            return ((LiquibaseSerializable)value).serialize();
        }
        return value;
    }

    @Override
    public String getSerializableFieldNamespace(String field) {
        return this.getSerializedObjectNamespace();
    }
}

