/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.NodesRegistrationManagement;
import org.keycloak.adapters.undertow.AbstractUndertowKeycloakAuthMech;
import org.keycloak.adapters.undertow.UndertowHttpFacade;
import org.keycloak.adapters.undertow.UndertowRequestAuthenticator;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;

public class UndertowAuthenticationMechanism
extends AbstractUndertowKeycloakAuthMech {
    protected NodesRegistrationManagement nodesRegistrationManagement;
    protected int confidentialPort;

    public UndertowAuthenticationMechanism(AdapterDeploymentContext deploymentContext, UndertowUserSessionManagement sessionManagement, NodesRegistrationManagement nodesRegistrationManagement, int confidentialPort, String errorPage) {
        super(deploymentContext, sessionManagement, errorPage);
        this.nodesRegistrationManagement = nodesRegistrationManagement;
        this.confidentialPort = confidentialPort;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        UndertowHttpFacade facade = new UndertowHttpFacade(exchange);
        KeycloakDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        if (!deployment.isConfigured()) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        this.nodesRegistrationManagement.tryRegister(deployment);
        AdapterTokenStore tokenStore = this.getTokenStore(exchange, facade, deployment, securityContext);
        UndertowRequestAuthenticator authenticator = new UndertowRequestAuthenticator(facade, deployment, this.confidentialPort, securityContext, exchange, tokenStore);
        return this.keycloakAuthenticate(exchange, securityContext, authenticator);
    }
}

