/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache;

import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.models.cache.RealmCache;
import org.keycloak.models.cache.entities.CachedClient;
import org.keycloak.models.cache.entities.CachedRealm;
import org.keycloak.models.cache.entities.CachedRole;

public class MemoryRealmCache
implements RealmCache {
    protected ConcurrentHashMap<String, CachedRealm> realmCache = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, CachedRealm> realmCacheByName = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, CachedClient> applicationCache = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, CachedRole> roleCache = new ConcurrentHashMap();
    protected volatile boolean enabled = true;

    @Override
    public void clear() {
        this.realmCache.clear();
        this.realmCacheByName.clear();
        this.applicationCache.clear();
        this.roleCache.clear();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.clear();
        this.enabled = enabled;
        this.clear();
    }

    @Override
    public CachedRealm getCachedRealm(String id) {
        if (!this.enabled) {
            return null;
        }
        return this.realmCache.get(id);
    }

    @Override
    public void invalidateCachedRealm(CachedRealm realm) {
        this.realmCache.remove(realm.getId());
        this.realmCacheByName.remove(realm.getName());
    }

    @Override
    public void invalidateCachedRealmById(String id) {
        CachedRealm cached = this.realmCache.remove(id);
        if (cached != null) {
            this.realmCacheByName.remove(cached.getName());
        }
    }

    @Override
    public void addCachedRealm(CachedRealm realm) {
        if (!this.enabled) {
            return;
        }
        this.realmCache.put(realm.getId(), realm);
        this.realmCacheByName.put(realm.getName(), realm);
    }

    @Override
    public CachedRealm getCachedRealmByName(String name) {
        if (!this.enabled) {
            return null;
        }
        return this.realmCacheByName.get(name);
    }

    @Override
    public CachedClient getApplication(String id) {
        if (!this.enabled) {
            return null;
        }
        return this.applicationCache.get(id);
    }

    @Override
    public void invalidateApplication(CachedClient app) {
        this.applicationCache.remove(app.getId());
    }

    @Override
    public void addCachedClient(CachedClient app) {
        if (!this.enabled) {
            return;
        }
        this.applicationCache.put(app.getId(), app);
    }

    @Override
    public void invalidateCachedApplicationById(String id) {
        this.applicationCache.remove(id);
    }

    @Override
    public CachedRole getRole(String id) {
        if (!this.enabled) {
            return null;
        }
        return this.roleCache.get(id);
    }

    @Override
    public void invalidateRole(CachedRole role) {
        this.roleCache.remove(role);
    }

    @Override
    public void invalidateRoleById(String id) {
        this.roleCache.remove(id);
    }

    @Override
    public void addCachedRole(CachedRole role) {
        if (!this.enabled) {
            return;
        }
        this.roleCache.put(role.getId(), role);
    }

    @Override
    public void invalidateCachedRoleById(String id) {
        this.roleCache.remove(id);
    }
}

