/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.federation.ldap.idm.model.LDAPUser;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPIdentityStoreConfiguration;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPMappingConfiguration;
import org.keycloak.models.UserFederationProviderModel;

public class LDAPIdentityStoreRegistry {
    private static final Logger logger = Logger.getLogger(LDAPIdentityStoreRegistry.class);
    private Map<String, LDAPIdentityStoreContext> ldapStores = new ConcurrentHashMap<String, LDAPIdentityStoreContext>();

    public LDAPIdentityStore getLdapStore(UserFederationProviderModel model) {
        LDAPIdentityStoreContext context = this.ldapStores.get(model.getId());
        Map config = model.getConfig();
        if (context == null || !config.equals(context.config)) {
            this.logLDAPConfig(model.getId(), config);
            LDAPIdentityStore store = LDAPIdentityStoreRegistry.createLdapIdentityStore(config);
            context = new LDAPIdentityStoreContext(config, store);
            this.ldapStores.put(model.getId(), context);
        }
        return context.store;
    }

    private void logLDAPConfig(String fedProviderId, Map<String, String> ldapConfig) {
        HashMap<String, String> copy = new HashMap<String, String>(ldapConfig);
        copy.remove("bindCredential");
        logger.infof("Creating new LDAP based partition manager for the Federation provider: " + fedProviderId + ", LDAP Configuration: " + copy, new Object[0]);
    }

    public static LDAPIdentityStore createLdapIdentityStore(Map<String, String> ldapConfig) {
        Properties connectionProps = new Properties();
        if (ldapConfig.containsKey("connectionPooling")) {
            connectionProps.put("com.sun.jndi.ldap.connect.pool", ldapConfig.get("connectionPooling"));
        }
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.authentication", "none simple");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.initsize", "1");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.maxsize", "1000");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.prefsize", "5");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.timeout", "300000");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.protocol", "plain");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.debug", "off");
        String vendor = ldapConfig.get("vendor");
        boolean activeDirectory = vendor != null && vendor.equals("ad");
        String ldapLoginNameMapping = ldapConfig.get("usernameLDAPAttribute");
        if (ldapLoginNameMapping == null) {
            ldapLoginNameMapping = activeDirectory ? "cn" : "uid";
        }
        String ldapFirstNameMapping = activeDirectory ? "givenName" : "cn";
        String createTimestampMapping = activeDirectory ? "whenCreated" : "createTimeStamp";
        String modifyTimestampMapping = activeDirectory ? "whenChanged" : "modifyTimeStamp";
        String[] userObjectClasses = LDAPIdentityStoreRegistry.getUserObjectClasses(ldapConfig);
        boolean pagination = ldapConfig.containsKey("pagination") ? Boolean.parseBoolean(ldapConfig.get("pagination")) : false;
        boolean userAccountControlsAfterPasswordUpdate = ldapConfig.containsKey("userAccountControlsAfterPasswordUpdate") ? Boolean.parseBoolean(ldapConfig.get("userAccountControlsAfterPasswordUpdate")) : false;
        String uniqueIdentifierAttributeName = "entryUUID";
        if (vendor != null) {
            switch (vendor) {
                case "rhds": {
                    uniqueIdentifierAttributeName = "nsuniqueid";
                    break;
                }
                case "tivoli": {
                    uniqueIdentifierAttributeName = "uniqueidentifier";
                    break;
                }
                case "edirectory": {
                    uniqueIdentifierAttributeName = "guid";
                    break;
                }
                case "ad": {
                    uniqueIdentifierAttributeName = "objectGUID";
                }
            }
        }
        LDAPIdentityStoreConfiguration ldapStoreConfig = new LDAPIdentityStoreConfiguration().setConnectionProperties(connectionProps).setBaseDN(ldapConfig.get("baseDn")).setBindDN(ldapConfig.get("bindDn")).setBindCredential(ldapConfig.get("bindCredential")).setLdapURL(ldapConfig.get("connectionUrl")).setActiveDirectory(activeDirectory).setPagination(pagination).setUniqueIdentifierAttributeName(uniqueIdentifierAttributeName).setFactoryName("com.sun.jndi.ldap.LdapCtxFactory").setAuthType("simple").setUserAccountControlsAfterPasswordUpdate(userAccountControlsAfterPasswordUpdate);
        LDAPMappingConfiguration ldapUserMappingConfig = ldapStoreConfig.mappingConfig(LDAPUser.class).setBaseDN(ldapConfig.get("userDnSuffix")).setObjectClasses(new HashSet<String>(Arrays.asList(userObjectClasses))).setIdPropertyName("loginName").addAttributeMapping("loginName", ldapLoginNameMapping).addAttributeMapping("firstName", ldapFirstNameMapping).addAttributeMapping("lastName", "sn").addAttributeMapping("email", "mail").addReadOnlyAttributeMapping("createdDate", createTimestampMapping).addReadOnlyAttributeMapping("modifyDate", modifyTimestampMapping);
        if (activeDirectory && ldapLoginNameMapping.equals("sAMAccountName")) {
            ldapUserMappingConfig.setBindingPropertyName("fullName");
            ldapUserMappingConfig.addAttributeMapping("fullName", "cn");
            logger.infof("Using 'cn' attribute for DN of user and 'sAMAccountName' for username", new Object[0]);
        }
        return new LDAPIdentityStore(ldapStoreConfig);
    }

    private static void checkSystemProperty(String name, String defaultValue) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, defaultValue);
        }
    }

    private static String[] getUserObjectClasses(Map<String, String> ldapConfig) {
        String objClassesCfg = ldapConfig.get("userObjectClasses");
        String objClassesStr = objClassesCfg != null && objClassesCfg.length() > 0 ? objClassesCfg.trim() : "inetOrgPerson, organizationalPerson";
        String[] objectClasses = objClassesStr.split(",");
        String[] userObjectClasses = new String[objectClasses.length];
        for (int i = 0; i < objectClasses.length; ++i) {
            userObjectClasses[i] = objectClasses[i].trim();
        }
        return userObjectClasses;
    }

    private class LDAPIdentityStoreContext {
        private Map<String, String> config;
        private LDAPIdentityStore store;

        private LDAPIdentityStoreContext(Map<String, String> config, LDAPIdentityStore store) {
            this.config = config;
            this.store = store;
        }
    }
}

