/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.migration.MigrationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.jpa.ClientAdapter;
import org.keycloak.models.jpa.MigrationModelAdapter;
import org.keycloak.models.jpa.RealmAdapter;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.entities.ClientEntity;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;

public class JpaRealmProvider
implements RealmProvider {
    private final KeycloakSession session;
    protected EntityManager em;

    public JpaRealmProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public MigrationModel getMigrationModel() {
        return new MigrationModelAdapter(this.em);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(KeycloakModelUtils.generateId(), name);
    }

    public RealmModel createRealm(String id, String name) {
        RealmEntity realm = new RealmEntity();
        realm.setName(name);
        realm.setId(id);
        this.em.persist((Object)realm);
        this.em.flush();
        final RealmAdapter model = new RealmAdapter(this.session, this.em, realm);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.RealmCreationEvent(){

            public RealmModel getCreatedRealm() {
                return model;
            }
        });
        return model;
    }

    public RealmModel getRealm(String id) {
        RealmEntity realm = (RealmEntity)this.em.find(RealmEntity.class, (Object)id);
        if (realm == null) {
            return null;
        }
        return new RealmAdapter(this.session, this.em, realm);
    }

    public List<RealmModel> getRealms() {
        TypedQuery query = this.em.createNamedQuery("getAllRealms", RealmEntity.class);
        List entities = query.getResultList();
        ArrayList<RealmModel> realms = new ArrayList<RealmModel>();
        for (RealmEntity entity : entities) {
            realms.add(new RealmAdapter(this.session, this.em, entity));
        }
        return realms;
    }

    public RealmModel getRealmByName(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmByName", RealmEntity.class);
        query.setParameter("name", (Object)name);
        List entities = query.getResultList();
        if (entities.size() == 0) {
            return null;
        }
        if (entities.size() > 1) {
            throw new IllegalStateException("Should not be more than one realm with same name");
        }
        RealmEntity realm = (RealmEntity)query.getResultList().get(0);
        if (realm == null) {
            return null;
        }
        return new RealmAdapter(this.session, this.em, realm);
    }

    public boolean removeRealm(String id) {
        RealmEntity realm = (RealmEntity)this.em.find(RealmEntity.class, (Object)id);
        if (realm == null) {
            return false;
        }
        RealmAdapter adapter = new RealmAdapter(this.session, this.em, realm);
        this.session.users().preRemove((RealmModel)adapter);
        for (ClientEntity a : new LinkedList<ClientEntity>(realm.getClients())) {
            adapter.removeClient(a.getId());
        }
        this.em.remove((Object)realm);
        return true;
    }

    public void close() {
    }

    public RoleModel getRoleById(String id, RealmModel realm) {
        RoleEntity entity = (RoleEntity)this.em.find(RoleEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        if (!realm.getId().equals(entity.getRealmId())) {
            return null;
        }
        return new RoleAdapter(realm, this.em, entity);
    }

    public ClientModel getClientById(String id, RealmModel realm) {
        ClientEntity app = (ClientEntity)this.em.find(ClientEntity.class, (Object)id);
        if (app == null || !realm.getId().equals(app.getRealm().getId())) {
            return null;
        }
        return new ClientAdapter(realm, this.em, this.session, app);
    }
}

