/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.updater.liquibase.ThreadLocalSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.DefaultKeycloakSessionFactory;

public abstract class CustomKeycloakTask
implements CustomSqlChange {
    private final Logger logger = Logger.getLogger(this.getClass());
    protected KeycloakSession kcSession;
    protected Database database;
    protected JdbcConnection jdbcConnection;
    protected Connection connection;
    protected StringBuilder confirmationMessage = new StringBuilder();
    protected List<SqlStatement> statements = new ArrayList<SqlStatement>();

    public ValidationErrors validate(Database database) {
        return null;
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public String getConfirmationMessage() {
        return this.confirmationMessage.toString();
    }

    public void setUp() throws SetupException {
        this.kcSession = ThreadLocalSessionContext.getCurrentSession();
        if (this.kcSession == null) {
            this.logger.info((Object)"No KeycloakSession provided in ThreadLocal. Initializing KeycloakSessionFactory");
            try {
                DefaultKeycloakSessionFactory factory = new DefaultKeycloakSessionFactory();
                factory.init();
                this.kcSession = factory.create();
            }
            catch (Exception e) {
                throw new SetupException("Exception when initializing factory", (Throwable)e);
            }
        }
    }

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        this.database = database;
        this.jdbcConnection = (JdbcConnection)database.getConnection();
        this.connection = this.jdbcConnection.getWrappedConnection();
        if (this.isApplicable()) {
            this.confirmationMessage.append(this.getTaskId() + ": ");
            this.generateStatementsImpl();
        } else {
            this.confirmationMessage.append(this.getTaskId() + ": no update applicable for this task");
        }
        return this.statements.toArray(new SqlStatement[this.statements.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isApplicable() throws CustomChangeException {
        boolean bl;
        String correctedTableName = this.database.correctObjectName("REALM", Table.class);
        if (!SnapshotGeneratorFactory.getInstance().has((DatabaseObject)new Table().setName(correctedTableName), this.database)) return false;
        ResultSet resultSet = this.connection.createStatement().executeQuery("SELECT ID FROM REALM");
        try {
            bl = resultSet.next();
        }
        catch (Throwable throwable) {
            try {
                resultSet.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new CustomChangeException("Failed to check database availability", (Throwable)e);
            }
        }
        resultSet.close();
        return bl;
    }

    protected abstract void generateStatementsImpl() throws CustomChangeException;

    protected abstract String getTaskId();
}

