/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import liquibase.CatalogAndSchema;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.exception.LiquibaseException;
import liquibase.integration.ant.BaseLiquibaseTask;
import liquibase.integration.ant.type.DatabaseType;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;

public abstract class AbstractDatabaseDiffTask
extends BaseLiquibaseTask {
    private DatabaseType referenceDatabaseType;
    private String diffTypes;

    protected DiffResult getDiffResult() {
        DatabaseSnapshot referenceSnapshot;
        Liquibase liquibase = this.getLiquibase();
        Database targetDatabase = liquibase.getDatabase();
        Database referenceDatabase = this.createDatabaseFromType(this.referenceDatabaseType);
        CatalogAndSchema targetCatalogAndSchema = this.buildCatalogAndSchema(targetDatabase);
        CatalogAndSchema referenceCatalogAndSchema = this.buildCatalogAndSchema(referenceDatabase);
        CompareControl.SchemaComparison[] schemaComparisons = new CompareControl.SchemaComparison[]{new CompareControl.SchemaComparison(referenceCatalogAndSchema, targetCatalogAndSchema)};
        SnapshotGeneratorFactory snapshotGeneratorFactory = SnapshotGeneratorFactory.getInstance();
        try {
            referenceSnapshot = snapshotGeneratorFactory.createSnapshot(referenceDatabase.getDefaultSchema(), referenceDatabase, new SnapshotControl(referenceDatabase, this.diffTypes));
        }
        catch (LiquibaseException e) {
            throw new BuildException("Unable to create a DatabaseSnapshot.", (Throwable)e);
        }
        CompareControl compareControl = new CompareControl(schemaComparisons, referenceSnapshot.getSnapshotControl().getTypesToInclude());
        try {
            return liquibase.diff(referenceDatabase, targetDatabase, compareControl);
        }
        catch (LiquibaseException e) {
            throw new BuildException("Unable to diff databases.", (Throwable)e);
        }
    }

    @Override
    protected void validateParameters() {
        super.validateParameters();
        if (this.referenceDatabaseType == null) {
            throw new BuildException("Reference database element or reference required.");
        }
    }

    private CatalogAndSchema buildCatalogAndSchema(Database database) {
        return new CatalogAndSchema(database.getDefaultCatalogName(), database.getDefaultSchemaName());
    }

    public void addReferenceDatabase(DatabaseType referenceDatabase) {
        if (this.referenceDatabaseType != null) {
            throw new BuildException("Only one <referenceDatabase> element is allowed.");
        }
        this.referenceDatabaseType = referenceDatabase;
    }

    public void setReferenceDatabaseRef(Reference referenceDatabaseRef) {
        this.referenceDatabaseType = new DatabaseType(this.getProject());
        this.referenceDatabaseType.setRefid(referenceDatabaseRef);
    }

    public String getDiffTypes() {
        return this.diffTypes;
    }

    public void setDiffTypes(String diffTypes) {
        this.diffTypes = diffTypes;
    }

    private DatabaseType getReferenceDatabaseType() {
        if (this.referenceDatabaseType == null) {
            this.referenceDatabaseType = new DatabaseType(this.getProject());
        }
        return this.referenceDatabaseType;
    }

    @Deprecated
    public String getReferenceDriver() {
        return this.getReferenceDatabaseType().getDriver();
    }

    @Deprecated
    public void setReferenceDriver(String referenceDriver) {
        this.log("The referenceDriver attribute is deprecated. Use a nested <referenceDatabase> element or set the referenceDatabaseRef attribute instead.", 1);
        this.getReferenceDatabaseType().setDriver(referenceDriver);
    }

    @Deprecated
    public String getReferenceUrl() {
        return this.getReferenceDatabaseType().getUrl();
    }

    @Deprecated
    public void setReferenceUrl(String referenceUrl) {
        this.log("The referenceUrl attribute is deprecated. Use a nested <referenceDatabase> element or set the referenceDatabaseRef attribute instead.", 1);
        this.getReferenceDatabaseType().setUrl(referenceUrl);
    }

    @Deprecated
    public String getReferenceUsername() {
        return this.getReferenceDatabaseType().getUser();
    }

    @Deprecated
    public void setReferenceUsername(String referenceUsername) {
        this.log("The referenceUsername attribute is deprecated. Use a nested <referenceDatabase> element or set the referenceDatabaseRef attribute instead.", 1);
        this.getReferenceDatabaseType().setUser(referenceUsername);
    }

    @Deprecated
    public String getReferencePassword() {
        return this.getReferenceDatabaseType().getPassword();
    }

    @Deprecated
    public void setReferencePassword(String referencePassword) {
        this.log("The referencePassword attribute is deprecated. Use a nested <referenceDatabase> element or set the referenceDatabaseRef attribute instead.", 1);
        this.getReferenceDatabaseType().setPassword(referencePassword);
    }

    @Deprecated
    public String getReferenceDefaultCatalogName() {
        return this.getReferenceDatabaseType().getDefaultCatalogName();
    }

    @Deprecated
    public void setReferenceDefaultCatalogName(String referenceDefaultCatalogName) {
        this.log("The referenceDefaultCatalogName attribute is deprecated. Use a nested <referenceDatabase> element or set the referenceDatabaseRef attribute instead.", 1);
        this.getReferenceDatabaseType().setDefaultCatalogName(referenceDefaultCatalogName);
    }

    @Deprecated
    public String getReferenceDefaultSchemaName() {
        return this.getReferenceDatabaseType().getDefaultSchemaName();
    }

    @Deprecated
    public void setReferenceDefaultSchemaName(String referenceDefaultSchemaName) {
        this.log("The referenceDefaultSchemaName attribute is deprecated. Use a nested <referenceDatabase> element or set the referenceDatabaseRef attribute instead.", 1);
        this.getReferenceDatabaseType().setDefaultSchemaName(referenceDefaultSchemaName);
    }

    @Deprecated
    public String getDataDir() {
        return null;
    }

    @Deprecated
    public void setDataDir(String dataDir) {
        this.log("The dataDir attribute is deprecated. It is no longer needed and will be removed in the future.", 1);
    }
}

