/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.github;

import org.codehaus.jackson.JsonNode;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.util.JsonSimpleHttp;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.social.SocialIdentityProvider;

public class GitHubIdentityProvider
extends AbstractOAuth2IdentityProvider
implements SocialIdentityProvider {
    public static final String AUTH_URL = "https://github.com/login/oauth/authorize";
    public static final String TOKEN_URL = "https://github.com/login/oauth/access_token";
    public static final String PROFILE_URL = "https://api.github.com/user";
    public static final String DEFAULT_SCOPE = "user:email";

    public GitHubIdentityProvider(OAuth2IdentityProviderConfig config) {
        super(config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(PROFILE_URL);
    }

    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        try {
            JsonNode profile = JsonSimpleHttp.asJson((SimpleHttp)SimpleHttp.doGet((String)PROFILE_URL).header("Authorization", "Bearer " + accessToken));
            BrokeredIdentityContext user = new BrokeredIdentityContext(this.getJsonProperty(profile, "id"));
            user.setUsername(this.getJsonProperty(profile, "login"));
            user.setName(this.getJsonProperty(profile, "name"));
            user.setEmail(this.getJsonProperty(profile, "email"));
            user.setIdpConfig((IdentityProviderModel)this.getConfig());
            user.setIdp((IdentityProvider)this);
            return user;
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user profile from github.", (Throwable)e);
        }
    }

    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }
}

