/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.auth;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import twitter4j.TwitterException;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.z_T4JInternalParseUtil;
import twitter4j.internal.org.json.JSONObject;

public class OAuth2Token
implements Serializable {
    private static final long serialVersionUID = 358222644448390610L;
    private String tokenType;
    private String accessToken;

    OAuth2Token(HttpResponse res) throws TwitterException {
        JSONObject json = res.asJSONObject();
        this.tokenType = z_T4JInternalParseUtil.getRawString("token_type", json);
        try {
            this.accessToken = URLDecoder.decode(z_T4JInternalParseUtil.getRawString("access_token", json), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public OAuth2Token(String tokenType, String accessToken) {
        this.tokenType = tokenType;
        this.accessToken = accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    String generateAuthorizationHeader() {
        String encoded = "";
        try {
            encoded = URLEncoder.encode(this.accessToken, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return "Bearer " + encoded;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OAuth2Token)) {
            return false;
        }
        OAuth2Token that = (OAuth2Token)obj;
        if (this.tokenType != null ? !this.tokenType.equals(that.tokenType) : that.tokenType != null) {
            return false;
        }
        return !(this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null);
    }

    public int hashCode() {
        int result = this.tokenType != null ? this.tokenType.hashCode() : 0;
        result = 31 * result + (this.accessToken != null ? this.accessToken.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "OAuth2Token{tokenType='" + this.tokenType + '\'' + ", accessToken='" + this.accessToken + '\'' + '}';
    }
}

