/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.account.freemarker.model;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.models.UserModel;

public class AccountBean {
    private final UserModel user;
    private final MultivaluedMap<String, String> profileFormData;
    private final Map<String, String> attributes = new HashMap<String, String>();

    public AccountBean(UserModel user, MultivaluedMap<String, String> profileFormData) {
        this.user = user;
        this.profileFormData = profileFormData;
        this.attributes.putAll(user.getAttributes());
        if (profileFormData != null) {
            for (String key : profileFormData.keySet()) {
                if (!key.startsWith("user.attributes.")) continue;
                String attribute = key.substring("user.attributes.".length());
                this.attributes.put(attribute, (String)profileFormData.getFirst((Object)key));
            }
        }
    }

    public String getFirstName() {
        return this.profileFormData != null ? (String)this.profileFormData.getFirst((Object)"firstName") : this.user.getFirstName();
    }

    public String getLastName() {
        return this.profileFormData != null ? (String)this.profileFormData.getFirst((Object)"lastName") : this.user.getLastName();
    }

    public String getUsername() {
        return this.profileFormData != null ? (String)this.profileFormData.getFirst((Object)"username") : this.user.getUsername();
    }

    public String getEmail() {
        return this.profileFormData != null ? (String)this.profileFormData.getFirst((Object)"email") : this.user.getEmail();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

