/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.entities.CredentialEntity;
import org.keycloak.models.jpa.entities.UserAttributeEntity;
import org.keycloak.models.jpa.entities.UserConsentEntity;
import org.keycloak.models.jpa.entities.UserConsentProtocolMapperEntity;
import org.keycloak.models.jpa.entities.UserConsentRoleEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.jpa.entities.UserRequiredActionEntity;
import org.keycloak.models.jpa.entities.UserRoleMappingEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.Pbkdf2PasswordEncoder;
import org.keycloak.util.Time;

public class UserAdapter
implements UserModel {
    protected UserEntity user;
    protected EntityManager em;
    protected RealmModel realm;

    public UserAdapter(RealmModel realm, EntityManager em, UserEntity user) {
        this.em = em;
        this.user = user;
        this.realm = realm;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public String getId() {
        return this.user.getId();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public void setUsername(String username) {
        this.user.setUsername(username);
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    public boolean isTotp() {
        return this.user.isTotp();
    }

    public void setEnabled(boolean enabled) {
        this.user.setEnabled(enabled);
    }

    public void setAttribute(String name, String value) {
        for (UserAttributeEntity attr : this.user.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            attr.setValue(value);
            return;
        }
        UserAttributeEntity attr = new UserAttributeEntity();
        attr.setName(name);
        attr.setValue(value);
        attr.setUser(this.user);
        this.em.persist((Object)attr);
        this.user.getAttributes().add(attr);
    }

    public void removeAttribute(String name) {
        Iterator<UserAttributeEntity> it = this.user.getAttributes().iterator();
        while (it.hasNext()) {
            UserAttributeEntity attr = it.next();
            if (!attr.getName().equals(name)) continue;
            it.remove();
            this.em.remove((Object)attr);
        }
    }

    public String getAttribute(String name) {
        for (UserAttributeEntity attr : this.user.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getValue();
        }
        return null;
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (UserAttributeEntity attr : this.user.getAttributes()) {
            result.put(attr.getName(), attr.getValue());
        }
        return result;
    }

    public Set<String> getRequiredActions() {
        HashSet<String> result = new HashSet<String>();
        for (UserRequiredActionEntity attr : this.user.getRequiredActions()) {
            result.add(attr.getAction());
        }
        return result;
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        String actionName = action.name();
        this.addRequiredAction(actionName);
    }

    public void addRequiredAction(String actionName) {
        for (UserRequiredActionEntity attr : this.user.getRequiredActions()) {
            if (!attr.getAction().equals(actionName)) continue;
            return;
        }
        UserRequiredActionEntity attr = new UserRequiredActionEntity();
        attr.setAction(actionName);
        attr.setUser(this.user);
        this.em.persist((Object)attr);
        this.user.getRequiredActions().add(attr);
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        String actionName = action.name();
        this.removeRequiredAction(actionName);
    }

    public void removeRequiredAction(String actionName) {
        Iterator<UserRequiredActionEntity> it = this.user.getRequiredActions().iterator();
        while (it.hasNext()) {
            UserRequiredActionEntity attr = it.next();
            if (!attr.getAction().equals(actionName)) continue;
            it.remove();
            this.em.remove((Object)attr);
        }
    }

    public boolean configuredForCredentialType(String type) {
        List<UserCredentialValueModel> creds = this.getCredentialsDirectly();
        for (UserCredentialValueModel cred : creds) {
            if (!cred.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public void setFirstName(String firstName) {
        this.user.setFirstName(firstName);
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public void setLastName(String lastName) {
        this.user.setLastName(lastName);
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public void setEmail(String email) {
        this.user.setEmail(email);
    }

    public boolean isEmailVerified() {
        return this.user.isEmailVerified();
    }

    public void setEmailVerified(boolean verified) {
        this.user.setEmailVerified(verified);
    }

    public void setTotp(boolean totp) {
        this.user.setTotp(totp);
    }

    public void updateCredential(UserCredentialModel cred) {
        if (cred.getType().equals("password")) {
            this.updatePasswordCredential(cred);
        } else {
            CredentialEntity credentialEntity = this.getCredentialEntity(this.user, cred.getType());
            if (credentialEntity == null) {
                credentialEntity = this.setCredentials(this.user, cred);
                credentialEntity.setValue(cred.getValue());
                this.em.persist((Object)credentialEntity);
                this.user.getCredentials().add(credentialEntity);
            } else {
                credentialEntity.setValue(cred.getValue());
            }
        }
        this.em.flush();
    }

    private void updatePasswordCredential(UserCredentialModel cred) {
        CredentialEntity credentialEntity = this.getCredentialEntity(this.user, cred.getType());
        if (credentialEntity == null) {
            credentialEntity = this.setCredentials(this.user, cred);
            this.setValue(credentialEntity, cred);
            this.em.persist((Object)credentialEntity);
            this.user.getCredentials().add(credentialEntity);
        } else {
            int expiredPasswordsPolicyValue = -1;
            PasswordPolicy policy = this.realm.getPasswordPolicy();
            if (policy != null) {
                expiredPasswordsPolicyValue = policy.getExpiredPasswords();
            }
            if (expiredPasswordsPolicyValue != -1) {
                this.user.getCredentials().remove(credentialEntity);
                credentialEntity.setType("password-history");
                this.user.getCredentials().add(credentialEntity);
                List<CredentialEntity> credentialEntities = this.getCredentialEntities(this.user, "password-history");
                if (credentialEntities.size() > expiredPasswordsPolicyValue - 1) {
                    this.user.getCredentials().removeAll(credentialEntities.subList(expiredPasswordsPolicyValue - 1, credentialEntities.size()));
                }
                credentialEntity = this.setCredentials(this.user, cred);
                this.setValue(credentialEntity, cred);
                this.em.persist((Object)credentialEntity);
                this.user.getCredentials().add(credentialEntity);
            } else {
                List<CredentialEntity> credentialEntities = this.getCredentialEntities(this.user, "password-history");
                if (credentialEntities != null && credentialEntities.size() > 0) {
                    this.user.getCredentials().removeAll(credentialEntities);
                }
                this.setValue(credentialEntity, cred);
            }
        }
    }

    private CredentialEntity setCredentials(UserEntity user, UserCredentialModel cred) {
        CredentialEntity credentialEntity = new CredentialEntity();
        credentialEntity.setId(KeycloakModelUtils.generateId());
        credentialEntity.setType(cred.getType());
        credentialEntity.setDevice(cred.getDevice());
        credentialEntity.setUser(user);
        return credentialEntity;
    }

    private void setValue(CredentialEntity credentialEntity, UserCredentialModel cred) {
        byte[] salt = Pbkdf2PasswordEncoder.getSalt();
        int hashIterations = 1;
        PasswordPolicy policy = this.realm.getPasswordPolicy();
        if (policy != null && (hashIterations = policy.getHashIterations()) == -1) {
            hashIterations = 1;
        }
        credentialEntity.setCreatedDate(Time.toMillis((int)Time.currentTime()));
        credentialEntity.setValue(new Pbkdf2PasswordEncoder(salt).encode(cred.getValue(), hashIterations));
        credentialEntity.setSalt(salt);
        credentialEntity.setHashIterations(hashIterations);
    }

    private CredentialEntity getCredentialEntity(UserEntity userEntity, String credType) {
        for (CredentialEntity entity : userEntity.getCredentials()) {
            if (!entity.getType().equals(credType)) continue;
            return entity;
        }
        return null;
    }

    private List<CredentialEntity> getCredentialEntities(UserEntity userEntity, String credType) {
        ArrayList<CredentialEntity> credentialEntities = new ArrayList<CredentialEntity>();
        for (CredentialEntity entity : userEntity.getCredentials()) {
            if (!entity.getType().equals(credType)) continue;
            credentialEntities.add(entity);
        }
        Collections.sort(credentialEntities, new Comparator<CredentialEntity>(){

            @Override
            public int compare(CredentialEntity credFirst, CredentialEntity credSecond) {
                if (credFirst.getCreatedDate() > credSecond.getCreatedDate()) {
                    return -1;
                }
                if (credFirst.getCreatedDate() < credSecond.getCreatedDate()) {
                    return 1;
                }
                return 0;
            }
        });
        return credentialEntities;
    }

    public List<UserCredentialValueModel> getCredentialsDirectly() {
        ArrayList<CredentialEntity> credentials = new ArrayList<CredentialEntity>(this.user.getCredentials());
        ArrayList<UserCredentialValueModel> result = new ArrayList<UserCredentialValueModel>();
        if (credentials != null) {
            for (CredentialEntity credEntity : credentials) {
                UserCredentialValueModel credModel = new UserCredentialValueModel();
                credModel.setType(credEntity.getType());
                credModel.setDevice(credEntity.getDevice());
                credModel.setValue(credEntity.getValue());
                credModel.setCreatedDate(credEntity.getCreatedDate());
                credModel.setSalt(credEntity.getSalt());
                credModel.setHashIterations(credEntity.getHashIterations());
                result.add(credModel);
            }
        }
        return result;
    }

    public void updateCredentialDirectly(UserCredentialValueModel credModel) {
        CredentialEntity credentialEntity = this.getCredentialEntity(this.user, credModel.getType());
        if (credentialEntity == null) {
            credentialEntity = new CredentialEntity();
            credentialEntity.setId(KeycloakModelUtils.generateId());
            credentialEntity.setType(credModel.getType());
            credentialEntity.setCreatedDate(credModel.getCreatedDate());
            credentialEntity.setUser(this.user);
            this.em.persist((Object)credentialEntity);
            this.user.getCredentials().add(credentialEntity);
        }
        credentialEntity.setValue(credModel.getValue());
        credentialEntity.setSalt(credModel.getSalt());
        credentialEntity.setDevice(credModel.getDevice());
        credentialEntity.setHashIterations(credModel.getHashIterations());
        this.em.flush();
    }

    public boolean hasRole(RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings();
        return KeycloakModelUtils.hasRole(roles, (RoleModel)role);
    }

    protected TypedQuery<UserRoleMappingEntity> getUserRoleMappingEntityTypedQuery(RoleModel role) {
        TypedQuery query = this.em.createNamedQuery("userHasRole", UserRoleMappingEntity.class);
        query.setParameter("user", (Object)this.getUser());
        query.setParameter("roleId", (Object)role.getId());
        return query;
    }

    public void grantRole(RoleModel role) {
        if (this.hasRole(role)) {
            return;
        }
        UserRoleMappingEntity entity = new UserRoleMappingEntity();
        entity.setUser(this.getUser());
        entity.setRoleId(role.getId());
        this.em.persist((Object)entity);
        this.em.flush();
        this.em.detach((Object)entity);
    }

    public Set<RoleModel> getRealmRoleMappings() {
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel)) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public Set<RoleModel> getRoleMappings() {
        TypedQuery query = this.em.createNamedQuery("userRoleMappingIds", String.class);
        query.setParameter("user", (Object)this.getUser());
        List ids = query.getResultList();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String roleId : ids) {
            RoleModel roleById = this.realm.getRoleById(roleId);
            if (roleById == null) continue;
            roles.add(roleById);
        }
        return roles;
    }

    public void deleteRoleMapping(RoleModel role) {
        if (this.user == null || role == null) {
            return;
        }
        TypedQuery<UserRoleMappingEntity> query = this.getUserRoleMappingEntityTypedQuery(role);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (UserRoleMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public Set<RoleModel> getClientRoleMappings(ClientModel app) {
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            ClientModel appModel;
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof ClientModel) || !(appModel = (ClientModel)container).getId().equals(app.getId())) continue;
            roles.add(role);
        }
        return roles;
    }

    public String getFederationLink() {
        return this.user.getFederationLink();
    }

    public void setFederationLink(String link) {
        this.user.setFederationLink(link);
    }

    public void addConsent(UserConsentModel consent) {
        String clientId = consent.getClient().getId();
        UserConsentEntity consentEntity = this.getGrantedConsentEntity(clientId);
        if (consentEntity != null) {
            throw new ModelDuplicateException("Consent already exists for client [" + clientId + "] and user [" + this.user.getId() + "]");
        }
        consentEntity = new UserConsentEntity();
        consentEntity.setId(KeycloakModelUtils.generateId());
        consentEntity.setUser(this.user);
        consentEntity.setClientId(clientId);
        this.em.persist((Object)consentEntity);
        this.em.flush();
        this.updateGrantedConsentEntity(consentEntity, consent);
    }

    public UserConsentModel getConsentByClient(String clientId) {
        UserConsentEntity entity = this.getGrantedConsentEntity(clientId);
        return this.toConsentModel(entity);
    }

    public List<UserConsentModel> getConsents() {
        TypedQuery query = this.em.createNamedQuery("userConsentsByUser", UserConsentEntity.class);
        query.setParameter("userId", (Object)this.getId());
        List results = query.getResultList();
        ArrayList<UserConsentModel> consents = new ArrayList<UserConsentModel>();
        for (UserConsentEntity entity : results) {
            UserConsentModel model = this.toConsentModel(entity);
            consents.add(model);
        }
        return consents;
    }

    public void updateConsent(UserConsentModel consent) {
        String clientId = consent.getClient().getId();
        UserConsentEntity consentEntity = this.getGrantedConsentEntity(clientId);
        if (consentEntity == null) {
            throw new ModelException("Consent not found for client [" + clientId + "] and user [" + this.user.getId() + "]");
        }
        this.updateGrantedConsentEntity(consentEntity, consent);
    }

    public boolean revokeConsentForClient(String clientId) {
        UserConsentEntity consentEntity = this.getGrantedConsentEntity(clientId);
        if (consentEntity == null) {
            return false;
        }
        this.em.remove((Object)consentEntity);
        this.em.flush();
        return true;
    }

    private UserConsentEntity getGrantedConsentEntity(String clientId) {
        TypedQuery query = this.em.createNamedQuery("userConsentByUserAndClient", UserConsentEntity.class);
        query.setParameter("userId", (Object)this.getId());
        query.setParameter("clientId", (Object)clientId);
        List results = query.getResultList();
        if (results.size() > 1) {
            throw new ModelException("More results found for user [" + this.getUsername() + "] and client [" + clientId + "]");
        }
        if (results.size() == 1) {
            return (UserConsentEntity)results.get(0);
        }
        return null;
    }

    private UserConsentModel toConsentModel(UserConsentEntity entity) {
        Collection<UserConsentProtocolMapperEntity> grantedProtocolMapperEntities;
        if (entity == null) {
            return null;
        }
        ClientModel client = this.realm.getClientById(entity.getClientId());
        if (client == null) {
            throw new ModelException("Client with id " + entity.getClientId() + " is not available");
        }
        UserConsentModel model = new UserConsentModel(client);
        Collection<UserConsentRoleEntity> grantedRoleEntities = entity.getGrantedRoles();
        if (grantedRoleEntities != null) {
            for (UserConsentRoleEntity grantedRole : grantedRoleEntities) {
                RoleModel grantedRoleModel = this.realm.getRoleById(grantedRole.getRoleId());
                if (grantedRoleModel == null) continue;
                model.addGrantedRole(grantedRoleModel);
            }
        }
        if ((grantedProtocolMapperEntities = entity.getGrantedProtocolMappers()) != null) {
            for (UserConsentProtocolMapperEntity grantedProtMapper : grantedProtocolMapperEntities) {
                ProtocolMapperModel protocolMapper = client.getProtocolMapperById(grantedProtMapper.getProtocolMapperId());
                model.addGrantedProtocolMapper(protocolMapper);
            }
        }
        return model;
    }

    private void updateGrantedConsentEntity(UserConsentEntity consentEntity, UserConsentModel consentModel) {
        Collection<UserConsentProtocolMapperEntity> grantedProtocolMapperEntities = consentEntity.getGrantedProtocolMappers();
        HashSet<UserConsentProtocolMapperEntity> mappersToRemove = new HashSet<UserConsentProtocolMapperEntity>(grantedProtocolMapperEntities);
        for (ProtocolMapperModel protocolMapper : consentModel.getGrantedProtocolMappers()) {
            UserConsentProtocolMapperEntity grantedProtocolMapperEntity = new UserConsentProtocolMapperEntity();
            grantedProtocolMapperEntity.setUserConsent(consentEntity);
            grantedProtocolMapperEntity.setProtocolMapperId(protocolMapper.getId());
            if (!grantedProtocolMapperEntities.contains(grantedProtocolMapperEntity)) {
                this.em.persist((Object)grantedProtocolMapperEntity);
                this.em.flush();
                grantedProtocolMapperEntities.add(grantedProtocolMapperEntity);
                continue;
            }
            mappersToRemove.remove(grantedProtocolMapperEntity);
        }
        for (UserConsentProtocolMapperEntity toRemove : mappersToRemove) {
            grantedProtocolMapperEntities.remove(toRemove);
            this.em.remove((Object)toRemove);
        }
        Collection<UserConsentRoleEntity> grantedRoleEntities = consentEntity.getGrantedRoles();
        HashSet<UserConsentRoleEntity> rolesToRemove = new HashSet<UserConsentRoleEntity>(grantedRoleEntities);
        for (RoleModel role : consentModel.getGrantedRoles()) {
            UserConsentRoleEntity consentRoleEntity = new UserConsentRoleEntity();
            consentRoleEntity.setUserConsent(consentEntity);
            consentRoleEntity.setRoleId(role.getId());
            if (!grantedRoleEntities.contains(consentRoleEntity)) {
                this.em.persist((Object)consentRoleEntity);
                this.em.flush();
                grantedRoleEntities.add(consentRoleEntity);
                continue;
            }
            rolesToRemove.remove(consentRoleEntity);
        }
        for (UserConsentRoleEntity toRemove : rolesToRemove) {
            grantedRoleEntities.remove(toRemove);
            this.em.remove((Object)toRemove);
        }
        this.em.flush();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

