/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.TemplateCache;
import freemarker.cache.TemplateLoader;
import freemarker.core.Configurable;
import freemarker.core.Environment;
import freemarker.core._ConcurrentMapFactory;
import freemarker.core._CoreAPI;
import freemarker.core._DelayedJQuote;
import freemarker.core._MiscTemplateException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateScalarModel;
import freemarker.template.Version;
import freemarker.template.utility.CaptureOutput;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.HtmlEscape;
import freemarker.template.utility.NormalizeNewlines;
import freemarker.template.utility.SecurityUtilities;
import freemarker.template.utility.StandardCompress;
import freemarker.template.utility.StringUtil;
import freemarker.template.utility.XmlEscape;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class Configuration
extends Configurable
implements Cloneable {
    public static final String DEFAULT_ENCODING_KEY = "default_encoding";
    public static final String LOCALIZED_LOOKUP_KEY = "localized_lookup";
    public static final String STRICT_SYNTAX_KEY = "strict_syntax";
    public static final String WHITESPACE_STRIPPING_KEY = "whitespace_stripping";
    public static final String CACHE_STORAGE_KEY = "cache_storage";
    public static final String TEMPLATE_UPDATE_DELAY_KEY = "template_update_delay";
    public static final String AUTO_IMPORT_KEY = "auto_import";
    public static final String AUTO_INCLUDE_KEY = "auto_include";
    public static final String TAG_SYNTAX_KEY = "tag_syntax";
    public static final String INCOMPATIBLE_IMPROVEMENTS = "incompatible_improvements";
    public static final String INCOMPATIBLE_ENHANCEMENTS = "incompatible_enhancements";
    public static final int AUTO_DETECT_TAG_SYNTAX = 0;
    public static final int ANGLE_BRACKET_TAG_SYNTAX = 1;
    public static final int SQUARE_BRACKET_TAG_SYNTAX = 2;
    public static final Version DEFAULT_INCOMPATIBLE_IMPROVEMENTS = new Version(2, 3, 0);
    public static final String DEFAULT_INCOMPATIBLE_ENHANCEMENTS = DEFAULT_INCOMPATIBLE_IMPROVEMENTS.toString();
    public static final int PARSED_DEFAULT_INCOMPATIBLE_ENHANCEMENTS = DEFAULT_INCOMPATIBLE_IMPROVEMENTS.intValue();
    private static Configuration defaultConfig = new Configuration();
    private static boolean versionPropertiesLoaded;
    private static String versionNumber;
    private static Version version;
    private boolean strictSyntax = true;
    private volatile boolean localizedLookup = true;
    private boolean whitespaceStripping = true;
    private Version incompatibleImprovements = DEFAULT_INCOMPATIBLE_IMPROVEMENTS;
    private int tagSyntax = 1;
    private TemplateCache cache;
    private HashMap sharedVariables = new HashMap();
    private String defaultEncoding = SecurityUtilities.getSystemProperty("file.encoding");
    private Map localeToCharsetMap = _ConcurrentMapFactory.newThreadSafeMap();
    private ArrayList autoImports = new ArrayList();
    private ArrayList autoIncludes = new ArrayList();
    private Map autoImportNsToTmpMap = new HashMap();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$freemarker$template$Configuration;

    public Configuration() {
        this.cache = new TemplateCache();
        this.cache.setConfiguration(this);
        this.cache.setDelay(5000L);
        this.loadBuiltInSharedVariables();
    }

    public Object clone() {
        try {
            Configuration copy = (Configuration)super.clone();
            copy.sharedVariables = new HashMap(this.sharedVariables);
            copy.localeToCharsetMap = new HashMap(this.localeToCharsetMap);
            copy.autoImportNsToTmpMap = new HashMap(this.autoImportNsToTmpMap);
            copy.autoImports = (ArrayList)this.autoImports.clone();
            copy.autoIncludes = (ArrayList)this.autoIncludes.clone();
            copy.createTemplateCache(this.cache.getTemplateLoader(), this.cache.getCacheStorage());
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone is not supported, but it should be: " + e.getMessage());
        }
    }

    private void loadBuiltInSharedVariables() {
        this.sharedVariables.put("capture_output", new CaptureOutput());
        this.sharedVariables.put("compress", StandardCompress.INSTANCE);
        this.sharedVariables.put("html_escape", new HtmlEscape());
        this.sharedVariables.put("normalize_newlines", new NormalizeNewlines());
        this.sharedVariables.put("xml_escape", new XmlEscape());
    }

    public void loadBuiltInEncodingMap() {
        this.localeToCharsetMap.clear();
        this.localeToCharsetMap.put("ar", "ISO-8859-6");
        this.localeToCharsetMap.put("be", "ISO-8859-5");
        this.localeToCharsetMap.put("bg", "ISO-8859-5");
        this.localeToCharsetMap.put("ca", "ISO-8859-1");
        this.localeToCharsetMap.put("cs", "ISO-8859-2");
        this.localeToCharsetMap.put("da", "ISO-8859-1");
        this.localeToCharsetMap.put("de", "ISO-8859-1");
        this.localeToCharsetMap.put("el", "ISO-8859-7");
        this.localeToCharsetMap.put("en", "ISO-8859-1");
        this.localeToCharsetMap.put("es", "ISO-8859-1");
        this.localeToCharsetMap.put("et", "ISO-8859-1");
        this.localeToCharsetMap.put("fi", "ISO-8859-1");
        this.localeToCharsetMap.put("fr", "ISO-8859-1");
        this.localeToCharsetMap.put("hr", "ISO-8859-2");
        this.localeToCharsetMap.put("hu", "ISO-8859-2");
        this.localeToCharsetMap.put("is", "ISO-8859-1");
        this.localeToCharsetMap.put("it", "ISO-8859-1");
        this.localeToCharsetMap.put("iw", "ISO-8859-8");
        this.localeToCharsetMap.put("ja", "Shift_JIS");
        this.localeToCharsetMap.put("ko", "EUC-KR");
        this.localeToCharsetMap.put("lt", "ISO-8859-2");
        this.localeToCharsetMap.put("lv", "ISO-8859-2");
        this.localeToCharsetMap.put("mk", "ISO-8859-5");
        this.localeToCharsetMap.put("nl", "ISO-8859-1");
        this.localeToCharsetMap.put("no", "ISO-8859-1");
        this.localeToCharsetMap.put("pl", "ISO-8859-2");
        this.localeToCharsetMap.put("pt", "ISO-8859-1");
        this.localeToCharsetMap.put("ro", "ISO-8859-2");
        this.localeToCharsetMap.put("ru", "ISO-8859-5");
        this.localeToCharsetMap.put("sh", "ISO-8859-5");
        this.localeToCharsetMap.put("sk", "ISO-8859-2");
        this.localeToCharsetMap.put("sl", "ISO-8859-2");
        this.localeToCharsetMap.put("sq", "ISO-8859-2");
        this.localeToCharsetMap.put("sr", "ISO-8859-5");
        this.localeToCharsetMap.put("sv", "ISO-8859-1");
        this.localeToCharsetMap.put("tr", "ISO-8859-9");
        this.localeToCharsetMap.put("uk", "ISO-8859-5");
        this.localeToCharsetMap.put("zh", "GB2312");
        this.localeToCharsetMap.put("zh_TW", "Big5");
    }

    public void clearEncodingMap() {
        this.localeToCharsetMap.clear();
    }

    public static Configuration getDefaultConfiguration() {
        return defaultConfig;
    }

    public static void setDefaultConfiguration(Configuration config) {
        defaultConfig = config;
    }

    public synchronized void setTemplateLoader(TemplateLoader loader) {
        this.createTemplateCache(loader, this.cache.getCacheStorage());
    }

    private void createTemplateCache(TemplateLoader loader, CacheStorage storage) {
        TemplateCache oldCache = this.cache;
        this.cache = new TemplateCache(loader, storage);
        this.cache.setDelay(oldCache.getDelay());
        this.cache.setConfiguration(this);
        this.cache.setLocalizedLookup(this.localizedLookup);
    }

    public TemplateLoader getTemplateLoader() {
        return this.cache.getTemplateLoader();
    }

    public synchronized void setCacheStorage(CacheStorage storage) {
        this.createTemplateCache(this.cache.getTemplateLoader(), storage);
    }

    public synchronized CacheStorage getCacheStorage() {
        return this.cache.getCacheStorage();
    }

    public void setDirectoryForTemplateLoading(File dir) throws IOException {
        String path;
        TemplateLoader tl = this.getTemplateLoader();
        if (tl instanceof FileTemplateLoader && (path = ((FileTemplateLoader)tl).baseDir.getCanonicalPath()).equals(dir.getCanonicalPath())) {
            return;
        }
        this.setTemplateLoader(new FileTemplateLoader(dir));
    }

    public void setServletContextForTemplateLoading(Object servletContext, String path) {
        try {
            Object[] constructorParams;
            Class[] constructorParamTypes;
            Class webappTemplateLoaderClass = ClassUtil.forName("freemarker.cache.WebappTemplateLoader");
            Class servletContextClass = ClassUtil.forName("javax.servlet.ServletContext");
            if (path == null) {
                constructorParamTypes = new Class[]{servletContextClass};
                constructorParams = new Object[]{servletContext};
            } else {
                constructorParamTypes = new Class[]{servletContextClass, class$java$lang$String == null ? (class$java$lang$String = Configuration.class$("java.lang.String")) : class$java$lang$String};
                constructorParams = new Object[]{servletContext, path};
            }
            this.setTemplateLoader((TemplateLoader)webappTemplateLoaderClass.getConstructor(constructorParamTypes).newInstance(constructorParams));
        }
        catch (Exception exc) {
            throw new RuntimeException("Internal FreeMarker error: " + exc);
        }
    }

    public void setClassForTemplateLoading(Class clazz, String pathPrefix) {
        this.setTemplateLoader(new ClassTemplateLoader(clazz, pathPrefix));
    }

    public void setTemplateUpdateDelay(int seconds) {
        this.cache.setDelay(1000L * (long)seconds);
    }

    public void setStrictSyntaxMode(boolean b) {
        this.strictSyntax = b;
    }

    public boolean getStrictSyntaxMode() {
        return this.strictSyntax;
    }

    public void setIncompatibleImprovements(Version version) {
        this.incompatibleImprovements = version;
    }

    public Version getIncompatibleImprovements() {
        return this.incompatibleImprovements;
    }

    public void setIncompatibleEnhancements(String version) {
        this.setIncompatibleImprovements(new Version(version));
    }

    public String getIncompatibleEnhancements() {
        return this.incompatibleImprovements.toString();
    }

    public int getParsedIncompatibleEnhancements() {
        return this.getIncompatibleImprovements().intValue();
    }

    public void setWhitespaceStripping(boolean b) {
        this.whitespaceStripping = b;
    }

    public boolean getWhitespaceStripping() {
        return this.whitespaceStripping;
    }

    public void setTagSyntax(int tagSyntax) {
        if (tagSyntax != 0 && tagSyntax != 2 && tagSyntax != 1) {
            throw new IllegalArgumentException("\"tag_syntax\" can only be set to one of these: Configuration.AUTO_DETECT_TAG_SYNTAX, Configuration.ANGLE_BRACKET_SYNTAX, or Configuration.SQAUARE_BRACKET_SYNTAX");
        }
        this.tagSyntax = tagSyntax;
    }

    public int getTagSyntax() {
        return this.tagSyntax;
    }

    public Template getTemplate(String name) throws IOException {
        Locale loc = this.getLocale();
        return this.getTemplate(name, loc, this.getEncoding(loc), true);
    }

    public Template getTemplate(String name, Locale locale) throws IOException {
        return this.getTemplate(name, locale, this.getEncoding(locale), true);
    }

    public Template getTemplate(String name, String encoding) throws IOException {
        return this.getTemplate(name, this.getLocale(), encoding, true);
    }

    public Template getTemplate(String name, Locale locale, String encoding) throws IOException {
        return this.getTemplate(name, locale, encoding, true);
    }

    public Template getTemplate(String name, Locale locale, String encoding, boolean parseAsFTL) throws IOException {
        Template result = this.cache.getTemplate(name, locale, encoding, parseAsFTL);
        if (result == null) {
            throw new FileNotFoundException("Template " + StringUtil.jQuote(name) + " not found.");
        }
        return result;
    }

    public void setDefaultEncoding(String encoding) {
        this.defaultEncoding = encoding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getEncoding(Locale locale) {
        if (this.localeToCharsetMap.isEmpty()) {
            return this.defaultEncoding;
        }
        String charset = (String)this.localeToCharsetMap.get(locale.toString());
        if (charset == null) {
            Locale l;
            if (locale.getVariant().length() > 0 && (charset = (String)this.localeToCharsetMap.get((l = new Locale(locale.getLanguage(), locale.getCountry())).toString())) != null) {
                this.localeToCharsetMap.put(locale.toString(), charset);
            }
            if ((charset = (String)this.localeToCharsetMap.get(locale.getLanguage())) != null) {
                this.localeToCharsetMap.put(locale.toString(), charset);
            }
        }
        return charset != null ? charset : this.defaultEncoding;
    }

    public void setEncoding(Locale locale, String encoding) {
        this.localeToCharsetMap.put(locale.toString(), encoding);
    }

    public void setSharedVariable(String name, TemplateModel tm) {
        this.sharedVariables.put(name, tm);
    }

    public Set getSharedVariableNames() {
        return new HashSet(this.sharedVariables.keySet());
    }

    public void setSharedVariable(String name, Object obj) throws TemplateModelException {
        this.setSharedVariable(name, this.getObjectWrapper().wrap(obj));
    }

    public void setAllSharedVariables(TemplateHashModelEx hash) throws TemplateModelException {
        TemplateModelIterator keys = hash.keys().iterator();
        TemplateModelIterator values = hash.values().iterator();
        while (keys.hasNext()) {
            this.setSharedVariable(((TemplateScalarModel)keys.next()).getAsString(), values.next());
        }
    }

    public TemplateModel getSharedVariable(String name) {
        return (TemplateModel)this.sharedVariables.get(name);
    }

    public void clearSharedVariables() {
        this.sharedVariables.clear();
        this.loadBuiltInSharedVariables();
    }

    public void clearTemplateCache() {
        this.cache.clear();
    }

    public void removeTemplateFromCache(String name) throws IOException {
        Locale loc = this.getLocale();
        this.removeTemplateFromCache(name, loc, this.getEncoding(loc), true);
    }

    public void removeTemplateFromCache(String name, Locale locale) throws IOException {
        this.removeTemplateFromCache(name, locale, this.getEncoding(locale), true);
    }

    public void removeTemplateFromCache(String name, String encoding) throws IOException {
        this.removeTemplateFromCache(name, this.getLocale(), encoding, true);
    }

    public void removeTemplateFromCache(String name, Locale locale, String encoding) throws IOException {
        this.removeTemplateFromCache(name, locale, encoding, true);
    }

    public void removeTemplateFromCache(String name, Locale locale, String encoding, boolean parse) throws IOException {
        this.cache.removeTemplate(name, locale, encoding, parse);
    }

    public boolean getLocalizedLookup() {
        return this.cache.getLocalizedLookup();
    }

    public void setLocalizedLookup(boolean localizedLookup) {
        this.localizedLookup = localizedLookup;
        this.cache.setLocalizedLookup(localizedLookup);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSetting(String key, String value) throws TemplateException {
        try {
            if ("TemplateUpdateInterval".equalsIgnoreCase(key)) {
                key = TEMPLATE_UPDATE_DELAY_KEY;
            } else if ("DefaultEncoding".equalsIgnoreCase(key)) {
                key = DEFAULT_ENCODING_KEY;
            }
            if (DEFAULT_ENCODING_KEY.equals(key)) {
                this.setDefaultEncoding(value);
                return;
            }
            if (LOCALIZED_LOOKUP_KEY.equals(key)) {
                this.setLocalizedLookup(StringUtil.getYesNo(value));
                return;
            }
            if (STRICT_SYNTAX_KEY.equals(key)) {
                this.setStrictSyntaxMode(StringUtil.getYesNo(value));
                return;
            }
            if (WHITESPACE_STRIPPING_KEY.equals(key)) {
                this.setWhitespaceStripping(StringUtil.getYesNo(value));
                return;
            }
            if (CACHE_STORAGE_KEY.equals(key)) {
                if (value.indexOf(46) == -1) {
                    int strongSize = 0;
                    int softSize = 0;
                    Map map = StringUtil.parseNameValuePairList(value, String.valueOf(Integer.MAX_VALUE));
                    Iterator it = map.entrySet().iterator();
                    while (it.hasNext()) {
                        int pvalue;
                        Map.Entry ent = it.next();
                        String pname = (String)ent.getKey();
                        try {
                            pvalue = Integer.parseInt((String)ent.getValue());
                        }
                        catch (NumberFormatException e) {
                            throw this.invalidSettingValueException(key, value);
                        }
                        if ("soft".equalsIgnoreCase(pname)) {
                            softSize = pvalue;
                            continue;
                        }
                        if (!"strong".equalsIgnoreCase(pname)) throw this.invalidSettingValueException(key, value);
                        strongSize = pvalue;
                    }
                    if (softSize == 0 && strongSize == 0) {
                        throw this.invalidSettingValueException(key, value);
                    }
                    this.setCacheStorage(new MruCacheStorage(strongSize, softSize));
                    return;
                }
                this.setCacheStorage((CacheStorage)ClassUtil.forName(value).newInstance());
                return;
            }
            if (TEMPLATE_UPDATE_DELAY_KEY.equals(key)) {
                this.setTemplateUpdateDelay(Integer.parseInt(value));
                return;
            } else if (AUTO_INCLUDE_KEY.equals(key)) {
                this.setAutoIncludes(this.parseAsList(value));
                return;
            } else if (AUTO_IMPORT_KEY.equals(key)) {
                this.setAutoImports(this.parseAsImportList(value));
                return;
            } else if (TAG_SYNTAX_KEY.equals(key)) {
                if ("auto_detect".equals(value)) {
                    this.setTagSyntax(0);
                    return;
                } else if ("angle_bracket".equals(value)) {
                    this.setTagSyntax(1);
                    return;
                } else {
                    if (!"square_bracket".equals(value)) throw this.invalidSettingValueException(key, value);
                    this.setTagSyntax(2);
                }
                return;
            } else if (INCOMPATIBLE_IMPROVEMENTS.equals(key)) {
                this.setIncompatibleImprovements(new Version(value));
                return;
            } else if (INCOMPATIBLE_ENHANCEMENTS.equals(key)) {
                this.setIncompatibleEnhancements(value);
                return;
            } else {
                super.setSetting(key, value);
            }
            return;
        }
        catch (Exception e) {
            throw new _MiscTemplateException((Throwable)e, this.getEnvironment(), new Object[]{"Failed to set setting ", new _DelayedJQuote(key), " to value ", new _DelayedJQuote(value), "; see cause exception."});
        }
    }

    public synchronized void addAutoImport(String namespaceVarName, String templateName) {
        this.autoImports.remove(namespaceVarName);
        this.autoImports.add(namespaceVarName);
        this.autoImportNsToTmpMap.put(namespaceVarName, templateName);
    }

    public synchronized void removeAutoImport(String namespaceVarName) {
        this.autoImports.remove(namespaceVarName);
        this.autoImportNsToTmpMap.remove(namespaceVarName);
    }

    public synchronized void setAutoImports(Map map) {
        this.autoImports = new ArrayList(map.keySet());
        this.autoImportNsToTmpMap = map instanceof HashMap ? (Map)((HashMap)map).clone() : (map instanceof SortedMap ? new TreeMap(map) : new HashMap(map));
    }

    protected void doAutoImportsAndIncludes(Environment env) throws TemplateException, IOException {
        int i;
        for (i = 0; i < this.autoImports.size(); ++i) {
            String namespace = (String)this.autoImports.get(i);
            String templateName = (String)this.autoImportNsToTmpMap.get(namespace);
            env.importLib(templateName, namespace);
        }
        for (i = 0; i < this.autoIncludes.size(); ++i) {
            String templateName = (String)this.autoIncludes.get(i);
            Template template = this.getTemplate(templateName, env.getLocale());
            env.include(template);
        }
    }

    public synchronized void addAutoInclude(String templateName) {
        this.autoIncludes.remove(templateName);
        this.autoIncludes.add(templateName);
    }

    public synchronized void setAutoIncludes(List templateNames) {
        this.autoIncludes.clear();
        Iterator it = templateNames.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof String)) {
                throw new IllegalArgumentException("List items must be String-s.");
            }
            this.autoIncludes.add(o);
        }
    }

    public synchronized void removeAutoInclude(String templateName) {
        this.autoIncludes.remove(templateName);
    }

    public static String getVersionNumber() {
        if (!versionPropertiesLoaded) {
            Configuration.loadVersionProperties();
        }
        return versionNumber;
    }

    public static Version getVersion() {
        if (!versionPropertiesLoaded) {
            Configuration.loadVersionProperties();
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadVersionProperties() {
        try {
            Date buildDate;
            String versionString;
            Properties vp = new Properties();
            InputStream ins = (class$freemarker$template$Configuration == null ? (class$freemarker$template$Configuration = Configuration.class$("freemarker.template.Configuration")) : class$freemarker$template$Configuration).getClassLoader().getResourceAsStream("freemarker/version.properties");
            if (ins == null) {
                throw new RuntimeException("Version file is missing.");
            }
            try {
                vp.load(ins);
            }
            finally {
                ins.close();
            }
            versionNumber = versionString = Configuration.getRequiredVersionProperty(vp, "version");
            String buildDateStr = Configuration.getRequiredVersionProperty(vp, "buildTimestamp");
            if (buildDateStr.endsWith("Z")) {
                buildDateStr = buildDateStr.substring(0, buildDateStr.length() - 1) + "+0000";
            }
            try {
                buildDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US).parse(buildDateStr);
            }
            catch (ParseException e) {
                buildDate = null;
            }
            Boolean gaeCompliant = Boolean.valueOf(Configuration.getRequiredVersionProperty(vp, "isGAECompliant"));
            version = new Version(versionString, gaeCompliant, buildDate);
            versionPropertiesLoaded = true;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load version file: " + e);
        }
    }

    public Set getSupportedBuiltInNames() {
        return _CoreAPI.getSupportedBuiltInNames();
    }

    private static String getRequiredVersionProperty(Properties vp, String properyName) {
        String s = vp.getProperty(properyName);
        if (s == null) {
            throw new RuntimeException("Version file is corrupt: \"" + properyName + "\" property is missing.");
        }
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

