/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.mongo.DefaultMongoConnectionProvider;
import org.keycloak.connections.mongo.MongoConnectionProvider;
import org.keycloak.connections.mongo.MongoConnectionProviderFactory;
import org.keycloak.connections.mongo.MongoKeycloakTransaction;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.impl.MongoStoreImpl;
import org.keycloak.connections.mongo.impl.context.TransactionMongoStoreInvocationContext;
import org.keycloak.connections.mongo.updater.MongoUpdaterProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;

public class DefaultMongoConnectionFactoryProvider
implements MongoConnectionProviderFactory {
    private String[] entities = new String[]{"org.keycloak.models.mongo.keycloak.entities.MongoRealmEntity", "org.keycloak.models.mongo.keycloak.entities.MongoUserEntity", "org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity", "org.keycloak.models.mongo.keycloak.entities.MongoClientEntity", "org.keycloak.models.mongo.keycloak.entities.MongoUserConsentEntity", "org.keycloak.models.mongo.keycloak.entities.MongoMigrationModelEntity", "org.keycloak.models.entities.IdentityProviderEntity", "org.keycloak.models.entities.ClientIdentityProviderMappingEntity", "org.keycloak.models.entities.RequiredCredentialEntity", "org.keycloak.models.entities.CredentialEntity", "org.keycloak.models.entities.FederatedIdentityEntity", "org.keycloak.models.entities.UserFederationProviderEntity", "org.keycloak.models.entities.UserFederationMapperEntity", "org.keycloak.models.entities.ProtocolMapperEntity", "org.keycloak.models.entities.IdentityProviderMapperEntity", "org.keycloak.models.entities.AuthenticationExecutionEntity", "org.keycloak.models.entities.AuthenticationFlowEntity", "org.keycloak.models.entities.AuthenticatorConfigEntity", "org.keycloak.models.entities.RequiredActionProviderEntity"};
    private static final Logger logger = Logger.getLogger(DefaultMongoConnectionFactoryProvider.class);
    private volatile MongoClient client;
    private MongoStore mongoStore;
    private DB db;
    protected Config.Scope config;
    private Map<String, String> operationalInfo;

    public MongoConnectionProvider create(KeycloakSession session) {
        this.lazyInit(session);
        TransactionMongoStoreInvocationContext invocationContext = new TransactionMongoStoreInvocationContext(this.mongoStore);
        session.getTransaction().enlist((KeycloakTransaction)new MongoKeycloakTransaction(invocationContext));
        return new DefaultMongoConnectionProvider(this.db, this.mongoStore, invocationContext);
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.client == null) {
            DefaultMongoConnectionFactoryProvider defaultMongoConnectionFactoryProvider = this;
            synchronized (defaultMongoConnectionFactoryProvider) {
                if (this.client == null) {
                    try {
                        this.client = this.createMongoClient();
                        String dbName = this.config.get("db", "keycloak");
                        this.db = this.client.getDB(dbName);
                        String databaseSchema = this.config.get("databaseSchema");
                        if (databaseSchema != null) {
                            if (databaseSchema.equals("update")) {
                                MongoUpdaterProvider mongoUpdater = (MongoUpdaterProvider)session.getProvider(MongoUpdaterProvider.class);
                                if (mongoUpdater == null) {
                                    throw new RuntimeException("Can't update database: Mongo updater provider not found");
                                }
                                mongoUpdater.update(session, this.db);
                            } else {
                                throw new RuntimeException("Invalid value for databaseSchema: " + databaseSchema);
                            }
                        }
                        this.mongoStore = new MongoStoreImpl(this.db, this.getManagedEntities());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    private Class[] getManagedEntities() throws ClassNotFoundException {
        Class[] entityClasses = new Class[this.entities.length];
        for (int i = 0; i < this.entities.length; ++i) {
            entityClasses[i] = Thread.currentThread().getContextClassLoader().loadClass(this.entities[i]);
        }
        return entityClasses;
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public String getId() {
        return "default";
    }

    protected MongoClient createMongoClient() throws UnknownHostException {
        MongoClient client;
        String host = this.config.get("host", ServerAddress.defaultHost());
        int port = this.config.getInt("port", Integer.valueOf(ServerAddress.defaultPort()));
        String dbName = this.config.get("db", "keycloak");
        String user = this.config.get("user");
        String password = this.config.get("password");
        MongoClientOptions clientOptions = this.getClientOptions();
        if (user != null && password != null) {
            MongoCredential credential = MongoCredential.createMongoCRCredential((String)user, (String)dbName, (char[])password.toCharArray());
            client = new MongoClient(new ServerAddress(host, port), Collections.singletonList(credential), clientOptions);
        } else {
            client = new MongoClient(new ServerAddress(host, port), clientOptions);
        }
        this.operationalInfo = new LinkedHashMap<String, String>();
        this.operationalInfo.put("mongoServerAddress", client.getAddress().toString());
        this.operationalInfo.put("mongoDatabaseName", dbName);
        this.operationalInfo.put("mongoUser", user);
        this.operationalInfo.put("mongoDriverVersion", client.getVersion());
        logger.debugv("Initialized mongo model. host: %s, port: %d, db: %s", (Object)host, (Object)port, (Object)dbName);
        return client;
    }

    protected MongoClientOptions getClientOptions() {
        MongoClientOptions.Builder builder = MongoClientOptions.builder();
        this.checkIntOption("connectionsPerHost", builder);
        this.checkIntOption("threadsAllowedToBlockForConnectionMultiplier", builder);
        this.checkIntOption("maxWaitTime", builder);
        this.checkIntOption("connectTimeout", builder);
        this.checkIntOption("socketTimeout", builder);
        this.checkBooleanOption("socketKeepAlive", builder);
        this.checkBooleanOption("autoConnectRetry", builder);
        if (this.config.getLong("maxAutoConnectRetryTime") != null) {
            builder.maxAutoConnectRetryTime(this.config.getLong("maxAutoConnectRetryTime").longValue());
        }
        if (this.config.getBoolean("ssl", Boolean.valueOf(false)).booleanValue()) {
            builder.socketFactory(SSLSocketFactory.getDefault());
        }
        return builder.build();
    }

    protected void checkBooleanOption(String optionName, MongoClientOptions.Builder builder) {
        Boolean val = this.config.getBoolean(optionName);
        if (val != null) {
            try {
                Method m = MongoClientOptions.Builder.class.getMethod(optionName, Boolean.TYPE);
                m.invoke((Object)builder, val);
            }
            catch (Exception e) {
                throw new IllegalStateException("Problem configuring boolean option " + optionName + " for mongo client. Ensure you used correct value true or false and if this option is supported by mongo driver", e);
            }
        }
    }

    protected void checkIntOption(String optionName, MongoClientOptions.Builder builder) {
        Integer val = this.config.getInt(optionName);
        if (val != null) {
            try {
                Method m = MongoClientOptions.Builder.class.getMethod(optionName, Integer.TYPE);
                m.invoke((Object)builder, val);
            }
            catch (Exception e) {
                throw new IllegalStateException("Problem configuring int option " + optionName + " for mongo client. Ensure you used correct value (number) and if this option is supported by mongo driver", e);
            }
        }
    }

    public Map<String, String> getOperationalInfo() {
        return this.operationalInfo;
    }
}

