/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.entities.ClientEntity;
import org.keycloak.models.jpa.entities.ProtocolMapperEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.jpa.entities.ScopeMappingEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ClientAdapter
implements ClientModel {
    protected KeycloakSession session;
    protected RealmModel realm;
    protected EntityManager em;
    protected ClientEntity entity;

    public ClientAdapter(RealmModel realm, EntityManager em, KeycloakSession session, ClientEntity entity) {
        this.session = session;
        this.realm = realm;
        this.em = em;
        this.entity = entity;
    }

    public ClientEntity getEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public String getName() {
        return this.entity.getName();
    }

    public void setName(String name) {
        this.entity.setName(name);
    }

    public String getDescription() {
        return this.entity.getDescription();
    }

    public void setDescription(String description) {
        this.entity.setDescription(description);
    }

    public boolean isEnabled() {
        return this.entity.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.entity.setEnabled(enabled);
    }

    public boolean isPublicClient() {
        return this.entity.isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        this.entity.setPublicClient(flag);
    }

    public boolean isFrontchannelLogout() {
        return this.entity.isFrontchannelLogout();
    }

    public void setFrontchannelLogout(boolean flag) {
        this.entity.setFrontchannelLogout(flag);
    }

    public boolean isFullScopeAllowed() {
        return this.entity.isFullScopeAllowed();
    }

    public void setFullScopeAllowed(boolean value) {
        this.entity.setFullScopeAllowed(value);
    }

    public Set<String> getWebOrigins() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.entity.getWebOrigins());
        return result;
    }

    public void setWebOrigins(Set<String> webOrigins) {
        this.entity.setWebOrigins(webOrigins);
    }

    public void addWebOrigin(String webOrigin) {
        this.entity.getWebOrigins().add(webOrigin);
    }

    public void removeWebOrigin(String webOrigin) {
        this.entity.getWebOrigins().remove(webOrigin);
    }

    public Set<String> getRedirectUris() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.entity.getRedirectUris());
        return result;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        this.entity.setRedirectUris(redirectUris);
    }

    public void addRedirectUri(String redirectUri) {
        this.entity.getRedirectUris().add(redirectUri);
    }

    public void removeRedirectUri(String redirectUri) {
        this.entity.getRedirectUris().remove(redirectUri);
    }

    public String getClientAuthenticatorType() {
        return this.entity.getClientAuthenticatorType();
    }

    public void setClientAuthenticatorType(String clientAuthenticatorType) {
        this.entity.setClientAuthenticatorType(clientAuthenticatorType);
    }

    public String getSecret() {
        return this.entity.getSecret();
    }

    public void setSecret(String secret) {
        this.entity.setSecret(secret);
    }

    public boolean validateSecret(String secret) {
        return secret.equals(this.entity.getSecret());
    }

    public int getNotBefore() {
        return this.entity.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.entity.setNotBefore(notBefore);
    }

    public Set<RoleModel> getRealmScopeMappings() {
        Set<RoleModel> roleMappings = this.getScopeMappings();
        HashSet<RoleModel> appRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel) || !((RealmModel)container).getId().equals(this.realm.getId())) continue;
            appRoles.add(role);
        }
        return appRoles;
    }

    public Set<RoleModel> getScopeMappings() {
        TypedQuery query = this.em.createNamedQuery("clientScopeMappingIds", String.class);
        query.setParameter("client", (Object)this.getEntity());
        List ids = query.getResultList();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String roleId : ids) {
            RoleModel role = this.realm.getRoleById(roleId);
            if (role == null) continue;
            roles.add(role);
        }
        return roles;
    }

    public void addScopeMapping(RoleModel role) {
        if (this.hasScope(role)) {
            return;
        }
        ScopeMappingEntity entity = new ScopeMappingEntity();
        entity.setClient(this.getEntity());
        RoleEntity roleEntity = RoleAdapter.toRoleEntity(role, this.em);
        entity.setRole(roleEntity);
        this.em.persist((Object)entity);
        this.em.flush();
        this.em.detach((Object)entity);
    }

    public void deleteScopeMapping(RoleModel role) {
        TypedQuery<ScopeMappingEntity> query = this.getRealmScopeMappingQuery(role);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (ScopeMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
    }

    protected TypedQuery<ScopeMappingEntity> getRealmScopeMappingQuery(RoleModel role) {
        TypedQuery query = this.em.createNamedQuery("hasScope", ScopeMappingEntity.class);
        query.setParameter("client", (Object)this.getEntity());
        RoleEntity roleEntity = RoleAdapter.toRoleEntity(role, this.em);
        query.setParameter("role", (Object)roleEntity);
        return query;
    }

    public String getProtocol() {
        return this.entity.getProtocol();
    }

    public void setProtocol(String protocol) {
        this.entity.setProtocol(protocol);
    }

    public void setAttribute(String name, String value) {
        this.entity.getAttributes().put(name, value);
    }

    public void removeAttribute(String name) {
        this.entity.getAttributes().remove(name);
    }

    public String getAttribute(String name) {
        return this.entity.getAttributes().get(name);
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.entity.getAttributes());
        return copy;
    }

    public static boolean contains(String str, String[] array) {
        for (String s : array) {
            if (!str.equals(s)) continue;
            return true;
        }
        return false;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        HashSet<ProtocolMapperModel> mappings = new HashSet<ProtocolMapperModel>();
        for (ProtocolMapperEntity entity : this.entity.getProtocolMappers()) {
            ProtocolMapperModel mapping = new ProtocolMapperModel();
            mapping.setId(entity.getId());
            mapping.setName(entity.getName());
            mapping.setProtocol(entity.getProtocol());
            mapping.setProtocolMapper(entity.getProtocolMapper());
            mapping.setConsentRequired(entity.isConsentRequired());
            mapping.setConsentText(entity.getConsentText());
            HashMap<String, String> config = new HashMap<String, String>();
            if (entity.getConfig() != null) {
                config.putAll(entity.getConfig());
            }
            mapping.setConfig(config);
            mappings.add(mapping);
        }
        return mappings;
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        if (this.getProtocolMapperByName(model.getProtocol(), model.getName()) != null) {
            throw new RuntimeException("protocol mapper name must be unique per protocol");
        }
        String id = model.getId() != null ? model.getId() : KeycloakModelUtils.generateId();
        ProtocolMapperEntity entity = new ProtocolMapperEntity();
        entity.setId(id);
        entity.setName(model.getName());
        entity.setProtocol(model.getProtocol());
        entity.setProtocolMapper(model.getProtocolMapper());
        entity.setClient(this.entity);
        entity.setConfig(model.getConfig());
        entity.setConsentRequired(model.isConsentRequired());
        entity.setConsentText(model.getConsentText());
        this.em.persist((Object)entity);
        this.entity.getProtocolMappers().add(entity);
        return this.entityToModel(entity);
    }

    protected ProtocolMapperEntity getProtocolMapperEntity(String id) {
        for (ProtocolMapperEntity entity : this.entity.getProtocolMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected ProtocolMapperEntity getProtocolMapperEntityByName(String protocol, String name) {
        for (ProtocolMapperEntity entity : this.entity.getProtocolMappers()) {
            if (!entity.getProtocol().equals(protocol) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        ProtocolMapperEntity toDelete = this.getProtocolMapperEntity(mapping.getId());
        if (toDelete != null) {
            this.session.users().preRemove((ClientModel)this, mapping);
            this.entity.getProtocolMappers().remove(toDelete);
            this.em.remove((Object)toDelete);
        }
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntity(mapping.getId());
        entity.setProtocolMapper(mapping.getProtocolMapper());
        entity.setConsentRequired(mapping.isConsentRequired());
        entity.setConsentText(mapping.getConsentText());
        if (entity.getConfig() == null) {
            entity.setConfig(mapping.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapping.getConfig());
        }
        this.em.flush();
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntityByName(protocol, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected ProtocolMapperModel entityToModel(ProtocolMapperEntity entity) {
        ProtocolMapperModel mapping = new ProtocolMapperModel();
        mapping.setId(entity.getId());
        mapping.setName(entity.getName());
        mapping.setProtocol(entity.getProtocol());
        mapping.setProtocolMapper(entity.getProtocolMapper());
        mapping.setConsentRequired(entity.isConsentRequired());
        mapping.setConsentText(entity.getConsentText());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapping.setConfig(config);
        return mapping;
    }

    public void updateClient() {
        this.em.flush();
    }

    public String getClientId() {
        return this.entity.getClientId();
    }

    public void setClientId(String clientId) {
        this.entity.setClientId(clientId);
    }

    public boolean isSurrogateAuthRequired() {
        return this.entity.isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        this.entity.setSurrogateAuthRequired(surrogateAuthRequired);
    }

    public String getManagementUrl() {
        return this.entity.getManagementUrl();
    }

    public void setManagementUrl(String url) {
        this.entity.setManagementUrl(url);
    }

    public String getRootUrl() {
        return this.entity.getRootUrl();
    }

    public void setRootUrl(String url) {
        this.entity.setRootUrl(url);
    }

    public String getBaseUrl() {
        return this.entity.getBaseUrl();
    }

    public void setBaseUrl(String url) {
        this.entity.setBaseUrl(url);
    }

    public boolean isBearerOnly() {
        return this.entity.isBearerOnly();
    }

    public void setBearerOnly(boolean only) {
        this.entity.setBearerOnly(only);
    }

    public boolean isConsentRequired() {
        return this.entity.isConsentRequired();
    }

    public void setConsentRequired(boolean consentRequired) {
        this.entity.setConsentRequired(consentRequired);
    }

    public boolean isServiceAccountsEnabled() {
        return this.entity.isServiceAccountsEnabled();
    }

    public void setServiceAccountsEnabled(boolean serviceAccountsEnabled) {
        this.entity.setServiceAccountsEnabled(serviceAccountsEnabled);
    }

    public boolean isDirectGrantsOnly() {
        return this.entity.isDirectGrantsOnly();
    }

    public void setDirectGrantsOnly(boolean flag) {
        this.entity.setDirectGrantsOnly(flag);
    }

    public RoleModel getRole(String name) {
        TypedQuery query = this.em.createNamedQuery("getClientRoleByName", RoleEntity.class);
        query.setParameter("name", (Object)name);
        query.setParameter("client", (Object)this.entity);
        List roles = query.getResultList();
        if (roles.size() == 0) {
            return null;
        }
        return new RoleAdapter(this.realm, this.em, (RoleEntity)roles.get(0));
    }

    public RoleModel addRole(String name) {
        return this.addRole(KeycloakModelUtils.generateId(), name);
    }

    public RoleModel addRole(String id, String name) {
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setId(id);
        roleEntity.setName(name);
        roleEntity.setClient(this.entity);
        roleEntity.setClientRole(true);
        roleEntity.setRealmId(this.realm.getId());
        this.em.persist((Object)roleEntity);
        this.entity.getRoles().add(roleEntity);
        this.em.flush();
        return new RoleAdapter(this.realm, this.em, roleEntity);
    }

    public boolean removeRole(RoleModel roleModel) {
        if (roleModel == null) {
            return false;
        }
        if (!roleModel.getContainer().equals(this)) {
            return false;
        }
        this.session.users().preRemove(this.getRealm(), roleModel);
        RoleEntity role = RoleAdapter.toRoleEntity(roleModel, this.em);
        if (!role.isClientRole()) {
            return false;
        }
        this.entity.getRoles().remove(role);
        this.entity.getDefaultRoles().remove(role);
        String compositeRoleTable = JpaUtils.getTableNameForNativeQuery((String)"COMPOSITE_ROLE", (EntityManager)this.em);
        this.em.createNativeQuery("delete from " + compositeRoleTable + " where CHILD_ROLE = :role").setParameter("role", (Object)role).executeUpdate();
        this.em.createNamedQuery("deleteScopeMappingByRole").setParameter("role", (Object)role).executeUpdate();
        role.setClient(null);
        this.em.flush();
        this.em.remove((Object)role);
        this.em.flush();
        return true;
    }

    public Set<RoleModel> getRoles() {
        HashSet<RoleModel> list = new HashSet<RoleModel>();
        Collection<RoleEntity> roles = this.entity.getRoles();
        if (roles == null) {
            return list;
        }
        for (RoleEntity entity : roles) {
            list.add(new RoleAdapter(this.realm, this.em, entity));
        }
        return list;
    }

    public boolean hasScope(RoleModel role) {
        if (this.isFullScopeAllowed()) {
            return true;
        }
        Set<RoleModel> roles = this.getScopeMappings();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        roles = this.getRoles();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public Set<RoleModel> getClientScopeMappings(ClientModel client) {
        Set roleMappings = client.getScopeMappings();
        HashSet<RoleModel> appRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            ClientModel app;
            RoleContainerModel container = role.getContainer();
            if (container instanceof RealmModel || !(app = (ClientModel)container).getId().equals(this.getId())) continue;
            appRoles.add(role);
        }
        return appRoles;
    }

    public List<String> getDefaultRoles() {
        Collection<RoleEntity> entities = this.entity.getDefaultRoles();
        ArrayList<String> roles = new ArrayList<String>();
        if (entities == null) {
            return roles;
        }
        for (RoleEntity entity : entities) {
            roles.add(entity.getName());
        }
        return roles;
    }

    public void addDefaultRole(String name) {
        RoleModel role = this.getRole(name);
        if (role == null) {
            role = this.addRole(name);
        }
        Collection<RoleEntity> entities = this.entity.getDefaultRoles();
        for (RoleEntity entity : entities) {
            if (!entity.getId().equals(role.getId())) continue;
            return;
        }
        RoleEntity roleEntity = RoleAdapter.toRoleEntity(role, this.em);
        entities.add(roleEntity);
        this.em.flush();
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        Collection<RoleEntity> entities = this.entity.getDefaultRoles();
        HashSet<String> already = new HashSet<String>();
        ArrayList<RoleEntity> remove = new ArrayList<RoleEntity>();
        for (RoleEntity rel : entities) {
            if (!ClientAdapter.contains(rel.getName(), defaultRoles)) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getName());
        }
        for (RoleEntity entity : remove) {
            entities.remove(entity);
        }
        this.em.flush();
        for (Iterator<RoleEntity> iterator : defaultRoles) {
            if (already.contains(iterator)) continue;
            this.addDefaultRole((String)((Object)iterator));
        }
        this.em.flush();
    }

    public int getNodeReRegistrationTimeout() {
        return this.entity.getNodeReRegistrationTimeout();
    }

    public void setNodeReRegistrationTimeout(int timeout) {
        this.entity.setNodeReRegistrationTimeout(timeout);
    }

    public Map<String, Integer> getRegisteredNodes() {
        return this.entity.getRegisteredNodes();
    }

    public void registerNode(String nodeHost, int registrationTime) {
        Map<String, Integer> currentNodes = this.getRegisteredNodes();
        currentNodes.put(nodeHost, registrationTime);
        this.em.flush();
    }

    public void unregisterNode(String nodeHost) {
        Map<String, Integer> currentNodes = this.getRegisteredNodes();
        currentNodes.remove(nodeHost);
        this.em.flush();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ClientModel)) {
            return false;
        }
        ClientModel that = (ClientModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getClientId();
    }
}

