/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.api.saml.v2.response;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedList;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.assertion.ActionType;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AudienceRestrictionType;
import org.keycloak.dom.saml.v2.assertion.AuthnContextClassRefType;
import org.keycloak.dom.saml.v2.assertion.AuthnContextType;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.AuthzDecisionStatementType;
import org.keycloak.dom.saml.v2.assertion.ConditionsType;
import org.keycloak.dom.saml.v2.assertion.DecisionType;
import org.keycloak.dom.saml.v2.assertion.EncryptedAssertionType;
import org.keycloak.dom.saml.v2.assertion.EncryptedElementType;
import org.keycloak.dom.saml.v2.assertion.EvidenceType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.StatementAbstractType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationDataType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.exceptions.fed.IssueInstantMissingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.saml.processing.core.saml.v2.common.IDGenerator;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.saml.v2.factories.JBossSAMLAuthnResponseFactory;
import org.keycloak.saml.processing.core.saml.v2.factories.SAMLAssertionFactory;
import org.keycloak.saml.processing.core.saml.v2.holders.IDPInfoHolder;
import org.keycloak.saml.processing.core.saml.v2.holders.IssuerInfoHolder;
import org.keycloak.saml.processing.core.saml.v2.holders.SPInfoHolder;
import org.keycloak.saml.processing.core.saml.v2.util.AssertionUtil;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.keycloak.saml.processing.core.saml.v2.writers.SAMLResponseWriter;
import org.keycloak.saml.processing.core.util.JAXPValidationUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2Response {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private long ASSERTION_VALIDITY = 5000L;
    private long CLOCK_SKEW = 2000L;
    private SAMLDocumentHolder samlDocumentHolder = null;

    public AssertionType createAssertion(String id, NameIDType issuer) {
        return AssertionUtil.createAssertion(id, issuer);
    }

    public AuthnStatementType createAuthnStatement(String authnContextDeclRef, XMLGregorianCalendar issueInstant) {
        AuthnStatementType authnStatement = new AuthnStatementType(issueInstant);
        AuthnContextType act = new AuthnContextType();
        String authContextDeclRef = JBossSAMLURIConstants.AC_PASSWORD_PROTECTED_TRANSPORT.get();
        act.addAuthenticatingAuthority(URI.create(authContextDeclRef));
        AuthnContextType.AuthnContextTypeSequence sequence = act.new AuthnContextType.AuthnContextTypeSequence();
        sequence.setClassRef(new AuthnContextClassRefType(URI.create(JBossSAMLURIConstants.AC_PASSWORD.get())));
        act.setSequence(sequence);
        authnStatement.setAuthnContext(act);
        return authnStatement;
    }

    public AuthzDecisionStatementType createAuthzDecisionStatementType(String resource, DecisionType decision, EvidenceType evidence, ActionType ... actions) {
        AuthzDecisionStatementType authzDecST = new AuthzDecisionStatementType();
        authzDecST.setResource(resource);
        authzDecST.setDecision(decision);
        if (evidence != null) {
            authzDecST.setEvidence(evidence);
        }
        if (actions != null) {
            authzDecST.getAction().addAll(Arrays.asList(actions));
        }
        return authzDecST;
    }

    public ResponseType createResponseType(String ID, SPInfoHolder sp, IDPInfoHolder idp, IssuerInfoHolder issuerInfo, AssertionType assertion) throws ConfigurationException, ProcessingException {
        String responseDestinationURI = sp.getResponseDestinationURI();
        XMLGregorianCalendar issueInstant = XMLTimeUtil.getIssueInstant();
        SubjectType subjectType = new SubjectType();
        NameIDType nameIDType = new NameIDType();
        nameIDType.setFormat(URI.create(idp.getNameIDFormat()));
        nameIDType.setValue(idp.getNameIDFormatValue());
        SubjectType.STSubType subType = new SubjectType.STSubType();
        subType.addBaseID(nameIDType);
        subjectType.setSubType(subType);
        SubjectConfirmationType subjectConfirmation = new SubjectConfirmationType();
        subjectConfirmation.setMethod(idp.getSubjectConfirmationMethod());
        SubjectConfirmationDataType subjectConfirmationData = new SubjectConfirmationDataType();
        subjectConfirmationData.setInResponseTo(sp.getRequestID());
        subjectConfirmationData.setRecipient(responseDestinationURI);
        subjectConfirmationData.setNotOnOrAfter(issueInstant);
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        subjectType.addConfirmation(subjectConfirmation);
        ConditionsType conditions = assertion.getConditions();
        if (conditions != null) {
            subjectConfirmationData.setNotOnOrAfter(conditions.getNotOnOrAfter());
            AudienceRestrictionType audience = new AudienceRestrictionType();
            audience.addAudience(URI.create(sp.getResponseDestinationURI()));
            conditions.addCondition(audience);
        }
        ResponseType responseType = this.createResponseType(ID, issuerInfo, assertion);
        responseType.setInResponseTo(sp.getRequestID());
        responseType.setDestination(responseDestinationURI);
        return responseType;
    }

    public ResponseType createResponseType(String ID, SPInfoHolder sp, IDPInfoHolder idp, IssuerInfoHolder issuerInfo) throws ConfigurationException, ProcessingException {
        String responseDestinationURI = sp.getResponseDestinationURI();
        XMLGregorianCalendar issueInstant = XMLTimeUtil.getIssueInstant();
        SubjectType subjectType = new SubjectType();
        NameIDType nameIDType = new NameIDType();
        nameIDType.setFormat(URI.create(idp.getNameIDFormat()));
        nameIDType.setValue(idp.getNameIDFormatValue());
        SubjectType.STSubType subType = new SubjectType.STSubType();
        subType.addBaseID(nameIDType);
        subjectType.setSubType(subType);
        SubjectConfirmationType subjectConfirmation = new SubjectConfirmationType();
        subjectConfirmation.setMethod(idp.getSubjectConfirmationMethod());
        SubjectConfirmationDataType subjectConfirmationData = new SubjectConfirmationDataType();
        subjectConfirmationData.setInResponseTo(sp.getRequestID());
        subjectConfirmationData.setRecipient(responseDestinationURI);
        subjectConfirmationData.setNotOnOrAfter(issueInstant);
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        subjectType.addConfirmation(subjectConfirmation);
        AssertionType assertionType = null;
        NameIDType issuerID = issuerInfo.getIssuer();
        try {
            issueInstant = XMLTimeUtil.getIssueInstant();
        }
        catch (ConfigurationException e) {
            throw logger.processingError(e);
        }
        ConditionsType conditions = null;
        LinkedList<StatementAbstractType> statements = new LinkedList<StatementAbstractType>();
        String assertionID = IDGenerator.create("ID_");
        assertionType = SAMLAssertionFactory.createAssertion(assertionID, issuerID, issueInstant, conditions, subjectType, statements);
        try {
            AssertionUtil.createTimedConditions(assertionType, this.ASSERTION_VALIDITY, this.CLOCK_SKEW);
        }
        catch (ConfigurationException e) {
            throw logger.processingError(e);
        }
        catch (IssueInstantMissingException e) {
            throw logger.processingError(e);
        }
        ResponseType responseType = this.createResponseType(ID, issuerInfo, assertionType);
        responseType.setInResponseTo(sp.getRequestID());
        responseType.setDestination(responseDestinationURI);
        return responseType;
    }

    public ResponseType createResponseType(String ID) {
        try {
            return new ResponseType(ID, XMLTimeUtil.getIssueInstant());
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public ResponseType createResponseType(String ID, IssuerInfoHolder issuerInfo, AssertionType assertion) throws ConfigurationException {
        return JBossSAMLAuthnResponseFactory.createResponseType(ID, issuerInfo, assertion);
    }

    public ResponseType createResponseType(String ID, IssuerInfoHolder issuerInfo, Element encryptedAssertion) throws ConfigurationException {
        return JBossSAMLAuthnResponseFactory.createResponseType(ID, issuerInfo, encryptedAssertion);
    }

    public void createTimedConditions(AssertionType assertion, long durationInMilis) throws ConfigurationException, IssueInstantMissingException {
        AssertionUtil.createTimedConditions(assertion, durationInMilis);
    }

    public EncryptedAssertionType getEncryptedAssertion(InputStream is) throws ParsingException, ConfigurationException, ProcessingException {
        if (is == null) {
            throw logger.nullArgumentError("InputStream");
        }
        Document samlDocument = DocumentUtil.getDocument(is);
        SAMLParser samlParser = new SAMLParser();
        JAXPValidationUtil.checkSchemaValidation(samlDocument);
        return (EncryptedAssertionType)samlParser.parse(DocumentUtil.getNodeAsStream(samlDocument));
    }

    public AssertionType getAssertionType(InputStream is) throws ParsingException, ConfigurationException, ProcessingException {
        if (is == null) {
            throw logger.nullArgumentError("InputStream");
        }
        Document samlDocument = DocumentUtil.getDocument(is);
        SAMLParser samlParser = new SAMLParser();
        JAXPValidationUtil.checkSchemaValidation(samlDocument);
        return (AssertionType)samlParser.parse(DocumentUtil.getNodeAsStream(samlDocument));
    }

    public SAMLDocumentHolder getSamlDocumentHolder() {
        return this.samlDocumentHolder;
    }

    public ResponseType getResponseType(InputStream is) throws ParsingException, ConfigurationException, ProcessingException {
        if (is == null) {
            throw logger.nullArgumentError("InputStream");
        }
        Document samlResponseDocument = DocumentUtil.getDocument(is);
        SAMLParser samlParser = new SAMLParser();
        JAXPValidationUtil.checkSchemaValidation(samlResponseDocument);
        ResponseType responseType = (ResponseType)samlParser.parse(DocumentUtil.getNodeAsStream(samlResponseDocument));
        this.samlDocumentHolder = new SAMLDocumentHolder(responseType, samlResponseDocument);
        return responseType;
    }

    public SAML2Object getSAML2ObjectFromStream(InputStream is) throws ParsingException, ConfigurationException, ProcessingException {
        if (is == null) {
            throw logger.nullArgumentError("InputStream");
        }
        Document samlResponseDocument = DocumentUtil.getDocument(is);
        if (logger.isTraceEnabled()) {
            logger.trace("SAML Response Document: " + DocumentUtil.asString(samlResponseDocument));
        }
        SAMLParser samlParser = new SAMLParser();
        JAXPValidationUtil.checkSchemaValidation(samlResponseDocument);
        InputStream responseStream = DocumentUtil.getNodeAsStream(samlResponseDocument);
        SAML2Object responseType = (SAML2Object)samlParser.parse(responseStream);
        this.samlDocumentHolder = new SAMLDocumentHolder(responseType, samlResponseDocument);
        return responseType;
    }

    public Document convert(EncryptedElementType encryptedElementType) throws ConfigurationException {
        if (encryptedElementType == null) {
            throw logger.nullArgumentError("encryptedElementType");
        }
        Document doc = DocumentUtil.createDocument();
        Node importedNode = doc.importNode(encryptedElementType.getEncryptedElement(), true);
        doc.appendChild(importedNode);
        return doc;
    }

    public Document convert(StatusResponseType responseType) throws ProcessingException, ConfigurationException, ParsingException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SAMLResponseWriter writer = new SAMLResponseWriter(StaxUtil.getXMLStreamWriter(bos));
        if (responseType instanceof ResponseType) {
            ResponseType response = (ResponseType)responseType;
            writer.write(response);
        } else {
            writer.write(responseType, new QName(JBossSAMLURIConstants.PROTOCOL_NSURI.get(), JBossSAMLConstants.LOGOUT_RESPONSE.get(), "samlp"));
        }
        return DocumentUtil.getDocument(new ByteArrayInputStream(bos.toByteArray()));
    }

    public void marshall(ResponseType responseType, OutputStream os) throws ProcessingException {
        SAMLResponseWriter samlWriter = new SAMLResponseWriter(StaxUtil.getXMLStreamWriter(os));
        samlWriter.write(responseType);
    }

    public void marshall(ResponseType responseType, Writer writer) throws ProcessingException {
        SAMLResponseWriter samlWriter = new SAMLResponseWriter(StaxUtil.getXMLStreamWriter(writer));
        samlWriter.write(responseType);
    }
}

