/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.protocol.AttributeQueryType;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.ParserNamespaceSupport;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.SAMLRequestAbstractParser;
import org.keycloak.saml.processing.core.parsers.util.SAMLParserUtil;

public class SAMLAttributeQueryParser
extends SAMLRequestAbstractParser
implements ParserNamespaceSupport {
    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.ATTRIBUTE_QUERY.get());
        AttributeQueryType attributeQuery = this.parseBaseAttributes(startElement);
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) != null) {
            super.parseCommonElements(startElement, xmlEventReader, attributeQuery);
            String elementName = StaxParserUtil.getStartElementName(startElement);
            if (JBossSAMLConstants.SUBJECT.get().equals(elementName)) {
                attributeQuery.setSubject(this.getSubject(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.ATTRIBUTE.get().equals(elementName)) {
                attributeQuery.add(SAMLParserUtil.parseAttribute(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.ISSUER.get().equals(elementName) || JBossSAMLConstants.SIGNATURE.get().equals(elementName)) continue;
            throw new RuntimeException("PL00064: Parser: Unknown Start Element: " + elementName + "::location=" + startElement.getLocation());
        }
        return attributeQuery;
    }

    @Override
    public boolean supports(QName qname) {
        return JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(qname.getNamespaceURI());
    }

    private AttributeQueryType parseBaseAttributes(StartElement startElement) throws ParsingException {
        super.parseRequiredAttributes(startElement);
        AttributeQueryType authnRequest = new AttributeQueryType(this.id, this.issueInstant);
        super.parseBaseAttributes(startElement, authnRequest);
        return authnRequest;
    }
}

