/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapperFactory;
import org.keycloak.federation.ldap.mappers.FullNameLDAPFederationMapper;
import org.keycloak.mappers.MapperConfigValidationException;
import org.keycloak.mappers.UserFederationMapper;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.provider.ProviderConfigProperty;

public class FullNameLDAPFederationMapperFactory
extends AbstractLDAPFederationMapperFactory {
    public static final String PROVIDER_ID = "full-name-ldap-mapper";
    protected static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getHelpText() {
        return "Used to map full-name of user from single attribute in LDAP (usually 'cn' attribute) to firstName and lastName attributes of UserModel in Keycloak DB";
    }

    public String getDisplayCategory() {
        return "Attribute Mapper";
    }

    public String getDisplayType() {
        return "Full Name";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void validateConfig(UserFederationMapperModel mapperModel) throws MapperConfigValidationException {
        this.checkMandatoryConfigAttribute("ldap.full.name.attribute", "LDAP Full Name Attribute", mapperModel);
    }

    public UserFederationMapper create(KeycloakSession session) {
        return new FullNameLDAPFederationMapper();
    }

    static {
        ProviderConfigProperty userModelAttribute = FullNameLDAPFederationMapperFactory.createConfigProperty("ldap.full.name.attribute", "LDAP Full Name Attribute", "Name of LDAP attribute, which contains fullName of user. In most cases it will be 'cn' ", "String", "cn");
        configProperties.add(userModelAttribute);
        ProviderConfigProperty readOnly = FullNameLDAPFederationMapperFactory.createConfigProperty("read.only", "Read Only", "For Read-only is data imported from LDAP to Keycloak DB, but it's not saved back to LDAP when user is updated in Keycloak.", "boolean", "false");
        configProperties.add(readOnly);
    }
}

