/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.forms;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.Config;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormActionFactory;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.validation.Validation;

public class RegistrationProfile
implements FormAction,
FormActionFactory {
    public static final String PROVIDER_ID = "registration-profile-action";
    private static AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};

    public String getHelpText() {
        return "Validates email, first name, and last name attributes and stores them in user data.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    @Override
    public void validate(ValidationContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        ArrayList<FormMessage> errors = new ArrayList<FormMessage>();
        context.getEvent().detail("register_method", "form");
        String eventError = "invalid_registration";
        if (Validation.isBlank((String)formData.getFirst((Object)"firstName"))) {
            errors.add(new FormMessage("firstName", "missingFirstNameMessage"));
        }
        if (Validation.isBlank((String)formData.getFirst((Object)"lastName"))) {
            errors.add(new FormMessage("lastName", "missingLastNameMessage"));
        }
        String email = (String)formData.getFirst((Object)"email");
        boolean emailValid = true;
        if (Validation.isBlank(email)) {
            errors.add(new FormMessage("email", "missingEmailMessage"));
            emailValid = false;
        } else if (!Validation.isEmailValid(email)) {
            context.getEvent().detail("email", email);
            errors.add(new FormMessage("email", "invalidEmailMessage"));
            emailValid = false;
        }
        if (emailValid && context.getSession().users().getUserByEmail(email, context.getRealm()) != null) {
            eventError = "email_in_use";
            formData.remove((Object)"email");
            context.getEvent().detail("email", email);
            errors.add(new FormMessage("email", "emailExistsMessage"));
        }
        if (errors.size() > 0) {
            context.error(eventError);
            context.validationError((MultivaluedMap<String, String>)formData, errors);
            return;
        }
        context.success();
    }

    @Override
    public void success(FormContext context) {
        UserModel user = context.getUser();
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        user.setFirstName((String)formData.getFirst((Object)"firstName"));
        user.setLastName((String)formData.getFirst((Object)"lastName"));
        user.setEmail((String)formData.getFirst((Object)"email"));
    }

    @Override
    public void buildPage(FormContext context, LoginFormsProvider form) {
    }

    @Override
    public boolean requiresUser() {
        return false;
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    @Override
    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    @Override
    public boolean isUserSetupAllowed() {
        return false;
    }

    public void close() {
    }

    @Override
    public String getDisplayType() {
        return "Profile Validation";
    }

    @Override
    public String getReferenceCategory() {
        return null;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public FormAction create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

