/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.io.IOException;
import org.keycloak.Config;
import org.keycloak.exportimport.ClientDescriptionConverter;
import org.keycloak.exportimport.ClientDescriptionConverterFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.representations.OIDCClientRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.util.JsonSerialization;

public class OIDCClientDescriptionConverter
implements ClientDescriptionConverter,
ClientDescriptionConverterFactory {
    @Override
    public boolean isSupported(String description) {
        return (description = description.trim()).startsWith("{") && description.endsWith("}") && description.contains("\"redirect_uris\"");
    }

    @Override
    public ClientRepresentation convertToInternal(String description) {
        try {
            OIDCClientRepresentation oidcRep = (OIDCClientRepresentation)JsonSerialization.readValue((String)description, OIDCClientRepresentation.class);
            ClientRepresentation client = new ClientRepresentation();
            client.setClientId(KeycloakModelUtils.generateId());
            client.setName(oidcRep.getClientName());
            client.setRedirectUris(oidcRep.getRedirectUris());
            client.setBaseUrl(oidcRep.getClientUri());
            return client;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ClientDescriptionConverter create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "openid-connect";
    }
}

