/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.logging.Logger;
import org.keycloak.messages.MessagesProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.services.ErrorResponse;

@Provider
public class ModelExceptionMapper
implements ExceptionMapper<ModelException> {
    private static final Logger logger = Logger.getLogger(ModelExceptionMapper.class);
    @Context
    private KeycloakSession session;

    public Response toResponse(ModelException ex) {
        String message = ((MessagesProvider)this.session.getProvider(MessagesProvider.class, "admin")).getMessage(ex.getMessage(), ex.getParameters());
        logger.error((Object)message, (Throwable)ex);
        return ErrorResponse.error(message, Response.Status.BAD_REQUEST);
    }
}

