/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.file;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.keycloak.connections.file.FileConnectionProvider;
import org.keycloak.connections.file.InMemoryModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.entities.FederatedIdentityEntity;
import org.keycloak.models.entities.UserEntity;
import org.keycloak.models.file.adapter.UserAdapter;
import org.keycloak.models.utils.CredentialValidation;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.Provider;

public class FileUserProvider
implements UserProvider {
    private final KeycloakSession session;
    private FileConnectionProvider fcProvider;
    private final InMemoryModel inMemoryModel;

    public FileUserProvider(KeycloakSession session, FileConnectionProvider fcProvider) {
        this.session = session;
        this.fcProvider = fcProvider;
        session.enlistForClose((Provider)this);
        this.inMemoryModel = fcProvider.getModel();
    }

    public void close() {
        this.fcProvider.sessionClosed(this.session);
    }

    public UserModel getUserById(String userId, RealmModel realm) {
        return this.inMemoryModel.getUser(realm.getId(), userId);
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        for (UserModel user : this.inMemoryModel.getUsers(realm.getId())) {
            if (user.getUsername() == null || !user.getUsername().equals(username.toLowerCase())) continue;
            return user;
        }
        return null;
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        for (UserModel user : this.inMemoryModel.getUsers(realm.getId())) {
            if (user.getEmail() == null || !user.getEmail().equals(email.toLowerCase())) continue;
            return user;
        }
        return null;
    }

    public UserModel getUserByFederatedIdentity(FederatedIdentityModel socialLink, RealmModel realm) {
        for (UserModel user : this.inMemoryModel.getUsers(realm.getId())) {
            Set<FederatedIdentityModel> identities = this.getFederatedIdentities(user, realm);
            for (FederatedIdentityModel idModel : identities) {
                if (!idModel.getUserId().equals(socialLink.getUserId())) continue;
                return user;
            }
        }
        return null;
    }

    public UserModel getUserByServiceAccountClient(ClientModel client) {
        for (UserModel user : this.inMemoryModel.getUsers(client.getRealm().getId())) {
            if (!client.getId().equals(user.getServiceAccountClientLink())) continue;
            return user;
        }
        return null;
    }

    public List<UserModel> getUsers(RealmModel realm, boolean includeServiceAccounts) {
        return this.getUsers(realm, -1, -1, includeServiceAccounts);
    }

    public int getUsersCount(RealmModel realm) {
        return this.inMemoryModel.getUsers(realm.getId()).size();
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults, boolean includeServiceAccounts) {
        List<UserModel> users = new ArrayList<UserModel>(this.inMemoryModel.getUsers(realm.getId()));
        if (!includeServiceAccounts) {
            users = this.filterServiceAccountUsers(users);
        }
        List<UserModel> sortedList = this.sortedSubList(users, firstResult, maxResults);
        return sortedList;
    }

    private List<UserModel> filterServiceAccountUsers(List<UserModel> users) {
        ArrayList<UserModel> result = new ArrayList<UserModel>();
        for (UserModel user : users) {
            if (user.getServiceAccountClientLink() != null) continue;
            result.add(user);
        }
        return result;
    }

    protected List<UserModel> sortedSubList(List list, int firstResult, int maxResults) {
        if (list.isEmpty()) {
            return list;
        }
        Collections.sort(list);
        int first = firstResult <= 0 ? 0 : firstResult;
        int last = first + maxResults;
        if (maxResults > list.size() - first || last > list.size()) {
            last = list.size();
        }
        if (maxResults <= 0) {
            last = list.size();
        }
        return list.subList(first, last);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, -1, -1);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        search = search.trim();
        Pattern caseInsensitivePattern = Pattern.compile("(?i:.*" + search + ".*)", 2);
        int spaceInd = search.lastIndexOf(" ");
        boolean isFirstAndLastSearch = spaceInd != -1;
        Pattern firstNamePattern = null;
        Pattern lastNamePattern = null;
        if (isFirstAndLastSearch) {
            String firstNamePatternString = search.substring(0, spaceInd);
            String lastNamePatternString = search.substring(spaceInd + 1);
            firstNamePattern = Pattern.compile("(?i:.*" + firstNamePatternString + ".*$)", 2);
            lastNamePattern = Pattern.compile("(?i:^.*" + lastNamePatternString + ".*)", 2);
        }
        List<UserModel> found = new ArrayList<UserModel>();
        for (UserModel user : this.inMemoryModel.getUsers(realm.getId())) {
            String firstName = user.getFirstName();
            String lastName = user.getLastName();
            if (isFirstAndLastSearch && this.isAMatch(firstNamePattern, firstName) && this.isAMatch(lastNamePattern, lastName)) {
                found.add(user);
                continue;
            }
            if (!this.isAMatch(caseInsensitivePattern, firstName) && !this.isAMatch(caseInsensitivePattern, lastName) && !this.isAMatch(caseInsensitivePattern, user.getUsername()) && !this.isAMatch(caseInsensitivePattern, user.getEmail())) continue;
            found.add(user);
        }
        found = this.filterServiceAccountUsers(found);
        return this.sortedSubList(found, firstResult, maxResults);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm) {
        return this.searchForUserByAttributes(attributes, realm, -1, -1);
    }

    protected boolean isAMatch(Pattern pattern, String value) {
        return value != null && pattern != null && pattern.matcher(value).matches();
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        Pattern usernamePattern = null;
        Pattern firstNamePattern = null;
        Pattern lastNamePattern = null;
        Pattern emailPattern = null;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("username")) {
                usernamePattern = Pattern.compile(".*" + entry.getValue() + ".*", 2);
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("firstName")) {
                firstNamePattern = Pattern.compile(".*" + entry.getValue() + ".*", 2);
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("lastName")) {
                lastNamePattern = Pattern.compile(".*" + entry.getValue() + ".*", 2);
                continue;
            }
            if (!entry.getKey().equalsIgnoreCase("email")) continue;
            emailPattern = Pattern.compile(".*" + entry.getValue() + ".*", 2);
        }
        ArrayList<UserModel> found = new ArrayList<UserModel>();
        for (UserModel user : this.inMemoryModel.getUsers(realm.getId())) {
            if (!this.isAMatch(usernamePattern, user.getUsername()) && !this.isAMatch(firstNamePattern, user.getFirstName()) && !this.isAMatch(lastNamePattern, user.getLastName()) && !this.isAMatch(emailPattern, user.getEmail())) continue;
            found.add(user);
        }
        return this.sortedSubList(found, firstResult, maxResults);
    }

    public List<UserModel> searchForUserByUserAttribute(String attrName, String attrValue, RealmModel realm) {
        Collection users = this.inMemoryModel.getUsers(realm.getId());
        ArrayList<UserModel> matchedUsers = new ArrayList<UserModel>();
        for (UserModel user : users) {
            List vals = user.getAttribute(attrName);
            if (!vals.contains(attrValue)) continue;
            matchedUsers.add(user);
        }
        return matchedUsers;
    }

    public Set<FederatedIdentityModel> getFederatedIdentities(UserModel userModel, RealmModel realm) {
        UserEntity userEntity = ((UserAdapter)this.getUserById(userModel.getId(), realm)).getUserEntity();
        List linkEntities = userEntity.getFederatedIdentities();
        if (linkEntities == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<FederatedIdentityModel> result = new HashSet<FederatedIdentityModel>();
        for (FederatedIdentityEntity federatedIdentityEntity : linkEntities) {
            FederatedIdentityModel model = new FederatedIdentityModel(federatedIdentityEntity.getIdentityProvider(), federatedIdentityEntity.getUserId(), federatedIdentityEntity.getUserName());
            result.add(model);
        }
        return result;
    }

    private FederatedIdentityEntity findSocialLink(UserModel userModel, String socialProvider, RealmModel realm) {
        UserModel user = this.getUserById(userModel.getId(), realm);
        UserEntity userEntity = ((UserAdapter)this.getUserById(userModel.getId(), realm)).getUserEntity();
        List linkEntities = userEntity.getFederatedIdentities();
        if (linkEntities == null) {
            return null;
        }
        for (FederatedIdentityEntity federatedIdentityEntity : linkEntities) {
            if (!federatedIdentityEntity.getIdentityProvider().equals(socialProvider)) continue;
            return federatedIdentityEntity;
        }
        return null;
    }

    public FederatedIdentityModel getFederatedIdentity(UserModel user, String socialProvider, RealmModel realm) {
        FederatedIdentityEntity federatedIdentityEntity = this.findSocialLink(user, socialProvider, realm);
        return federatedIdentityEntity != null ? new FederatedIdentityModel(federatedIdentityEntity.getIdentityProvider(), federatedIdentityEntity.getUserId(), federatedIdentityEntity.getUserName()) : null;
    }

    public UserAdapter addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        if (this.inMemoryModel.hasUserWithUsername(realm.getId(), username.toLowerCase())) {
            throw new ModelDuplicateException("User with username " + username + " already exists in realm.");
        }
        UserAdapter userModel = this.addUserEntity(realm, id, username.toLowerCase());
        if (addDefaultRoles) {
            for (String r : realm.getDefaultRoles()) {
                userModel.grantRole(realm.getRole(r));
            }
            for (ClientModel application : realm.getClients()) {
                for (String r : application.getDefaultRoles()) {
                    userModel.grantRole(application.getRole(r));
                }
            }
        }
        if (addDefaultRequiredActions) {
            for (String r : realm.getRequiredActionProviders()) {
                if (!r.isEnabled() || !r.isDefaultAction()) continue;
                userModel.addRequiredAction(r.getAlias());
            }
        }
        return userModel;
    }

    protected UserAdapter addUserEntity(RealmModel realm, String userId, String username) {
        if (realm == null) {
            throw new NullPointerException("realm == null");
        }
        if (username == null) {
            throw new NullPointerException("username == null");
        }
        if (userId == null) {
            userId = KeycloakModelUtils.generateId();
        }
        UserEntity userEntity = new UserEntity();
        userEntity.setId(userId);
        userEntity.setCreatedTimestamp(Long.valueOf(System.currentTimeMillis()));
        userEntity.setUsername(username);
        userEntity.setRealmId(realm.getId());
        UserAdapter user = new UserAdapter(realm, userEntity, this.inMemoryModel);
        this.inMemoryModel.putUser(realm.getId(), userId, (UserModel)user);
        return user;
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        return this.inMemoryModel.removeUser(realm.getId(), user.getId());
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel socialLink) {
        UserAdapter userAdapter = (UserAdapter)this.getUserById(user.getId(), realm);
        UserEntity userEntity = userAdapter.getUserEntity();
        FederatedIdentityEntity federatedIdentityEntity = new FederatedIdentityEntity();
        federatedIdentityEntity.setIdentityProvider(socialLink.getIdentityProvider());
        federatedIdentityEntity.setUserId(socialLink.getUserId());
        federatedIdentityEntity.setUserName(socialLink.getUserName().toLowerCase());
        for (FederatedIdentityEntity fedIdent : userEntity.getFederatedIdentities()) {
            if (!fedIdent.equals((Object)federatedIdentityEntity)) continue;
            return;
        }
        userEntity.getFederatedIdentities().add(federatedIdentityEntity);
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel userModel, String socialProvider) {
        UserModel user = this.getUserById(userModel.getId(), realm);
        UserEntity userEntity = ((UserAdapter)user).getUserEntity();
        FederatedIdentityEntity federatedIdentityEntity = this.findSocialLink(userEntity, socialProvider);
        if (federatedIdentityEntity == null) {
            return false;
        }
        userEntity.getFederatedIdentities().remove(federatedIdentityEntity);
        return true;
    }

    private FederatedIdentityEntity findSocialLink(UserEntity userEntity, String socialProvider) {
        List linkEntities = userEntity.getFederatedIdentities();
        if (linkEntities == null) {
            return null;
        }
        for (FederatedIdentityEntity federatedIdentityEntity : linkEntities) {
            if (!federatedIdentityEntity.getIdentityProvider().equals(socialProvider)) continue;
            return federatedIdentityEntity;
        }
        return null;
    }

    public UserModel addUser(RealmModel realm, String username) {
        return this.addUser(realm, KeycloakModelUtils.generateId(), username.toLowerCase(), true, true);
    }

    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        for (UserModel user : this.inMemoryModel.getUsers(realm.getId())) {
            user.grantRole(role);
        }
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, UserFederationProviderModel link) {
        HashSet<UserModel> toBeRemoved = new HashSet<UserModel>();
        for (UserModel user : this.inMemoryModel.getUsers(realm.getId())) {
            String fedLink = user.getFederationLink();
            if (fedLink == null || !fedLink.equals(link.getId())) continue;
            toBeRemoved.add(user);
        }
        for (UserModel user : toBeRemoved) {
            this.inMemoryModel.removeUser(realm.getId(), user.getId());
        }
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public void preRemove(RealmModel realm, ClientModel client) {
    }

    public void preRemove(ClientModel client, ProtocolMapperModel protocolMapper) {
    }

    public boolean validCredentials(RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        return CredentialValidation.validCredentials((RealmModel)realm, (UserModel)user, input);
    }

    public boolean validCredentials(RealmModel realm, UserModel user, UserCredentialModel ... input) {
        return CredentialValidation.validCredentials((RealmModel)realm, (UserModel)user, (UserCredentialModel[])input);
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        federatedUser = this.getUserById(federatedUser.getId(), realm);
        UserEntity userEntity = ((UserAdapter)federatedUser).getUserEntity();
        FederatedIdentityEntity federatedIdentityEntity = this.findFederatedIdentityLink(userEntity, federatedIdentityModel.getIdentityProvider());
        federatedIdentityEntity.setToken(federatedIdentityModel.getToken());
    }

    private FederatedIdentityEntity findFederatedIdentityLink(UserEntity userEntity, String identityProvider) {
        List linkEntities = userEntity.getFederatedIdentities();
        if (linkEntities == null) {
            return null;
        }
        for (FederatedIdentityEntity federatedIdentityEntity : linkEntities) {
            if (!federatedIdentityEntity.getIdentityProvider().equals(identityProvider)) continue;
            return federatedIdentityEntity;
        }
        return null;
    }

    public CredentialValidationOutput validCredentials(RealmModel realm, UserCredentialModel ... input) {
        return null;
    }
}

