/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.broker.oidc.mappers.AbstractClaimMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.HardcodedRoleMapper;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.JsonWebToken;

public class ExternalKeycloakRoleToRoleMapper
extends AbstractClaimMapper {
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"keycloak-oidc"};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    private static final String EXTERNAL_ROLE = "external.role";
    public static final String PROVIDER_ID = "keycloak-oidc-role-to-role-idp-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Role Importer";
    }

    public String getDisplayType() {
        return "External Role to Role";
    }

    public void importNewUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        RoleModel role = this.hasRole(realm, mapperModel, context);
        if (role != null) {
            user.grantRole(role);
        }
    }

    private RoleModel hasRole(RealmModel realm, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        JsonWebToken token = (JsonWebToken)context.getContextData().get("VALIDATED_ACCESS_TOKEN");
        String roleName = (String)mapperModel.getConfig().get("role");
        String[] parseRole = HardcodedRoleMapper.parseRole((String)((String)mapperModel.getConfig().get(EXTERNAL_ROLE)));
        String externalRoleName = parseRole[1];
        String claimName = null;
        claimName = parseRole[0] == null ? "realm_access.roles" : "resource_access." + parseRole[0] + ".roles";
        Object claim = ExternalKeycloakRoleToRoleMapper.getClaimValue(token, claimName);
        if (this.valueEquals(externalRoleName, claim)) {
            RoleModel role = HardcodedRoleMapper.getRoleFromString((RealmModel)realm, (String)roleName);
            if (role == null) {
                throw new IdentityBrokerException("Unable to find role: " + roleName);
            }
            return role;
        }
        return null;
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        RoleModel role = this.hasRole(realm, mapperModel, context);
        if (role == null) {
            user.deleteRoleMapping(role);
        }
    }

    public String getHelpText() {
        return "Looks for an external role in a keycloak access token.  If external role exists, grant the user the specified realm or application role.";
    }

    static {
        ProviderConfigProperty property1 = new ProviderConfigProperty();
        property1.setName(EXTERNAL_ROLE);
        property1.setLabel("External role");
        property1.setHelpText("External role to check for.  To reference an application role the syntax is appname.approle, i.e. myapp.myrole.");
        property1.setType("String");
        configProperties.add(property1);
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("role");
        property.setLabel("Role");
        property.setHelpText("Role to grant to user if external role is present.  Click 'Select Role' button to browse roles, or just type it in the textbox.  To reference an application role the syntax is appname.approle, i.e. myapp.myrole");
        property.setType("Role");
        configProperties.add(property);
    }
}

