/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.managers.RealmManager;

public class ApplianceBootstrap {
    private static final Logger logger = Logger.getLogger(ApplianceBootstrap.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap(KeycloakSessionFactory sessionFactory, String contextPath) {
        session.getTransaction().begin();
        try (KeycloakSession session = sessionFactory.create();){
            this.bootstrap(session, contextPath);
            session.getTransaction().commit();
        }
    }

    public void bootstrap(KeycloakSession session, String contextPath) {
        String adminRealmName = Config.getAdminRealm();
        if (session.realms().getRealm(adminRealmName) != null) {
            return;
        }
        logger.info((Object)("Initializing " + adminRealmName + " realm"));
        RealmManager manager = new RealmManager(session);
        manager.setContextPath(contextPath);
        RealmModel realm = manager.createRealm(adminRealmName, adminRealmName);
        realm.setName(adminRealmName);
        realm.setEnabled(true);
        realm.addRequiredCredential("password");
        realm.setSsoSessionIdleTimeout(1800);
        realm.setAccessTokenLifespan(60);
        realm.setSsoSessionMaxLifespan(36000);
        realm.setOfflineSessionIdleTimeout(2592000);
        realm.setAccessCodeLifespan(60);
        realm.setAccessCodeLifespanUserAction(300);
        realm.setAccessCodeLifespanLogin(1800);
        realm.setSslRequired(SslRequired.EXTERNAL);
        realm.setRegistrationAllowed(false);
        realm.setRegistrationEmailAsUsername(false);
        KeycloakModelUtils.generateRealmKeys((RealmModel)realm);
        UserModel adminUser = session.users().addUser(realm, "admin");
        ApplianceBootstrap.setupAdminUser(session, realm, adminUser, "admin");
    }

    public static void setupAdminUser(KeycloakSession session, RealmModel realm, UserModel adminUser, String password) {
        adminUser.setEnabled(true);
        UserCredentialModel usrCredModel = new UserCredentialModel();
        usrCredModel.setType("password");
        usrCredModel.setValue(password);
        session.users().updateCredential(realm, adminUser, usrCredModel);
        adminUser.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        RoleModel adminRole = realm.getRole(AdminRoles.ADMIN);
        adminUser.grantRole(adminRole);
        ClientModel accountApp = (ClientModel)realm.getClientNameMap().get("account");
        for (String r : accountApp.getDefaultRoles()) {
            adminUser.grantRole(accountApp.getRole(r));
        }
    }
}

