/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol;

import java.net.URI;
import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.RestartLoginCookie;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientSessionCode;

public abstract class AuthorizationEndpointBase {
    private static final Logger logger = Logger.getLogger(AuthorizationEndpointBase.class);
    protected RealmModel realm;
    protected EventBuilder event;
    protected AuthenticationManager authManager;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected HttpRequest request;
    @Context
    protected KeycloakSession session;
    @Context
    protected ClientConnection clientConnection;

    public AuthorizationEndpointBase(RealmModel realm, EventBuilder event, AuthenticationManager authManager) {
        this.realm = realm;
        this.event = event;
        this.authManager = authManager;
    }

    protected AuthenticationProcessor createProcessor(ClientSessionModel clientSession, String flowId, String flowPath) {
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setClientSession(clientSession).setFlowPath(flowPath).setFlowId(flowId).setBrowserFlow(true).setConnection(this.clientConnection).setEventBuilder(this.event).setProtector(this.authManager.getProtector()).setRealm(this.realm).setSession(this.session).setUriInfo(this.uriInfo).setRequest(this.request);
        return processor;
    }

    protected Response handleBrowserAuthenticationRequest(ClientSessionModel clientSession, LoginProtocol protocol, boolean isPassive) {
        List identityProviders = this.realm.getIdentityProviders();
        for (IdentityProviderModel identityProvider : identityProviders) {
            if (!identityProvider.isAuthenticateByDefault()) continue;
            return this.buildRedirectToIdentityProvider(identityProvider.getAlias(), new ClientSessionCode(this.realm, clientSession).getCode());
        }
        AuthenticationFlowModel flow = this.realm.getBrowserFlow();
        String flowId = flow.getId();
        AuthenticationProcessor processor = this.createProcessor(clientSession, flowId, "authenticate");
        if (isPassive) {
            Response challenge = null;
            Response challenge2 = null;
            try {
                challenge = processor.authenticateOnly();
                if (challenge == null) {
                    challenge2 = processor.attachSessionExecutionRequiredActions();
                }
            }
            catch (Exception e) {
                return processor.handleBrowserException(e);
            }
            if (challenge != null || challenge2 != null) {
                if (processor.isUserSessionCreated()) {
                    this.session.sessions().removeUserSession(this.realm, processor.getUserSession());
                }
                if (challenge != null) {
                    return protocol.sendError(clientSession, LoginProtocol.Error.PASSIVE_LOGIN_REQUIRED);
                }
                return protocol.sendError(clientSession, LoginProtocol.Error.PASSIVE_INTERACTION_REQUIRED);
            }
            return processor.finishAuthentication();
        }
        try {
            RestartLoginCookie.setRestartCookie(this.realm, this.clientConnection, this.uriInfo, clientSession);
            return processor.authenticate();
        }
        catch (Exception e) {
            return processor.handleBrowserException(e);
        }
    }

    protected Response buildRedirectToIdentityProvider(String providerId, String accessCode) {
        logger.debug((Object)("Automatically redirect to identity provider: " + providerId));
        return Response.temporaryRedirect((URI)Urls.identityProviderAuthnRequest(this.uriInfo.getBaseUri(), providerId, this.realm.getName(), accessCode)).build();
    }
}

