/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Transport;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.initializer.InitializerState;
import org.keycloak.models.sessions.infinispan.initializer.SessionInitializerWorker;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;
import org.keycloak.models.utils.KeycloakModelUtils;

public class InfinispanUserSessionInitializer {
    private static final Logger log = Logger.getLogger(InfinispanUserSessionInitializer.class);
    private static final String STATE_KEY_PREFIX = "initializerState";
    private final KeycloakSessionFactory sessionFactory;
    private final Cache<String, SessionEntity> cache;
    private final SessionLoader sessionLoader;
    private final int maxErrors;
    private final int sessionsPerSegment;
    private final String stateKey;
    private volatile CountDownLatch latch = new CountDownLatch(1);

    public InfinispanUserSessionInitializer(KeycloakSessionFactory sessionFactory, Cache<String, SessionEntity> cache, SessionLoader sessionLoader, int maxErrors, int sessionsPerSegment, String stateKeySuffix) {
        this.sessionFactory = sessionFactory;
        this.cache = cache;
        this.sessionLoader = sessionLoader;
        this.maxErrors = maxErrors;
        this.sessionsPerSegment = sessionsPerSegment;
        this.stateKey = "initializerState::" + stateKeySuffix;
    }

    public void initCache() {
        this.cache.getAdvancedCache().getComponentRegistry().registerComponent((Object)this.sessionFactory, KeycloakSessionFactory.class);
        this.cache.getCacheManager().addListener((Object)new ViewChangeListener());
    }

    public void loadPersistentSessions() {
        if (this.isFinished()) {
            return;
        }
        while (!this.isFinished()) {
            if (!this.isCoordinator()) {
                try {
                    this.latch.await(500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ie) {
                    log.error((Object)"Interrupted", (Throwable)ie);
                }
                continue;
            }
            this.startLoading();
        }
    }

    private boolean isFinished() {
        InitializerState state = (InitializerState)this.cache.get((Object)this.stateKey);
        return state != null && state.isFinished();
    }

    private InitializerState getOrCreateInitializerState() {
        InitializerState state = (InitializerState)this.cache.get((Object)this.stateKey);
        if (state == null) {
            final int[] count = new int[1];
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                public void run(KeycloakSession session) {
                    InfinispanUserSessionInitializer.this.sessionLoader.init(session);
                }
            });
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                public void run(KeycloakSession session) {
                    count[0] = InfinispanUserSessionInitializer.this.sessionLoader.getSessionsCount(session);
                }
            });
            state = new InitializerState();
            state.init(count[0], this.sessionsPerSegment);
            this.saveStateToCache(state);
        }
        return state;
    }

    private void saveStateToCache(final InitializerState state) {
        this.retry(3, new Runnable(){

            @Override
            public void run() {
                InfinispanUserSessionInitializer.this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FORCE_SYNCHRONOUS}).put((Object)InfinispanUserSessionInitializer.this.stateKey, (Object)state);
            }
        });
    }

    private boolean isCoordinator() {
        Transport transport = this.cache.getCacheManager().getTransport();
        return transport == null || transport.isCoordinator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoading() {
        InitializerState state = this.getOrCreateInitializerState();
        int processors = Runtime.getRuntime().availableProcessors();
        ExecutorService localExecutor = Executors.newCachedThreadPool();
        DefaultExecutorService distributedExecutorService = new DefaultExecutorService(this.cache, localExecutor);
        int errors = 0;
        try {
            while (!state.isFinished()) {
                Transport transport = this.cache.getCacheManager().getTransport();
                int nodesCount = transport == null ? 1 : transport.getMembers().size();
                int distributedWorkersCount = processors * nodesCount;
                log.debugf("Starting next iteration with %d workers", (Object)distributedWorkersCount);
                List<Integer> segments = state.getUnfinishedSegments(distributedWorkersCount);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("unfinished segments for this iteration: " + segments));
                }
                LinkedList<Future> futures = new LinkedList<Future>();
                for (Integer segment : segments) {
                    SessionInitializerWorker worker = new SessionInitializerWorker();
                    worker.setWorkerEnvironment(segment, this.sessionsPerSegment, this.sessionLoader);
                    Future future = distributedExecutorService.submit((Callable)((Object)worker));
                    futures.add(future);
                }
                for (Future future : futures) {
                    try {
                        WorkerResult result = (WorkerResult)future.get();
                        if (result.getSuccess().booleanValue()) {
                            int computedSegment = result.getSegment();
                            state.markSegmentFinished(computedSegment);
                            continue;
                        }
                        if (!log.isTraceEnabled()) continue;
                        log.tracef("Segment %d failed to compute", (Object)result.getSegment());
                    }
                    catch (InterruptedException ie) {
                        log.error((Object)("Interruped exception when computed future. Errors: " + ++errors), (Throwable)ie);
                    }
                    catch (ExecutionException ee) {
                        log.error((Object)("ExecutionException when computed future. Errors: " + ++errors), (Throwable)ee);
                    }
                }
                if (errors >= this.maxErrors) {
                    throw new RuntimeException("Maximum count of worker errors occured. Limit was " + this.maxErrors + ". See server.log for details");
                }
                this.saveStateToCache(state);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("New initializer state pushed. The state is: " + state.printState()));
            }
        }
        finally {
            distributedExecutorService.shutdown();
            localExecutor.shutdown();
        }
    }

    private void retry(int retry, Runnable runnable) {
        while (true) {
            try {
                runnable.run();
                return;
            }
            catch (RuntimeException e) {
                if (--retry != 0) continue;
                throw e;
            }
            break;
        }
    }

    public static class WorkerResult
    implements Serializable {
        private Integer segment;
        private Boolean success;

        public static WorkerResult create(Integer segment, boolean success) {
            WorkerResult res = new WorkerResult();
            res.setSegment(segment);
            res.setSuccess(success);
            return res;
        }

        public Integer getSegment() {
            return this.segment;
        }

        public void setSegment(Integer segment) {
            this.segment = segment;
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }
    }

    @Listener
    public class ViewChangeListener {
        @ViewChanged
        public void viewChanged(ViewChangedEvent event) {
            boolean isCoordinator = InfinispanUserSessionInitializer.this.isCoordinator();
            log.debug((Object)("View Changed: is coordinator: " + isCoordinator));
            if (isCoordinator) {
                InfinispanUserSessionInitializer.this.latch.countDown();
                InfinispanUserSessionInitializer.this.latch = new CountDownLatch(1);
            }
        }
    }
}

