/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.resetcred;

import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.models.utils.HmacOTP;
import org.keycloak.provider.ProviderConfigProperty;

public class ResetCredentialEmail
implements Authenticator,
AuthenticatorFactory {
    public static final String RESET_CREDENTIAL_SECRET = "RESET_CREDENTIAL_SECRET";
    protected static Logger logger = Logger.getLogger(ResetCredentialEmail.class);
    public static final String PROVIDER_ID = "reset-credential-email";
    public static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED};

    @Override
    public void authenticate(AuthenticationFlowContext context) {
        UserModel user = context.getUser();
        String username = context.getClientSession().getNote("ATTEMPTED_USERNAME");
        if (user == null) {
            context.forkWithSuccessMessage(new FormMessage("emailSentMessage", new Object[0]));
            return;
        }
        EventBuilder event = context.getEvent();
        if (user.getEmail() == null || user.getEmail().trim().length() == 0) {
            event.user(user).detail("username", username).error("invalid_email");
            context.forkWithSuccessMessage(new FormMessage("emailSentMessage", new Object[0]));
            return;
        }
        String secret = HmacOTP.generateSecret((int)10);
        context.getClientSession().setNote(RESET_CREDENTIAL_SECRET, secret);
        String link = UriBuilder.fromUri((URI)context.getActionUrl()).queryParam("key", new Object[]{secret}).build(new Object[0]).toString();
        long expiration = TimeUnit.SECONDS.toMinutes(context.getRealm().getAccessCodeLifespanUserAction());
        try {
            ((EmailTemplateProvider)context.getSession().getProvider(EmailTemplateProvider.class)).setRealm(context.getRealm()).setUser(user).sendPasswordReset(link, expiration);
            event.clone().event(EventType.SEND_RESET_PASSWORD).user(user).detail("username", username).detail("email", user.getEmail()).detail("code_id", context.getClientSession().getId()).success();
            context.forkWithSuccessMessage(new FormMessage("emailSentMessage", new Object[0]));
        }
        catch (EmailException e) {
            event.clone().event(EventType.SEND_RESET_PASSWORD).detail("username", username).user(user).error("email_send_failed");
            logger.error((Object)"Failed to send password reset email", (Throwable)e);
            Response challenge = context.form().setError("emailSendErrorMessage", new Object[0]).createErrorPage();
            context.failure(AuthenticationFlowError.INTERNAL_ERROR, challenge);
        }
    }

    @Override
    public void action(AuthenticationFlowContext context) {
        String secret = context.getClientSession().getNote(RESET_CREDENTIAL_SECRET);
        String key = (String)context.getUriInfo().getQueryParameters().getFirst((Object)"key");
        context.getClientSession().removeNote(RESET_CREDENTIAL_SECRET);
        if (secret == null || key == null || !secret.equals(key)) {
            context.getEvent().error("invalid_user_credentials");
            Response challenge = context.form().setError("invalidAccessCodeMessage", new Object[0]).createErrorPage();
            context.failure(AuthenticationFlowError.INTERNAL_ERROR, challenge);
            return;
        }
        context.getUser().setEmailVerified(true);
        context.success();
    }

    @Override
    public boolean requiresUser() {
        return false;
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    @Override
    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    @Override
    public String getDisplayType() {
        return "Send Reset Email";
    }

    @Override
    public String getReferenceCategory() {
        return null;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    @Override
    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return "Send email to user and wait for response.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public void close() {
    }

    public Authenticator create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

