/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.AbstractLoginProtocolFactory;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.OIDCLoginProtocol;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.mappers.AddressMapper;
import org.keycloak.protocol.oidc.mappers.UserAttributeMapper;
import org.keycloak.protocol.oidc.mappers.UserPropertyMapper;
import org.keycloak.protocol.oidc.mappers.UserSessionNoteMapper;
import org.keycloak.services.managers.AuthenticationManager;

public class OIDCLoginProtocolFactory
extends AbstractLoginProtocolFactory {
    public static final String USERNAME = "username";
    public static final String EMAIL = "email";
    public static final String EMAIL_VERIFIED = "email verified";
    public static final String GIVEN_NAME = "given name";
    public static final String FAMILY_NAME = "family name";
    public static final String FULL_NAME = "full name";
    public static final String LOCALE = "locale";
    public static final String USERNAME_CONSENT_TEXT = "${username}";
    public static final String EMAIL_CONSENT_TEXT = "${email}";
    public static final String EMAIL_VERIFIED_CONSENT_TEXT = "${emailVerified}";
    public static final String GIVEN_NAME_CONSENT_TEXT = "${givenName}";
    public static final String FAMILY_NAME_CONSENT_TEXT = "${familyName}";
    public static final String FULL_NAME_CONSENT_TEXT = "${fullName}";
    public static final String LOCALE_CONSENT_TEXT = "${locale}";
    static List<ProtocolMapperModel> builtins = new ArrayList<ProtocolMapperModel>();
    static List<ProtocolMapperModel> defaultBuiltins = new ArrayList<ProtocolMapperModel>();

    public LoginProtocol create(KeycloakSession session) {
        return new OIDCLoginProtocol().setSession(session);
    }

    @Override
    public List<ProtocolMapperModel> getBuiltinMappers() {
        return builtins;
    }

    @Override
    public List<ProtocolMapperModel> getDefaultBuiltinMappers() {
        return defaultBuiltins;
    }

    @Override
    protected void addDefaults(ClientModel client) {
        for (ProtocolMapperModel model : defaultBuiltins) {
            client.addProtocolMapper(model);
        }
    }

    @Override
    public Object createProtocolEndpoint(RealmModel realm, EventBuilder event, AuthenticationManager authManager) {
        return new OIDCLoginProtocolService(realm, event, authManager);
    }

    public String getId() {
        return "openid-connect";
    }

    static {
        ProtocolMapperModel model = UserPropertyMapper.createClaimMapper(USERNAME, USERNAME, "preferred_username", "String", true, USERNAME_CONSENT_TEXT, true, true);
        builtins.add(model);
        defaultBuiltins.add(model);
        model = UserPropertyMapper.createClaimMapper(EMAIL, EMAIL, EMAIL, "String", true, EMAIL_CONSENT_TEXT, true, true);
        builtins.add(model);
        defaultBuiltins.add(model);
        model = UserPropertyMapper.createClaimMapper(GIVEN_NAME, "firstName", "given_name", "String", true, GIVEN_NAME_CONSENT_TEXT, true, true);
        builtins.add(model);
        defaultBuiltins.add(model);
        model = UserPropertyMapper.createClaimMapper(FAMILY_NAME, "lastName", "family_name", "String", true, FAMILY_NAME_CONSENT_TEXT, true, true);
        builtins.add(model);
        defaultBuiltins.add(model);
        model = UserPropertyMapper.createClaimMapper(EMAIL_VERIFIED, "emailVerified", "email_verified", "boolean", false, EMAIL_VERIFIED_CONSENT_TEXT, true, true);
        builtins.add(model);
        model = UserAttributeMapper.createClaimMapper(LOCALE, LOCALE, LOCALE, "String", false, LOCALE_CONSENT_TEXT, true, true, false);
        builtins.add(model);
        ProtocolMapperModel fullName = new ProtocolMapperModel();
        fullName.setName(FULL_NAME);
        fullName.setProtocolMapper("oidc-full-name-mapper");
        fullName.setProtocol("openid-connect");
        fullName.setConsentRequired(true);
        fullName.setConsentText(FULL_NAME_CONSENT_TEXT);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("access.token.claim", "true");
        config.put("id.token.claim", "true");
        fullName.setConfig(config);
        builtins.add(fullName);
        defaultBuiltins.add(fullName);
        ProtocolMapperModel address = AddressMapper.createAddressMapper();
        builtins.add(address);
        model = UserSessionNoteMapper.createClaimMapper("gss delegation credential", "gss_delegation_credential", "gss_delegation_credential", "String", true, "${gssDelegationCredential}", true, false);
        builtins.add(model);
    }
}

