/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.hash;

import org.keycloak.hash.PasswordHashProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialValueModel;

public class PasswordHashManager {
    public static UserCredentialValueModel encode(KeycloakSession session, RealmModel realm, String rawPassword) {
        PasswordHashProvider provider;
        PasswordPolicy passwordPolicy = realm.getPasswordPolicy();
        String algorithm = passwordPolicy.getHashAlgorithm();
        int iterations = passwordPolicy.getHashIterations();
        if (iterations < 1) {
            iterations = 1;
        }
        if ((provider = session.getProvider(PasswordHashProvider.class, algorithm)) == null) {
            throw new RuntimeException("Password hash provider for algorithm " + algorithm + " not found");
        }
        return provider.encode(rawPassword, iterations);
    }

    public static boolean verify(KeycloakSession session, RealmModel realm, String password, UserCredentialValueModel credential) {
        String algorithm = credential.getAlgorithm() != null ? credential.getAlgorithm() : realm.getPasswordPolicy().getHashAlgorithm();
        PasswordHashProvider provider = session.getProvider(PasswordHashProvider.class, algorithm);
        return provider.verify(password, credential);
    }
}

