/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.io.Serializable;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.distexec.DistributedCallable;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.initializer.InfinispanUserSessionInitializer;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;
import org.keycloak.models.utils.KeycloakModelUtils;

public class SessionInitializerWorker
implements DistributedCallable<String, SessionEntity, InfinispanUserSessionInitializer.WorkerResult>,
Serializable {
    private static final Logger log = Logger.getLogger(SessionInitializerWorker.class);
    private int segment;
    private int sessionsPerSegment;
    private SessionLoader sessionLoader;
    private transient Cache<String, SessionEntity> cache;

    public void setWorkerEnvironment(int segment, int sessionsPerSegment, SessionLoader sessionLoader) {
        this.segment = segment;
        this.sessionsPerSegment = sessionsPerSegment;
        this.sessionLoader = sessionLoader;
    }

    public void setEnvironment(Cache<String, SessionEntity> cache, Set<String> inputKeys) {
        this.cache = cache;
    }

    public InfinispanUserSessionInitializer.WorkerResult call() throws Exception {
        KeycloakSessionFactory sessionFactory;
        if (log.isTraceEnabled()) {
            log.tracef("Running computation for segment: %d", (Object)this.segment);
        }
        if ((sessionFactory = (KeycloakSessionFactory)this.cache.getAdvancedCache().getComponentRegistry().getComponent(KeycloakSessionFactory.class)) == null) {
            log.warnf("KeycloakSessionFactory not yet set in cache. Worker skipped", new Object[0]);
            return InfinispanUserSessionInitializer.WorkerResult.create(this.segment, false);
        }
        final int first = this.segment * this.sessionsPerSegment;
        final int max = this.sessionsPerSegment;
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                SessionInitializerWorker.this.sessionLoader.loadSessions(session, first, max);
            }
        });
        return InfinispanUserSessionInitializer.WorkerResult.create(this.segment, true);
    }
}

