/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core.supplier;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import liquibase.sdk.exception.UnexpectedLiquibaseSdkException;
import liquibase.sdk.supplier.database.ConnectionSupplier;

public class OracleConnSupplier
extends ConnectionSupplier {
    @Override
    public String getDatabaseShortName() {
        return "oracle";
    }

    @Override
    public String getAdminUsername() {
        return "system";
    }

    @Override
    public String getJdbcUrl() {
        return "jdbc:oracle:thin:@" + this.getIpAddress() + ":1521:" + this.getSid();
    }

    @Override
    public String getPrimaryCatalog() {
        return this.getDatabaseUsername();
    }

    @Override
    public String getAlternateCatalog() {
        return this.getAlternateUsername();
    }

    @Override
    public Set<String> getRequiredPackages(String vagrantBoxName) {
        Set<String> requiredPackages = super.getRequiredPackages(vagrantBoxName);
        requiredPackages.addAll(Arrays.asList("binutils", "compat-libcap1", "gcc", "gcc-c++", "glibc", "glibc-devel", "ksh", "libgcc", "libstdc++", "libstdc++-devel", "libaio", "libaio-devel", "libXext", "libX11", "libXau", "libxcb", "libXi", "make", "sysstat", "rlwrap"));
        return requiredPackages;
    }

    @Override
    public ConnectionSupplier.ConfigTemplate getPuppetTemplate(Map<String, Object> context) {
        if (this.isWindows()) {
            return new ConnectionSupplier.ConfigTemplate("liquibase/sdk/vagrant/supplier/oracle/oracle-windows.puppet.vm", context);
        }
        return new ConnectionSupplier.ConfigTemplate("liquibase/sdk/vagrant/supplier/oracle/oracle-linux.puppet.vm", context);
    }

    @Override
    public Set<ConnectionSupplier.ConfigTemplate> generateConfigFiles(Map<String, Object> context) throws IOException {
        Set<ConnectionSupplier.ConfigTemplate> configTemplates = super.generateConfigFiles(context);
        configTemplates.add(new ConnectionSupplier.ConfigTemplate("liquibase/sdk/vagrant/supplier/oracle/oracle_install.rsp.vm", context));
        configTemplates.add(new ConnectionSupplier.ConfigTemplate("liquibase/sdk/vagrant/supplier/oracle/oracle_netca.rsp.vm", context));
        configTemplates.add(new ConnectionSupplier.ConfigTemplate("liquibase/sdk/vagrant/supplier/oracle/oracle.init.sql.vm", context));
        return configTemplates;
    }

    @Override
    public String getVersion() {
        return "12.1.0.1";
    }

    public String getZipFileBase() {
        if (this.getVersion().startsWith("12.")) {
            if (this.isWindows()) {
                return "winx64_12c_database";
            }
            return "linuxamd64_12c_database";
        }
        throw new UnexpectedLiquibaseSdkException("Unsupported oracle version: " + this.getVersion());
    }

    public String getInstallDir() {
        if (this.isWindows()) {
            return "C:\\oracle-" + this.getVersion();
        }
        return "/opt/oracle";
    }

    public String getOracleHome() {
        if (this.getVersion().startsWith("12.")) {
            return this.getInstallDir() + this.getFileSeparator() + "12c";
        }
        throw new UnexpectedLiquibaseSdkException("Unsupported oracle version: " + this.getVersion());
    }

    public String getSysPassword() {
        return this.getAdminPassword();
    }

    public String getSystemPassword() {
        return this.getAdminPassword();
    }

    public String getSid() {
        return "lqbase";
    }

    @Override
    public String getDescription() {
        return super.getDescription() + "SID: " + this.getSid() + "\n" + "Oracle Base: " + this.getInstallDir() + "\n" + "Oracle Home: " + this.getOracleHome() + "\n" + "SYS User Password: " + this.getSysPassword() + "\n" + "SYSTEM User Password: " + this.getSystemPassword() + "\n" + "\n" + "REQUIRED: You must manually download the oracle installation files into LIQUIBASE_HOME/sdk/vagrant/install-files/oracle/\n" + "      You can download the install files from http://www.oracle.com/technetwork/database/enterprise-edition/downloads/index.html with a free OTN account\n" + "      Expected files: " + this.getZipFileBase() + "_*.zip\n" + "\n" + "NOTE: For easier sqlplus usage, rlwrap is installed. See http://www.oraclealchemist.com/news/add-history-and-tab-completion-to-sqlplus/ for more information";
    }
}

