/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import org.keycloak.models.ClientConfigResolver;
import org.keycloak.models.ClientModel;
import org.keycloak.saml.SignatureAlgorithm;

public class SamlClient
extends ClientConfigResolver {
    public SamlClient(ClientModel client) {
        super(client);
    }

    public String getCanonicalizationMethod() {
        return this.resolveAttribute("saml_signature_canonicalization_method");
    }

    public void setCanonicalizationMethod(String value) {
        this.client.setAttribute("saml_signature_canonicalization_method", value);
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        SignatureAlgorithm algorithm;
        String alg = this.resolveAttribute("saml.signature.algorithm");
        if (alg != null && (algorithm = SignatureAlgorithm.valueOf((String)alg)) != null) {
            return algorithm;
        }
        return SignatureAlgorithm.RSA_SHA256;
    }

    public void setSignatureAlgorithm(SignatureAlgorithm algorithm) {
        this.client.setAttribute("saml.signature.algorithm", algorithm.name());
    }

    public String getNameIDFormat() {
        return this.resolveAttribute("saml_name_id_format");
    }

    public void setNameIDFormat(String format) {
        this.client.setAttribute("saml_name_id_format", format);
    }

    public boolean includeAuthnStatement() {
        return "true".equals(this.resolveAttribute("saml.authnstatement"));
    }

    public void setIncludeAuthnStatement(boolean val) {
        this.client.setAttribute("saml.authnstatement", Boolean.toString(val));
    }

    public boolean forceNameIDFormat() {
        return "true".equals(this.resolveAttribute("saml_force_name_id_format"));
    }

    public void setForceNameIDFormat(boolean val) {
        this.client.setAttribute("saml_force_name_id_format", Boolean.toString(val));
    }

    public boolean requiresRealmSignature() {
        return "true".equals(this.resolveAttribute("saml.server.signature"));
    }

    public void setRequiresRealmSignature(boolean val) {
        this.client.setAttribute("saml.server.signature", Boolean.toString(val));
    }

    public boolean forcePostBinding() {
        return "true".equals(this.resolveAttribute("saml.force.post.binding"));
    }

    public void setForcePostBinding(boolean val) {
        this.client.setAttribute("saml.force.post.binding", Boolean.toString(val));
    }

    public boolean requiresAssertionSignature() {
        return "true".equals(this.resolveAttribute("saml.assertion.signature"));
    }

    public void setRequiresAssertionSignature(boolean val) {
        this.client.setAttribute("saml.assertion.signature", Boolean.toString(val));
    }

    public boolean requiresEncryption() {
        return "true".equals(this.resolveAttribute("saml.encrypt"));
    }

    public void setRequiresEncryption(boolean val) {
        this.client.setAttribute("saml.encrypt", Boolean.toString(val));
    }

    public boolean requiresClientSignature() {
        return "true".equals(this.resolveAttribute("saml.client.signature"));
    }

    public void setRequiresClientSignature(boolean val) {
        this.client.setAttribute("saml.client.signature", Boolean.toString(val));
    }

    public String getClientSigningCertificate() {
        return this.client.getAttribute("saml.signing.certificate");
    }

    public void setClientSigningCertificate(String val) {
        this.client.setAttribute("saml.signing.certificate", val);
    }

    public String getClientSigningPrivateKey() {
        return this.client.getAttribute("saml.signing.private.key");
    }

    public void setClientSigningPrivateKey(String val) {
        this.client.setAttribute("saml.signing.private.key", val);
    }

    public String getClientEncryptingCertificate() {
        return this.client.getAttribute("saml.encryption.certificate");
    }

    public void setClientEncryptingCertificate(String val) {
        this.client.setAttribute("saml.encryption.certificate", val);
    }

    public String getClientEncryptingPrivateKey() {
        return this.client.getAttribute("saml.encryption.private.key");
    }

    public void setClientEncryptingPrivateKey(String val) {
        this.client.setAttribute("saml.encryption.private.key", val);
    }
}

