/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.entities;

import java.io.Serializable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.cache.RealmCache;
import org.keycloak.models.cache.entities.CachedClient;
import org.keycloak.models.cache.entities.CachedClientTemplate;
import org.keycloak.models.cache.entities.CachedRealmRole;

public class CachedRealm
implements Serializable {
    protected String id;
    protected String name;
    protected String displayName;
    protected String displayNameHtml;
    protected boolean enabled;
    protected SslRequired sslRequired;
    protected boolean registrationAllowed;
    protected boolean registrationEmailAsUsername;
    protected boolean rememberMe;
    protected boolean verifyEmail;
    protected boolean resetPasswordAllowed;
    protected boolean identityFederationEnabled;
    protected boolean editUsernameAllowed;
    protected boolean bruteForceProtected;
    protected int maxFailureWaitSeconds;
    protected int minimumQuickLoginWaitSeconds;
    protected int waitIncrementSeconds;
    protected long quickLoginCheckMilliSeconds;
    protected int maxDeltaTimeSeconds;
    protected int failureFactor;
    protected boolean revokeRefreshToken;
    protected int ssoSessionIdleTimeout;
    protected int ssoSessionMaxLifespan;
    protected int offlineSessionIdleTimeout;
    protected int accessTokenLifespan;
    protected int accessTokenLifespanForImplicitFlow;
    protected int accessCodeLifespan;
    protected int accessCodeLifespanUserAction;
    protected int accessCodeLifespanLogin;
    protected int notBefore;
    protected PasswordPolicy passwordPolicy;
    protected OTPPolicy otpPolicy;
    protected transient PublicKey publicKey;
    protected String publicKeyPem;
    protected transient PrivateKey privateKey;
    protected String privateKeyPem;
    protected transient X509Certificate certificate;
    protected String certificatePem;
    protected String codeSecret;
    protected String loginTheme;
    protected String accountTheme;
    protected String adminTheme;
    protected String emailTheme;
    protected String masterAdminClient;
    protected List<RequiredCredentialModel> requiredCredentials;
    protected List<UserFederationProviderModel> userFederationProviders;
    protected MultivaluedHashMap<String, UserFederationMapperModel> userFederationMappers = new MultivaluedHashMap();
    protected Set<UserFederationMapperModel> userFederationMapperSet;
    protected List<IdentityProviderModel> identityProviders;
    protected Map<String, String> browserSecurityHeaders;
    protected Map<String, String> smtpConfig;
    protected Map<String, AuthenticationFlowModel> authenticationFlows = new HashMap<String, AuthenticationFlowModel>();
    protected List<AuthenticationFlowModel> authenticationFlowList;
    protected Map<String, AuthenticatorConfigModel> authenticatorConfigs = new HashMap<String, AuthenticatorConfigModel>();
    protected Map<String, RequiredActionProviderModel> requiredActionProviders = new HashMap<String, RequiredActionProviderModel>();
    protected List<RequiredActionProviderModel> requiredActionProviderList;
    protected Map<String, RequiredActionProviderModel> requiredActionProvidersByAlias = new HashMap<String, RequiredActionProviderModel>();
    protected MultivaluedHashMap<String, AuthenticationExecutionModel> authenticationExecutions = new MultivaluedHashMap();
    protected Map<String, AuthenticationExecutionModel> executionsById = new HashMap<String, AuthenticationExecutionModel>();
    protected AuthenticationFlowModel browserFlow;
    protected AuthenticationFlowModel registrationFlow;
    protected AuthenticationFlowModel directGrantFlow;
    protected AuthenticationFlowModel resetCredentialsFlow;
    protected AuthenticationFlowModel clientAuthenticationFlow;
    protected boolean eventsEnabled;
    protected long eventsExpiration;
    protected Set<String> eventsListeners;
    protected Set<String> enabledEventTypes;
    protected boolean adminEventsEnabled;
    protected Set<String> adminEnabledEventOperations = new HashSet<String>();
    protected boolean adminEventsDetailsEnabled;
    protected List<String> defaultRoles;
    protected List<String> defaultGroups = new LinkedList<String>();
    protected Set<String> groups = new HashSet<String>();
    protected Map<String, String> realmRoles = new HashMap<String, String>();
    protected List<String> clients = new LinkedList<String>();
    protected List<String> clientTemplates = new LinkedList<String>();
    protected boolean internationalizationEnabled;
    protected Set<String> supportedLocales;
    protected String defaultLocale;
    protected MultivaluedHashMap<String, IdentityProviderMapperModel> identityProviderMappers = new MultivaluedHashMap();
    protected Set<IdentityProviderMapperModel> identityProviderMapperSet;

    public Set<IdentityProviderMapperModel> getIdentityProviderMapperSet() {
        return this.identityProviderMapperSet;
    }

    public CachedRealm() {
    }

    public CachedRealm(RealmCache cache, RealmProvider delegate, RealmModel model) {
        this.id = model.getId();
        this.name = model.getName();
        this.displayName = model.getDisplayName();
        this.displayNameHtml = model.getDisplayNameHtml();
        this.enabled = model.isEnabled();
        this.sslRequired = model.getSslRequired();
        this.registrationAllowed = model.isRegistrationAllowed();
        this.registrationEmailAsUsername = model.isRegistrationEmailAsUsername();
        this.rememberMe = model.isRememberMe();
        this.verifyEmail = model.isVerifyEmail();
        this.resetPasswordAllowed = model.isResetPasswordAllowed();
        this.identityFederationEnabled = model.isIdentityFederationEnabled();
        this.editUsernameAllowed = model.isEditUsernameAllowed();
        this.bruteForceProtected = model.isBruteForceProtected();
        this.maxFailureWaitSeconds = model.getMaxFailureWaitSeconds();
        this.minimumQuickLoginWaitSeconds = model.getMinimumQuickLoginWaitSeconds();
        this.waitIncrementSeconds = model.getWaitIncrementSeconds();
        this.quickLoginCheckMilliSeconds = model.getQuickLoginCheckMilliSeconds();
        this.maxDeltaTimeSeconds = model.getMaxDeltaTimeSeconds();
        this.failureFactor = model.getFailureFactor();
        this.revokeRefreshToken = model.isRevokeRefreshToken();
        this.ssoSessionIdleTimeout = model.getSsoSessionIdleTimeout();
        this.ssoSessionMaxLifespan = model.getSsoSessionMaxLifespan();
        this.offlineSessionIdleTimeout = model.getOfflineSessionIdleTimeout();
        this.accessTokenLifespan = model.getAccessTokenLifespan();
        this.accessTokenLifespanForImplicitFlow = model.getAccessTokenLifespanForImplicitFlow();
        this.accessCodeLifespan = model.getAccessCodeLifespan();
        this.accessCodeLifespanUserAction = model.getAccessCodeLifespanUserAction();
        this.accessCodeLifespanLogin = model.getAccessCodeLifespanLogin();
        this.notBefore = model.getNotBefore();
        this.passwordPolicy = model.getPasswordPolicy();
        this.otpPolicy = model.getOTPPolicy();
        this.publicKeyPem = model.getPublicKeyPem();
        this.publicKey = model.getPublicKey();
        this.privateKeyPem = model.getPrivateKeyPem();
        this.privateKey = model.getPrivateKey();
        this.certificatePem = model.getCertificatePem();
        this.certificate = model.getCertificate();
        this.codeSecret = model.getCodeSecret();
        this.loginTheme = model.getLoginTheme();
        this.accountTheme = model.getAccountTheme();
        this.adminTheme = model.getAdminTheme();
        this.emailTheme = model.getEmailTheme();
        this.requiredCredentials = model.getRequiredCredentials();
        this.userFederationProviders = model.getUserFederationProviders();
        this.userFederationMapperSet = model.getUserFederationMappers();
        for (UserFederationMapperModel userFederationMapperModel : this.userFederationMapperSet) {
            this.userFederationMappers.add((Object)userFederationMapperModel.getFederationProviderId(), (Object)userFederationMapperModel);
        }
        this.identityProviders = new ArrayList<IdentityProviderModel>();
        for (IdentityProviderModel identityProviderModel : model.getIdentityProviders()) {
            this.identityProviders.add(new IdentityProviderModel(identityProviderModel));
        }
        this.identityProviders = Collections.unmodifiableList(this.identityProviders);
        this.identityProviderMapperSet = model.getIdentityProviderMappers();
        for (IdentityProviderMapperModel identityProviderMapperModel : this.identityProviderMapperSet) {
            this.identityProviderMappers.add((Object)identityProviderMapperModel.getIdentityProviderAlias(), (Object)identityProviderMapperModel);
        }
        this.smtpConfig = model.getSmtpConfig();
        this.browserSecurityHeaders = model.getBrowserSecurityHeaders();
        this.eventsEnabled = model.isEventsEnabled();
        this.eventsExpiration = model.getEventsExpiration();
        this.eventsListeners = model.getEventsListeners();
        this.enabledEventTypes = model.getEnabledEventTypes();
        this.adminEventsEnabled = model.isAdminEventsEnabled();
        this.adminEventsDetailsEnabled = model.isAdminEventsDetailsEnabled();
        this.defaultRoles = model.getDefaultRoles();
        ClientModel masterAdminClient = model.getMasterAdminClient();
        this.masterAdminClient = masterAdminClient != null ? masterAdminClient.getId() : null;
        this.cacheRealmRoles(cache, model);
        this.cacheClients(cache, delegate, model);
        this.cacheClientTemplates(cache, delegate, model);
        this.internationalizationEnabled = model.isInternationalizationEnabled();
        this.supportedLocales = model.getSupportedLocales();
        this.defaultLocale = model.getDefaultLocale();
        this.authenticationFlowList = model.getAuthenticationFlows();
        for (AuthenticationFlowModel flow : this.authenticationFlowList) {
            this.authenticationFlows.put(flow.getId(), flow);
            this.authenticationExecutions.put((Object)flow.getId(), new LinkedList());
            for (AuthenticationExecutionModel execution : model.getAuthenticationExecutions(flow.getId())) {
                this.authenticationExecutions.add((Object)flow.getId(), (Object)execution);
                this.executionsById.put(execution.getId(), execution);
            }
        }
        for (GroupModel group : model.getGroups()) {
            this.groups.add(group.getId());
        }
        for (AuthenticatorConfigModel authenticator : model.getAuthenticatorConfigs()) {
            this.authenticatorConfigs.put(authenticator.getId(), authenticator);
        }
        this.requiredActionProviderList = model.getRequiredActionProviders();
        for (RequiredActionProviderModel action : this.requiredActionProviderList) {
            this.requiredActionProviders.put(action.getId(), action);
            this.requiredActionProvidersByAlias.put(action.getAlias(), action);
        }
        for (GroupModel group : model.getDefaultGroups()) {
            this.defaultGroups.add(group.getId());
        }
        this.browserFlow = model.getBrowserFlow();
        this.registrationFlow = model.getRegistrationFlow();
        this.directGrantFlow = model.getDirectGrantFlow();
        this.resetCredentialsFlow = model.getResetCredentialsFlow();
        this.clientAuthenticationFlow = model.getClientAuthenticationFlow();
    }

    protected void cacheClientTemplates(RealmCache cache, RealmProvider delegate, RealmModel model) {
        for (ClientTemplateModel template : model.getClientTemplates()) {
            this.clientTemplates.add(template.getId());
            CachedClientTemplate cachedClient = new CachedClientTemplate(cache, delegate, model, template);
            cache.addClientTemplate(cachedClient);
        }
    }

    protected void cacheClients(RealmCache cache, RealmProvider delegate, RealmModel model) {
        for (ClientModel client : model.getClients()) {
            this.clients.add(client.getId());
            CachedClient cachedClient = new CachedClient(cache, delegate, model, client);
            cache.addClient(cachedClient);
        }
    }

    protected void cacheRealmRoles(RealmCache cache, RealmModel model) {
        for (RoleModel role : model.getRoles()) {
            this.realmRoles.put(role.getName(), role.getId());
            CachedRealmRole cachedRole = new CachedRealmRole(role, model);
            cache.addRole(cachedRole);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getMasterAdminClient() {
        return this.masterAdminClient;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameHtml() {
        return this.displayNameHtml;
    }

    public List<String> getDefaultRoles() {
        return this.defaultRoles;
    }

    public Map<String, String> getRealmRoles() {
        return this.realmRoles;
    }

    public List<String> getClients() {
        return this.clients;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public SslRequired getSslRequired() {
        return this.sslRequired;
    }

    public boolean isRegistrationAllowed() {
        return this.registrationAllowed;
    }

    public boolean isRegistrationEmailAsUsername() {
        return this.registrationEmailAsUsername;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public boolean isBruteForceProtected() {
        return this.bruteForceProtected;
    }

    public int getMaxFailureWaitSeconds() {
        return this.maxFailureWaitSeconds;
    }

    public int getWaitIncrementSeconds() {
        return this.waitIncrementSeconds;
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.minimumQuickLoginWaitSeconds;
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.quickLoginCheckMilliSeconds;
    }

    public int getMaxDeltaTimeSeconds() {
        return this.maxDeltaTimeSeconds;
    }

    public int getFailureFactor() {
        return this.failureFactor;
    }

    public boolean isVerifyEmail() {
        return this.verifyEmail;
    }

    public boolean isResetPasswordAllowed() {
        return this.resetPasswordAllowed;
    }

    public boolean isEditUsernameAllowed() {
        return this.editUsernameAllowed;
    }

    public boolean isRevokeRefreshToken() {
        return this.revokeRefreshToken;
    }

    public int getSsoSessionIdleTimeout() {
        return this.ssoSessionIdleTimeout;
    }

    public int getSsoSessionMaxLifespan() {
        return this.ssoSessionMaxLifespan;
    }

    public int getOfflineSessionIdleTimeout() {
        return this.offlineSessionIdleTimeout;
    }

    public int getAccessTokenLifespan() {
        return this.accessTokenLifespan;
    }

    public int getAccessTokenLifespanForImplicitFlow() {
        return this.accessTokenLifespanForImplicitFlow;
    }

    public int getAccessCodeLifespan() {
        return this.accessCodeLifespan;
    }

    public int getAccessCodeLifespanUserAction() {
        return this.accessCodeLifespanUserAction;
    }

    public int getAccessCodeLifespanLogin() {
        return this.accessCodeLifespanLogin;
    }

    public String getPublicKeyPem() {
        return this.publicKeyPem;
    }

    public String getPrivateKeyPem() {
        return this.privateKeyPem;
    }

    public String getCodeSecret() {
        return this.codeSecret;
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        return this.requiredCredentials;
    }

    public PasswordPolicy getPasswordPolicy() {
        return this.passwordPolicy;
    }

    public boolean isIdentityFederationEnabled() {
        return this.identityFederationEnabled;
    }

    public Map<String, String> getSmtpConfig() {
        return this.smtpConfig;
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        return this.browserSecurityHeaders;
    }

    public String getLoginTheme() {
        return this.loginTheme;
    }

    public String getAccountTheme() {
        return this.accountTheme;
    }

    public String getAdminTheme() {
        return this.adminTheme;
    }

    public String getEmailTheme() {
        return this.emailTheme;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public boolean isEventsEnabled() {
        return this.eventsEnabled;
    }

    public long getEventsExpiration() {
        return this.eventsExpiration;
    }

    public Set<String> getEventsListeners() {
        return this.eventsListeners;
    }

    public Set<String> getEnabledEventTypes() {
        return this.enabledEventTypes;
    }

    public boolean isAdminEventsEnabled() {
        return this.adminEventsEnabled;
    }

    public Set<String> getAdminEnabledEventOperations() {
        return this.adminEnabledEventOperations;
    }

    public boolean isAdminEventsDetailsEnabled() {
        return this.adminEventsDetailsEnabled;
    }

    public List<UserFederationProviderModel> getUserFederationProviders() {
        return this.userFederationProviders;
    }

    public MultivaluedHashMap<String, UserFederationMapperModel> getUserFederationMappers() {
        return this.userFederationMappers;
    }

    public String getCertificatePem() {
        return this.certificatePem;
    }

    public List<IdentityProviderModel> getIdentityProviders() {
        return this.identityProviders;
    }

    public boolean isInternationalizationEnabled() {
        return this.internationalizationEnabled;
    }

    public Set<String> getSupportedLocales() {
        return this.supportedLocales;
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public MultivaluedHashMap<String, IdentityProviderMapperModel> getIdentityProviderMappers() {
        return this.identityProviderMappers;
    }

    public Map<String, AuthenticationFlowModel> getAuthenticationFlows() {
        return this.authenticationFlows;
    }

    public Map<String, AuthenticatorConfigModel> getAuthenticatorConfigs() {
        return this.authenticatorConfigs;
    }

    public MultivaluedHashMap<String, AuthenticationExecutionModel> getAuthenticationExecutions() {
        return this.authenticationExecutions;
    }

    public Map<String, AuthenticationExecutionModel> getExecutionsById() {
        return this.executionsById;
    }

    public Map<String, RequiredActionProviderModel> getRequiredActionProviders() {
        return this.requiredActionProviders;
    }

    public Map<String, RequiredActionProviderModel> getRequiredActionProvidersByAlias() {
        return this.requiredActionProvidersByAlias;
    }

    public OTPPolicy getOtpPolicy() {
        return this.otpPolicy;
    }

    public AuthenticationFlowModel getBrowserFlow() {
        return this.browserFlow;
    }

    public AuthenticationFlowModel getRegistrationFlow() {
        return this.registrationFlow;
    }

    public AuthenticationFlowModel getDirectGrantFlow() {
        return this.directGrantFlow;
    }

    public AuthenticationFlowModel getResetCredentialsFlow() {
        return this.resetCredentialsFlow;
    }

    public AuthenticationFlowModel getClientAuthenticationFlow() {
        return this.clientAuthenticationFlow;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public List<String> getDefaultGroups() {
        return this.defaultGroups;
    }

    public List<String> getClientTemplates() {
        return this.clientTemplates;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public Set<UserFederationMapperModel> getUserFederationMapperSet() {
        return this.userFederationMapperSet;
    }

    public List<AuthenticationFlowModel> getAuthenticationFlowList() {
        return this.authenticationFlowList;
    }

    public List<RequiredActionProviderModel> getRequiredActionProviderList() {
        return this.requiredActionProviderList;
    }
}

