/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.logging.Logger;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.UriUtils;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.DefaultAuthenticationFlows;
import org.keycloak.models.utils.DefaultRequiredActions;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionExportRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ClaimRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientTemplateRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.OAuthClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.ScopeMappingRepresentation;
import org.keycloak.representations.idm.SocialLinkRepresentation;
import org.keycloak.representations.idm.UserConsentRepresentation;
import org.keycloak.representations.idm.UserFederationMapperRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class RepresentationToModel {
    private static Logger logger = Logger.getLogger(RepresentationToModel.class);

    public static OTPPolicy toPolicy(RealmRepresentation rep) {
        OTPPolicy policy = new OTPPolicy();
        if (rep.getOtpPolicyType() != null) {
            policy.setType(rep.getOtpPolicyType());
        }
        if (rep.getOtpPolicyLookAheadWindow() != null) {
            policy.setLookAheadWindow(rep.getOtpPolicyLookAheadWindow());
        }
        if (rep.getOtpPolicyInitialCounter() != null) {
            policy.setInitialCounter(rep.getOtpPolicyInitialCounter());
        }
        if (rep.getOtpPolicyAlgorithm() != null) {
            policy.setAlgorithm(rep.getOtpPolicyAlgorithm());
        }
        if (rep.getOtpPolicyDigits() != null) {
            policy.setDigits(rep.getOtpPolicyDigits());
        }
        if (rep.getOtpPolicyPeriod() != null) {
            policy.setPeriod(rep.getOtpPolicyPeriod());
        }
        return policy;
    }

    public static void importRealm(KeycloakSession session, RealmRepresentation rep, RealmModel newRealm) {
        RepresentationToModel.convertDeprecatedSocialProviders(rep);
        RepresentationToModel.convertDeprecatedApplications(session, rep);
        newRealm.setName(rep.getRealm());
        if (rep.getDisplayName() != null) {
            newRealm.setDisplayName(rep.getDisplayName());
        }
        if (rep.getDisplayNameHtml() != null) {
            newRealm.setDisplayNameHtml(rep.getDisplayNameHtml());
        }
        if (rep.isEnabled() != null) {
            newRealm.setEnabled(rep.isEnabled());
        }
        if (rep.isBruteForceProtected() != null) {
            newRealm.setBruteForceProtected(rep.isBruteForceProtected());
        }
        if (rep.getMaxFailureWaitSeconds() != null) {
            newRealm.setMaxFailureWaitSeconds(rep.getMaxFailureWaitSeconds());
        }
        if (rep.getMinimumQuickLoginWaitSeconds() != null) {
            newRealm.setMinimumQuickLoginWaitSeconds(rep.getMinimumQuickLoginWaitSeconds());
        }
        if (rep.getWaitIncrementSeconds() != null) {
            newRealm.setWaitIncrementSeconds(rep.getWaitIncrementSeconds());
        }
        if (rep.getQuickLoginCheckMilliSeconds() != null) {
            newRealm.setQuickLoginCheckMilliSeconds(rep.getQuickLoginCheckMilliSeconds());
        }
        if (rep.getMaxDeltaTimeSeconds() != null) {
            newRealm.setMaxDeltaTimeSeconds(rep.getMaxDeltaTimeSeconds());
        }
        if (rep.getFailureFactor() != null) {
            newRealm.setFailureFactor(rep.getFailureFactor());
        }
        if (rep.isEventsEnabled() != null) {
            newRealm.setEventsEnabled(rep.isEventsEnabled());
        }
        if (rep.getEventsExpiration() != null) {
            newRealm.setEventsExpiration(rep.getEventsExpiration());
        }
        if (rep.getEventsListeners() != null) {
            newRealm.setEventsListeners(new HashSet<String>(rep.getEventsListeners()));
        }
        if (rep.isAdminEventsEnabled() != null) {
            newRealm.setAdminEventsEnabled(rep.isAdminEventsEnabled());
        }
        if (rep.isAdminEventsDetailsEnabled() != null) {
            newRealm.setAdminEventsDetailsEnabled(rep.isAdminEventsDetailsEnabled());
        }
        if (rep.getNotBefore() != null) {
            newRealm.setNotBefore(rep.getNotBefore());
        }
        if (rep.getRevokeRefreshToken() != null) {
            newRealm.setRevokeRefreshToken(rep.getRevokeRefreshToken());
        } else {
            newRealm.setRevokeRefreshToken(false);
        }
        if (rep.getAccessTokenLifespan() != null) {
            newRealm.setAccessTokenLifespan(rep.getAccessTokenLifespan());
        } else {
            newRealm.setAccessTokenLifespan(300);
        }
        if (rep.getAccessTokenLifespanForImplicitFlow() != null) {
            newRealm.setAccessTokenLifespanForImplicitFlow(rep.getAccessTokenLifespanForImplicitFlow());
        } else {
            newRealm.setAccessTokenLifespanForImplicitFlow(900);
        }
        if (rep.getSsoSessionIdleTimeout() != null) {
            newRealm.setSsoSessionIdleTimeout(rep.getSsoSessionIdleTimeout());
        } else {
            newRealm.setSsoSessionIdleTimeout(1800);
        }
        if (rep.getSsoSessionMaxLifespan() != null) {
            newRealm.setSsoSessionMaxLifespan(rep.getSsoSessionMaxLifespan());
        } else {
            newRealm.setSsoSessionMaxLifespan(36000);
        }
        if (rep.getOfflineSessionIdleTimeout() != null) {
            newRealm.setOfflineSessionIdleTimeout(rep.getOfflineSessionIdleTimeout());
        } else {
            newRealm.setOfflineSessionIdleTimeout(2592000);
        }
        if (rep.getAccessCodeLifespan() != null) {
            newRealm.setAccessCodeLifespan(rep.getAccessCodeLifespan());
        } else {
            newRealm.setAccessCodeLifespan(60);
        }
        if (rep.getAccessCodeLifespanUserAction() != null) {
            newRealm.setAccessCodeLifespanUserAction(rep.getAccessCodeLifespanUserAction());
        } else {
            newRealm.setAccessCodeLifespanUserAction(300);
        }
        if (rep.getAccessCodeLifespanLogin() != null) {
            newRealm.setAccessCodeLifespanLogin(rep.getAccessCodeLifespanLogin());
        } else {
            newRealm.setAccessCodeLifespanLogin(1800);
        }
        if (rep.getSslRequired() != null) {
            newRealm.setSslRequired(SslRequired.valueOf((String)rep.getSslRequired().toUpperCase()));
        }
        if (rep.isRegistrationAllowed() != null) {
            newRealm.setRegistrationAllowed(rep.isRegistrationAllowed());
        }
        if (rep.isRegistrationEmailAsUsername() != null) {
            newRealm.setRegistrationEmailAsUsername(rep.isRegistrationEmailAsUsername());
        }
        if (rep.isRememberMe() != null) {
            newRealm.setRememberMe(rep.isRememberMe());
        }
        if (rep.isVerifyEmail() != null) {
            newRealm.setVerifyEmail(rep.isVerifyEmail());
        }
        if (rep.isResetPasswordAllowed() != null) {
            newRealm.setResetPasswordAllowed(rep.isResetPasswordAllowed());
        }
        if (rep.isEditUsernameAllowed() != null) {
            newRealm.setEditUsernameAllowed(rep.isEditUsernameAllowed());
        }
        if (rep.getPrivateKey() == null || rep.getPublicKey() == null) {
            KeycloakModelUtils.generateRealmKeys(newRealm);
        } else {
            newRealm.setPrivateKeyPem(rep.getPrivateKey());
            newRealm.setPublicKeyPem(rep.getPublicKey());
        }
        if (rep.getCertificate() == null) {
            KeycloakModelUtils.generateRealmCertificate(newRealm);
        } else {
            newRealm.setCertificatePem(rep.getCertificate());
        }
        if (rep.getCodeSecret() == null) {
            newRealm.setCodeSecret(KeycloakModelUtils.generateCodeSecret());
        } else {
            newRealm.setCodeSecret(rep.getCodeSecret());
        }
        if (rep.getLoginTheme() != null) {
            newRealm.setLoginTheme(rep.getLoginTheme());
        }
        if (rep.getAccountTheme() != null) {
            newRealm.setAccountTheme(rep.getAccountTheme());
        }
        if (rep.getAdminTheme() != null) {
            newRealm.setAdminTheme(rep.getAdminTheme());
        }
        if (rep.getEmailTheme() != null) {
            newRealm.setEmailTheme(rep.getEmailTheme());
        }
        if (rep.getRequiredCredentials() != null) {
            for (String string : rep.getRequiredCredentials()) {
                newRealm.addRequiredCredential(string);
            }
        } else {
            newRealm.addRequiredCredential("password");
        }
        if (rep.getPasswordPolicy() != null) {
            newRealm.setPasswordPolicy(new PasswordPolicy(rep.getPasswordPolicy()));
        }
        if (rep.getOtpPolicyType() != null) {
            newRealm.setOTPPolicy(RepresentationToModel.toPolicy(rep));
        } else {
            newRealm.setOTPPolicy(OTPPolicy.DEFAULT_POLICY);
        }
        RepresentationToModel.importAuthenticationFlows(newRealm, rep);
        if (rep.getRequiredActions() != null) {
            for (RequiredActionProviderRepresentation requiredActionProviderRepresentation : rep.getRequiredActions()) {
                RequiredActionProviderModel model = RepresentationToModel.toModel(requiredActionProviderRepresentation);
                newRealm.addRequiredActionProvider(model);
            }
        } else {
            DefaultRequiredActions.addActions(newRealm);
        }
        RepresentationToModel.importIdentityProviders(rep, newRealm);
        RepresentationToModel.importIdentityProviderMappers(rep, newRealm);
        if (rep.getClientTemplates() != null) {
            RepresentationToModel.createClientTemplates(session, rep, newRealm);
        }
        if (rep.getClients() != null) {
            RepresentationToModel.createClients(session, rep, newRealm);
        }
        RepresentationToModel.importRoles(rep.getRoles(), newRealm);
        if (rep.getDefaultRoles() != null) {
            for (String string : rep.getDefaultRoles()) {
                newRealm.addDefaultRole(string.trim());
            }
        }
        if (rep.getClients() != null) {
            for (ClientRepresentation clientRepresentation : rep.getClients()) {
                if (clientRepresentation.getDefaultRoles() == null) continue;
                ClientModel clientModel = newRealm.getClientByClientId(clientRepresentation.getClientId());
                clientModel.updateDefaultRoles(clientRepresentation.getDefaultRoles());
            }
        }
        if (rep.getClientScopeMappings() != null) {
            for (Map.Entry entry : rep.getClientScopeMappings().entrySet()) {
                ClientModel app = newRealm.getClientByClientId((String)entry.getKey());
                if (app == null) {
                    throw new RuntimeException("Unable to find client role mappings for client: " + (String)entry.getKey());
                }
                RepresentationToModel.createClientScopeMappings(newRealm, app, (List)entry.getValue());
            }
        }
        if (rep.getScopeMappings() != null) {
            for (ScopeMappingRepresentation scopeMappingRepresentation : rep.getScopeMappings()) {
                ClientModel client = newRealm.getClientByClientId(scopeMappingRepresentation.getClient());
                if (client == null) {
                    throw new RuntimeException("Unknown client specification in realm scope mappings");
                }
                for (String roleString : scopeMappingRepresentation.getRoles()) {
                    RoleModel role = newRealm.getRole(roleString.trim());
                    if (role == null) {
                        role = newRealm.addRole(roleString.trim());
                    }
                    client.addScopeMapping(role);
                }
            }
        }
        if (rep.getSmtpServer() != null) {
            newRealm.setSmtpConfig(new HashMap<String, String>(rep.getSmtpServer()));
        }
        if (rep.getBrowserSecurityHeaders() != null) {
            newRealm.setBrowserSecurityHeaders(rep.getBrowserSecurityHeaders());
        } else {
            newRealm.setBrowserSecurityHeaders(BrowserSecurityHeaders.defaultHeaders);
        }
        List<UserFederationProviderModel> providerModels = null;
        if (rep.getUserFederationProviders() != null) {
            providerModels = RepresentationToModel.convertFederationProviders(rep.getUserFederationProviders());
            newRealm.setUserFederationProviders(providerModels);
        }
        if (rep.getUserFederationMappers() != null) {
            if (rep.getUserFederationProviders() != null) {
                TreeSet<String> treeSet = new TreeSet<String>();
                for (UserFederationMapperRepresentation representation : rep.getUserFederationMappers()) {
                    treeSet.add(representation.getFederationProviderDisplayName());
                }
                for (String providerName : treeSet) {
                    for (UserFederationProviderModel providerModel : providerModels) {
                        if (!providerName.equals(providerModel.getDisplayName())) continue;
                        Set<UserFederationMapperModel> toDelete = newRealm.getUserFederationMappersByFederationProvider(providerModel.getId());
                        for (UserFederationMapperModel mapperModel : toDelete) {
                            newRealm.removeUserFederationMapper(mapperModel);
                        }
                    }
                }
            }
            for (UserFederationMapperRepresentation representation : rep.getUserFederationMappers()) {
                newRealm.addUserFederationMapper(RepresentationToModel.toModel(newRealm, representation));
            }
        }
        if (rep.getGroups() != null) {
            RepresentationToModel.importGroups(newRealm, rep);
            if (rep.getDefaultGroups() != null) {
                for (String path : rep.getDefaultGroups()) {
                    GroupModel found = KeycloakModelUtils.findGroupByPath(newRealm, path);
                    if (found == null) {
                        throw new RuntimeException("default group in realm rep doesn't exist: " + path);
                    }
                    newRealm.addDefaultGroup(found);
                }
            }
        }
        if (rep.getUsers() != null) {
            for (UserRepresentation userRep : rep.getUsers()) {
                UserModel userModel = RepresentationToModel.createUser(session, newRealm, userRep);
            }
        }
        if (rep.isInternationalizationEnabled() != null) {
            newRealm.setInternationalizationEnabled(rep.isInternationalizationEnabled());
        }
        if (rep.getSupportedLocales() != null) {
            newRealm.setSupportedLocales(new HashSet<String>(rep.getSupportedLocales()));
        }
        if (rep.getDefaultLocale() != null) {
            newRealm.setDefaultLocale(rep.getDefaultLocale());
        }
    }

    public static void importRoles(RolesRepresentation realmRoles, RealmModel realm) {
        RoleModel role;
        ClientModel client;
        if (realmRoles == null) {
            return;
        }
        if (realmRoles.getRealm() != null) {
            for (RoleRepresentation roleRepresentation : realmRoles.getRealm()) {
                RepresentationToModel.createRole(realm, roleRepresentation);
            }
        }
        if (realmRoles.getClient() != null) {
            for (Map.Entry entry : realmRoles.getClient().entrySet()) {
                client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("App doesn't exist in role definitions: " + (String)entry.getKey());
                }
                for (RoleRepresentation roleRep : (List)entry.getValue()) {
                    role = roleRep.getId() != null ? client.addRole(roleRep.getId(), roleRep.getName()) : client.addRole(roleRep.getName());
                    role.setDescription(roleRep.getDescription());
                    boolean scopeParamRequired = roleRep.isScopeParamRequired() == null ? false : roleRep.isScopeParamRequired();
                    role.setScopeParamRequired(scopeParamRequired);
                }
            }
        }
        if (realmRoles.getRealm() != null) {
            for (RoleRepresentation roleRepresentation : realmRoles.getRealm()) {
                RoleModel role2 = realm.getRole(roleRepresentation.getName());
                RepresentationToModel.addComposites(role2, roleRepresentation, realm);
            }
        }
        if (realmRoles.getClient() != null) {
            for (Map.Entry entry : realmRoles.getClient().entrySet()) {
                client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("App doesn't exist in role definitions: " + (String)entry.getKey());
                }
                for (RoleRepresentation roleRep : (List)entry.getValue()) {
                    role = client.getRole(roleRep.getName());
                    RepresentationToModel.addComposites(role, roleRep, realm);
                }
            }
        }
    }

    public static void importGroups(RealmModel realm, RealmRepresentation rep) {
        List groups = rep.getGroups();
        if (groups == null) {
            return;
        }
        GroupModel parent = null;
        for (GroupRepresentation group : groups) {
            RepresentationToModel.importGroup(realm, parent, group);
        }
    }

    public static void importGroup(RealmModel realm, GroupModel parent, GroupRepresentation group) {
        GroupModel newGroup = realm.createGroup(group.getId(), group.getName());
        if (group.getAttributes() != null) {
            for (Map.Entry attr : group.getAttributes().entrySet()) {
                newGroup.setAttribute((String)attr.getKey(), (List)attr.getValue());
            }
        }
        realm.moveGroup(newGroup, parent);
        if (group.getRealmRoles() != null) {
            for (String roleString : group.getRealmRoles()) {
                RoleModel role = realm.getRole(roleString.trim());
                if (role == null) {
                    role = realm.addRole(roleString.trim());
                }
                newGroup.grantRole(role);
            }
        }
        if (group.getClientRoles() != null) {
            for (Map.Entry entry : group.getClientRoles().entrySet()) {
                ClientModel client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("Unable to find client role mappings for client: " + (String)entry.getKey());
                }
                List roleNames = (List)entry.getValue();
                for (String roleName : roleNames) {
                    RoleModel role = client.getRole(roleName.trim());
                    if (role == null) {
                        role = client.addRole(roleName.trim());
                    }
                    newGroup.grantRole(role);
                }
            }
        }
        if (group.getSubGroups() != null) {
            for (GroupRepresentation subGroup : group.getSubGroups()) {
                RepresentationToModel.importGroup(realm, newGroup, subGroup);
            }
        }
    }

    public static void importAuthenticationFlows(RealmModel newRealm, RealmRepresentation rep) {
        if (rep.getAuthenticationFlows() == null) {
            DefaultAuthenticationFlows.migrateFlows(newRealm);
        } else {
            Serializable model;
            for (AuthenticatorConfigRepresentation configRep : rep.getAuthenticatorConfig()) {
                model = RepresentationToModel.toModel(configRep);
                newRealm.addAuthenticatorConfig((AuthenticatorConfigModel)model);
            }
            for (AuthenticationFlowRepresentation flowRep : rep.getAuthenticationFlows()) {
                model = RepresentationToModel.toModel(flowRep);
                ((AuthenticationFlowModel)model).setId(null);
                model = newRealm.addAuthenticationFlow((AuthenticationFlowModel)model);
            }
            for (AuthenticationFlowRepresentation flowRep : rep.getAuthenticationFlows()) {
                model = newRealm.getFlowByAlias(flowRep.getAlias());
                for (AuthenticationExecutionExportRepresentation exeRep : flowRep.getAuthenticationExecutions()) {
                    AuthenticationExecutionModel execution = RepresentationToModel.toModel(newRealm, exeRep);
                    execution.setParentFlow(((AuthenticationFlowModel)model).getId());
                    newRealm.addAuthenticatorExecution(execution);
                }
            }
        }
        if (rep.getBrowserFlow() == null) {
            newRealm.setBrowserFlow(newRealm.getFlowByAlias("browser"));
        } else {
            newRealm.setBrowserFlow(newRealm.getFlowByAlias(rep.getBrowserFlow()));
        }
        if (rep.getRegistrationFlow() == null) {
            newRealm.setRegistrationFlow(newRealm.getFlowByAlias("registration"));
        } else {
            newRealm.setRegistrationFlow(newRealm.getFlowByAlias(rep.getRegistrationFlow()));
        }
        if (rep.getDirectGrantFlow() == null) {
            newRealm.setDirectGrantFlow(newRealm.getFlowByAlias("direct grant"));
        } else {
            newRealm.setDirectGrantFlow(newRealm.getFlowByAlias(rep.getDirectGrantFlow()));
        }
        if (rep.getResetCredentialsFlow() == null) {
            AuthenticationFlowModel resetFlow = newRealm.getFlowByAlias("reset credentials");
            if (resetFlow == null) {
                DefaultAuthenticationFlows.resetCredentialsFlow(newRealm);
            } else {
                newRealm.setResetCredentialsFlow(resetFlow);
            }
        } else {
            newRealm.setResetCredentialsFlow(newRealm.getFlowByAlias(rep.getResetCredentialsFlow()));
        }
        if (rep.getClientAuthenticationFlow() == null) {
            AuthenticationFlowModel clientFlow = newRealm.getFlowByAlias("clients");
            if (clientFlow == null) {
                DefaultAuthenticationFlows.clientAuthFlow(newRealm);
            } else {
                newRealm.setClientAuthenticationFlow(clientFlow);
            }
        } else {
            newRealm.setClientAuthenticationFlow(newRealm.getFlowByAlias(rep.getClientAuthenticationFlow()));
        }
        if (newRealm.getFlowByAlias("first broker login") == null) {
            DefaultAuthenticationFlows.firstBrokerLoginFlow(newRealm, true);
        }
    }

    private static void convertDeprecatedSocialProviders(RealmRepresentation rep) {
        if (rep.isSocial() != null && rep.isSocial().booleanValue() && rep.getSocialProviders() != null && !rep.getSocialProviders().isEmpty() && rep.getIdentityProviders() == null) {
            Boolean updateProfileFirstLogin = rep.isUpdateProfileOnInitialSocialLogin() != null && rep.isUpdateProfileOnInitialSocialLogin() != false;
            if (rep.getSocialProviders() != null) {
                logger.warn((Object)"Using deprecated 'social' configuration in JSON representation. It will be removed in future versions");
                LinkedList<IdentityProviderRepresentation> identityProviders = new LinkedList<IdentityProviderRepresentation>();
                for (String k : rep.getSocialProviders().keySet()) {
                    if (!k.endsWith(".key")) continue;
                    String providerId = k.split("\\.")[0];
                    String key = (String)rep.getSocialProviders().get(k);
                    String secret = (String)rep.getSocialProviders().get(k.replace(".key", ".secret"));
                    IdentityProviderRepresentation identityProvider = new IdentityProviderRepresentation();
                    identityProvider.setAlias(providerId);
                    identityProvider.setProviderId(providerId);
                    identityProvider.setEnabled(true);
                    identityProvider.setUpdateProfileFirstLogin(updateProfileFirstLogin.booleanValue());
                    HashMap<String, String> config = new HashMap<String, String>();
                    config.put("clientId", key);
                    config.put("clientSecret", secret);
                    identityProvider.setConfig(config);
                    identityProviders.add(identityProvider);
                }
                rep.setIdentityProviders(identityProviders);
            }
        }
    }

    private static void convertDeprecatedSocialProviders(UserRepresentation user) {
        if (user.getSocialLinks() != null && !user.getSocialLinks().isEmpty() && user.getFederatedIdentities() == null) {
            logger.warnf("Using deprecated 'socialLinks' configuration in JSON representation for user '%s'. It will be removed in future versions", (Object)user.getUsername());
            LinkedList<FederatedIdentityRepresentation> federatedIdentities = new LinkedList<FederatedIdentityRepresentation>();
            for (SocialLinkRepresentation social : user.getSocialLinks()) {
                FederatedIdentityRepresentation federatedIdentity = new FederatedIdentityRepresentation();
                federatedIdentity.setIdentityProvider(social.getSocialProvider());
                federatedIdentity.setUserId(social.getSocialUserId());
                federatedIdentity.setUserName(social.getSocialUsername());
                federatedIdentities.add(federatedIdentity);
            }
            user.setFederatedIdentities(federatedIdentities);
        }
        user.setSocialLinks(null);
    }

    private static void convertDeprecatedApplications(KeycloakSession session, RealmRepresentation realm) {
        if (realm.getApplications() != null || realm.getOauthClients() != null) {
            if (realm.getClients() == null) {
                realm.setClients(new LinkedList());
            }
            LinkedList clients = new LinkedList();
            if (realm.getApplications() != null) {
                clients.addAll(realm.getApplications());
            }
            if (realm.getOauthClients() != null) {
                clients.addAll(realm.getOauthClients());
            }
            for (ApplicationRepresentation app : clients) {
                app.setClientId(app.getName());
                app.setName(null);
                if (app instanceof OAuthClientRepresentation) {
                    app.setConsentRequired(Boolean.valueOf(true));
                    app.setFullScopeAllowed(Boolean.valueOf(false));
                }
                if (app.getProtocolMappers() == null && app.getClaims() != null) {
                    long mask = RepresentationToModel.getClaimsMask(app.getClaims());
                    List<ProtocolMapperRepresentation> convertedProtocolMappers = session.getProvider(MigrationProvider.class).getMappersForClaimMask(mask);
                    app.setProtocolMappers(convertedProtocolMappers);
                    app.setClaims(null);
                }
                realm.getClients().add(app);
            }
        }
        if (realm.getApplicationScopeMappings() != null && realm.getClientScopeMappings() == null) {
            realm.setClientScopeMappings(realm.getApplicationScopeMappings());
        }
        if (realm.getRoles() != null && realm.getRoles().getApplication() != null && realm.getRoles().getClient() == null) {
            realm.getRoles().setClient(realm.getRoles().getApplication());
        }
        if (realm.getUsers() != null) {
            for (UserRepresentation userRepresentation : realm.getUsers()) {
                if (userRepresentation.getApplicationRoles() == null || userRepresentation.getClientRoles() != null) continue;
                userRepresentation.setClientRoles(userRepresentation.getApplicationRoles());
            }
        }
        if (realm.getRoles() != null && realm.getRoles().getRealm() != null) {
            for (RoleRepresentation roleRepresentation : realm.getRoles().getRealm()) {
                if (roleRepresentation.getComposites() == null || roleRepresentation.getComposites().getApplication() == null || roleRepresentation.getComposites().getClient() != null) continue;
                roleRepresentation.getComposites().setClient(roleRepresentation.getComposites().getApplication());
            }
        }
        if (realm.getRoles() != null && realm.getRoles().getClient() != null) {
            for (Map.Entry entry : realm.getRoles().getClient().entrySet()) {
                for (RoleRepresentation role : (List)entry.getValue()) {
                    if (role.getComposites() == null || role.getComposites().getApplication() == null || role.getComposites().getClient() != null) continue;
                    role.getComposites().setClient(role.getComposites().getApplication());
                }
            }
        }
    }

    public static void renameRealm(RealmModel realm, String name) {
        if (name.equals(realm.getName())) {
            return;
        }
        ClientModel masterApp = realm.getMasterAdminClient();
        masterApp.setClientId(KeycloakModelUtils.getMasterRealmAdminApplicationClientId(name));
        realm.setName(name);
    }

    public static void updateRealm(RealmRepresentation rep, RealmModel realm) {
        if (rep.getRealm() != null) {
            RepresentationToModel.renameRealm(realm, rep.getRealm());
        }
        if (rep.getDisplayName() != null) {
            realm.setDisplayName(rep.getDisplayName());
        }
        if (rep.getDisplayNameHtml() != null) {
            realm.setDisplayNameHtml(rep.getDisplayNameHtml());
        }
        if (rep.isEnabled() != null) {
            realm.setEnabled(rep.isEnabled());
        }
        if (rep.isBruteForceProtected() != null) {
            realm.setBruteForceProtected(rep.isBruteForceProtected());
        }
        if (rep.getMaxFailureWaitSeconds() != null) {
            realm.setMaxFailureWaitSeconds(rep.getMaxFailureWaitSeconds());
        }
        if (rep.getMinimumQuickLoginWaitSeconds() != null) {
            realm.setMinimumQuickLoginWaitSeconds(rep.getMinimumQuickLoginWaitSeconds());
        }
        if (rep.getWaitIncrementSeconds() != null) {
            realm.setWaitIncrementSeconds(rep.getWaitIncrementSeconds());
        }
        if (rep.getQuickLoginCheckMilliSeconds() != null) {
            realm.setQuickLoginCheckMilliSeconds(rep.getQuickLoginCheckMilliSeconds());
        }
        if (rep.getMaxDeltaTimeSeconds() != null) {
            realm.setMaxDeltaTimeSeconds(rep.getMaxDeltaTimeSeconds());
        }
        if (rep.getFailureFactor() != null) {
            realm.setFailureFactor(rep.getFailureFactor());
        }
        if (rep.isRegistrationAllowed() != null) {
            realm.setRegistrationAllowed(rep.isRegistrationAllowed());
        }
        if (rep.isRegistrationEmailAsUsername() != null) {
            realm.setRegistrationEmailAsUsername(rep.isRegistrationEmailAsUsername());
        }
        if (rep.isRememberMe() != null) {
            realm.setRememberMe(rep.isRememberMe());
        }
        if (rep.isVerifyEmail() != null) {
            realm.setVerifyEmail(rep.isVerifyEmail());
        }
        if (rep.isResetPasswordAllowed() != null) {
            realm.setResetPasswordAllowed(rep.isResetPasswordAllowed());
        }
        if (rep.isEditUsernameAllowed() != null) {
            realm.setEditUsernameAllowed(rep.isEditUsernameAllowed());
        }
        if (rep.getSslRequired() != null) {
            realm.setSslRequired(SslRequired.valueOf((String)rep.getSslRequired().toUpperCase()));
        }
        if (rep.getAccessCodeLifespan() != null) {
            realm.setAccessCodeLifespan(rep.getAccessCodeLifespan());
        }
        if (rep.getAccessCodeLifespanUserAction() != null) {
            realm.setAccessCodeLifespanUserAction(rep.getAccessCodeLifespanUserAction());
        }
        if (rep.getAccessCodeLifespanLogin() != null) {
            realm.setAccessCodeLifespanLogin(rep.getAccessCodeLifespanLogin());
        }
        if (rep.getNotBefore() != null) {
            realm.setNotBefore(rep.getNotBefore());
        }
        if (rep.getRevokeRefreshToken() != null) {
            realm.setRevokeRefreshToken(rep.getRevokeRefreshToken());
        }
        if (rep.getAccessTokenLifespan() != null) {
            realm.setAccessTokenLifespan(rep.getAccessTokenLifespan());
        }
        if (rep.getAccessTokenLifespanForImplicitFlow() != null) {
            realm.setAccessTokenLifespanForImplicitFlow(rep.getAccessTokenLifespanForImplicitFlow());
        }
        if (rep.getSsoSessionIdleTimeout() != null) {
            realm.setSsoSessionIdleTimeout(rep.getSsoSessionIdleTimeout());
        }
        if (rep.getSsoSessionMaxLifespan() != null) {
            realm.setSsoSessionMaxLifespan(rep.getSsoSessionMaxLifespan());
        }
        if (rep.getOfflineSessionIdleTimeout() != null) {
            realm.setOfflineSessionIdleTimeout(rep.getOfflineSessionIdleTimeout());
        }
        if (rep.getRequiredCredentials() != null) {
            realm.updateRequiredCredentials(rep.getRequiredCredentials());
        }
        if (rep.getLoginTheme() != null) {
            realm.setLoginTheme(rep.getLoginTheme());
        }
        if (rep.getAccountTheme() != null) {
            realm.setAccountTheme(rep.getAccountTheme());
        }
        if (rep.getAdminTheme() != null) {
            realm.setAdminTheme(rep.getAdminTheme());
        }
        if (rep.getEmailTheme() != null) {
            realm.setEmailTheme(rep.getEmailTheme());
        }
        if (rep.isEventsEnabled() != null) {
            realm.setEventsEnabled(rep.isEventsEnabled());
        }
        if (rep.getEventsExpiration() != null) {
            realm.setEventsExpiration(rep.getEventsExpiration());
        }
        if (rep.getEventsListeners() != null) {
            realm.setEventsListeners(new HashSet<String>(rep.getEventsListeners()));
        }
        if (rep.getEnabledEventTypes() != null) {
            realm.setEnabledEventTypes(new HashSet<String>(rep.getEnabledEventTypes()));
        }
        if (rep.isAdminEventsEnabled() != null) {
            realm.setAdminEventsEnabled(rep.isAdminEventsEnabled());
        }
        if (rep.isAdminEventsDetailsEnabled() != null) {
            realm.setAdminEventsDetailsEnabled(rep.isAdminEventsDetailsEnabled());
        }
        if (rep.getPasswordPolicy() != null) {
            realm.setPasswordPolicy(new PasswordPolicy(rep.getPasswordPolicy()));
        }
        if (rep.getOtpPolicyType() != null) {
            realm.setOTPPolicy(RepresentationToModel.toPolicy(rep));
        }
        if (rep.getDefaultRoles() != null) {
            realm.updateDefaultRoles(rep.getDefaultRoles().toArray(new String[rep.getDefaultRoles().size()]));
        }
        if (rep.getSmtpServer() != null) {
            realm.setSmtpConfig(new HashMap<String, String>(rep.getSmtpServer()));
        }
        if (rep.getBrowserSecurityHeaders() != null) {
            realm.setBrowserSecurityHeaders(rep.getBrowserSecurityHeaders());
        }
        if (rep.getUserFederationProviders() != null) {
            List<UserFederationProviderModel> providerModels = RepresentationToModel.convertFederationProviders(rep.getUserFederationProviders());
            realm.setUserFederationProviders(providerModels);
        }
        if ("GENERATE".equals(rep.getPublicKey())) {
            KeycloakModelUtils.generateRealmKeys(realm);
        }
        if (rep.isInternationalizationEnabled() != null) {
            realm.setInternationalizationEnabled(rep.isInternationalizationEnabled());
        }
        if (rep.getSupportedLocales() != null) {
            realm.setSupportedLocales(new HashSet<String>(rep.getSupportedLocales()));
        }
        if (rep.getDefaultLocale() != null) {
            realm.setDefaultLocale(rep.getDefaultLocale());
        }
        if (rep.getBrowserFlow() != null) {
            realm.setBrowserFlow(realm.getFlowByAlias(rep.getBrowserFlow()));
        }
        if (rep.getRegistrationFlow() != null) {
            realm.setRegistrationFlow(realm.getFlowByAlias(rep.getRegistrationFlow()));
        }
        if (rep.getDirectGrantFlow() != null) {
            realm.setDirectGrantFlow(realm.getFlowByAlias(rep.getDirectGrantFlow()));
        }
        if (rep.getResetCredentialsFlow() != null) {
            realm.setResetCredentialsFlow(realm.getFlowByAlias(rep.getResetCredentialsFlow()));
        }
        if (rep.getClientAuthenticationFlow() != null) {
            realm.setClientAuthenticationFlow(realm.getFlowByAlias(rep.getClientAuthenticationFlow()));
        }
    }

    private static List<UserFederationProviderModel> convertFederationProviders(List<UserFederationProviderRepresentation> providers) {
        ArrayList<UserFederationProviderModel> result = new ArrayList<UserFederationProviderModel>();
        for (UserFederationProviderRepresentation representation : providers) {
            UserFederationProviderModel model = new UserFederationProviderModel(representation.getId(), representation.getProviderName(), representation.getConfig(), representation.getPriority(), representation.getDisplayName(), representation.getFullSyncPeriod(), representation.getChangedSyncPeriod(), representation.getLastSync());
            result.add(model);
        }
        return result;
    }

    public static UserFederationMapperModel toModel(RealmModel realm, UserFederationMapperRepresentation rep) {
        UserFederationMapperModel model = new UserFederationMapperModel();
        model.setId(rep.getId());
        model.setName(rep.getName());
        model.setFederationMapperType(rep.getFederationMapperType());
        model.setConfig(rep.getConfig());
        UserFederationProviderModel fedProvider = KeycloakModelUtils.findUserFederationProviderByDisplayName(rep.getFederationProviderDisplayName(), realm);
        if (fedProvider == null) {
            throw new ModelException("Couldn't find federation provider with display name [" + rep.getFederationProviderDisplayName() + "] referenced from mapper [" + rep.getName());
        }
        model.setFederationProviderId(fedProvider.getId());
        return model;
    }

    public static void createRole(RealmModel newRealm, RoleRepresentation roleRep) {
        RoleModel role;
        RoleModel roleModel = role = roleRep.getId() != null ? newRealm.addRole(roleRep.getId(), roleRep.getName()) : newRealm.addRole(roleRep.getName());
        if (roleRep.getDescription() != null) {
            role.setDescription(roleRep.getDescription());
        }
        boolean scopeParamRequired = roleRep.isScopeParamRequired() == null ? false : roleRep.isScopeParamRequired();
        role.setScopeParamRequired(scopeParamRequired);
    }

    private static void addComposites(RoleModel role, RoleRepresentation roleRep, RealmModel realm) {
        if (roleRep.getComposites() == null) {
            return;
        }
        if (roleRep.getComposites().getRealm() != null) {
            for (String string : roleRep.getComposites().getRealm()) {
                RoleModel realmRole = realm.getRole(string);
                if (realmRole == null) {
                    throw new RuntimeException("Unable to find composite realm role: " + string);
                }
                role.addCompositeRole(realmRole);
            }
        }
        if (roleRep.getComposites().getClient() != null) {
            for (Map.Entry entry : roleRep.getComposites().getClient().entrySet()) {
                ClientModel client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("App doesn't exist in role definitions: " + roleRep.getName());
                }
                for (String roleStr : (List)entry.getValue()) {
                    RoleModel clientRole = client.getRole(roleStr);
                    if (clientRole == null) {
                        throw new RuntimeException("Unable to find composite client role: " + roleStr);
                    }
                    role.addCompositeRole(clientRole);
                }
            }
        }
    }

    private static Map<String, ClientModel> createClients(KeycloakSession session, RealmRepresentation rep, RealmModel realm) {
        HashMap<String, ClientModel> appMap = new HashMap<String, ClientModel>();
        for (ClientRepresentation resourceRep : rep.getClients()) {
            ClientModel app = RepresentationToModel.createClient(session, realm, resourceRep, false);
            appMap.put(app.getClientId(), app);
        }
        return appMap;
    }

    public static ClientModel createClient(KeycloakSession session, RealmModel realm, ClientRepresentation resourceRep, boolean addDefaultRoles) {
        ClientModel client;
        logger.debug((Object)("Create client: {0}" + resourceRep.getClientId()));
        ClientModel clientModel = client = resourceRep.getId() != null ? realm.addClient(resourceRep.getId(), resourceRep.getClientId()) : realm.addClient(resourceRep.getClientId());
        if (resourceRep.getName() != null) {
            client.setName(resourceRep.getName());
        }
        if (resourceRep.getDescription() != null) {
            client.setDescription(resourceRep.getDescription());
        }
        if (resourceRep.isEnabled() != null) {
            client.setEnabled(resourceRep.isEnabled());
        }
        client.setManagementUrl(resourceRep.getAdminUrl());
        if (resourceRep.isSurrogateAuthRequired() != null) {
            client.setSurrogateAuthRequired(resourceRep.isSurrogateAuthRequired());
        }
        if (resourceRep.getRootUrl() != null) {
            client.setRootUrl(resourceRep.getRootUrl());
        }
        if (resourceRep.getBaseUrl() != null) {
            client.setBaseUrl(resourceRep.getBaseUrl());
        }
        if (resourceRep.isBearerOnly() != null) {
            client.setBearerOnly(resourceRep.isBearerOnly());
        }
        if (resourceRep.isConsentRequired() != null) {
            client.setConsentRequired(resourceRep.isConsentRequired());
        }
        if (resourceRep.isDirectGrantsOnly() != null) {
            logger.warn((Object)"Using deprecated 'directGrantsOnly' configuration in JSON representation. It will be removed in future versions");
            client.setStandardFlowEnabled(resourceRep.isDirectGrantsOnly() == false);
            client.setDirectAccessGrantsEnabled(resourceRep.isDirectGrantsOnly());
        }
        if (resourceRep.isStandardFlowEnabled() != null) {
            client.setStandardFlowEnabled(resourceRep.isStandardFlowEnabled());
        }
        if (resourceRep.isImplicitFlowEnabled() != null) {
            client.setImplicitFlowEnabled(resourceRep.isImplicitFlowEnabled());
        }
        if (resourceRep.isDirectAccessGrantsEnabled() != null) {
            client.setDirectAccessGrantsEnabled(resourceRep.isDirectAccessGrantsEnabled());
        }
        if (resourceRep.isServiceAccountsEnabled() != null) {
            client.setServiceAccountsEnabled(resourceRep.isServiceAccountsEnabled());
        }
        if (resourceRep.isPublicClient() != null) {
            client.setPublicClient(resourceRep.isPublicClient());
        }
        if (resourceRep.isFrontchannelLogout() != null) {
            client.setFrontchannelLogout(resourceRep.isFrontchannelLogout());
        }
        if (resourceRep.getProtocol() != null) {
            client.setProtocol(resourceRep.getProtocol());
        }
        if (resourceRep.getNodeReRegistrationTimeout() != null) {
            client.setNodeReRegistrationTimeout(resourceRep.getNodeReRegistrationTimeout());
        } else {
            client.setNodeReRegistrationTimeout(-1);
        }
        client.updateClient();
        if (resourceRep.getNotBefore() != null) {
            client.setNotBefore(resourceRep.getNotBefore());
        }
        if (resourceRep.getClientAuthenticatorType() != null) {
            client.setClientAuthenticatorType(resourceRep.getClientAuthenticatorType());
        } else {
            client.setClientAuthenticatorType(KeycloakModelUtils.getDefaultClientAuthenticatorType());
        }
        client.setSecret(resourceRep.getSecret());
        if (client.getSecret() == null) {
            KeycloakModelUtils.generateSecret(client);
        }
        if (resourceRep.getAttributes() != null) {
            for (Map.Entry entry : resourceRep.getAttributes().entrySet()) {
                client.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (resourceRep.getRedirectUris() != null) {
            for (String string : resourceRep.getRedirectUris()) {
                client.addRedirectUri(string);
            }
        }
        if (resourceRep.getWebOrigins() != null) {
            for (String string : resourceRep.getWebOrigins()) {
                logger.debugv("Client: {0} webOrigin: {1}", (Object)resourceRep.getClientId(), (Object)string);
                client.addWebOrigin(string);
            }
        } else if (resourceRep.getRedirectUris() != null) {
            HashSet origins = new HashSet();
            for (String redirectUri : resourceRep.getRedirectUris()) {
                logger.debugv("add redirect-uri to origin: {0}", (Object)redirectUri);
                if (!redirectUri.startsWith("http")) continue;
                String origin = UriUtils.getOrigin((String)redirectUri);
                logger.debugv("adding default client origin: {0}", (Object)origin);
                origins.add(origin);
            }
            if (origins.size() > 0) {
                client.setWebOrigins(origins);
            }
        }
        if (resourceRep.getRegisteredNodes() != null) {
            for (Map.Entry entry : resourceRep.getRegisteredNodes().entrySet()) {
                client.registerNode((String)entry.getKey(), (Integer)entry.getValue());
            }
        }
        if (addDefaultRoles && resourceRep.getDefaultRoles() != null) {
            client.updateDefaultRoles(resourceRep.getDefaultRoles());
        }
        if (resourceRep.getProtocolMappers() != null) {
            Set<ProtocolMapperModel> mappers = client.getProtocolMappers();
            for (ProtocolMapperModel mapper : mappers) {
                client.removeProtocolMapper(mapper);
            }
            for (ProtocolMapperModel mapper : resourceRep.getProtocolMappers()) {
                client.addProtocolMapper(RepresentationToModel.toModel((ProtocolMapperRepresentation)mapper));
            }
        }
        if (resourceRep.getClientTemplate() != null) {
            for (ClientTemplateModel clientTemplateModel : realm.getClientTemplates()) {
                if (!clientTemplateModel.getName().equals(resourceRep.getClientTemplate())) continue;
                client.setClientTemplate(clientTemplateModel);
                break;
            }
        }
        if (resourceRep.isFullScopeAllowed() != null) {
            client.setFullScopeAllowed(resourceRep.isFullScopeAllowed());
        } else if (client.getClientTemplate() != null) {
            client.setFullScopeAllowed(!client.isConsentRequired() && client.getClientTemplate().isFullScopeAllowed());
        } else {
            client.setFullScopeAllowed(!client.isConsentRequired());
        }
        if (resourceRep.isUseTemplateConfig() != null) {
            client.setUseTemplateConfig(resourceRep.isUseTemplateConfig());
        } else {
            client.setUseTemplateConfig(false);
        }
        if (resourceRep.isUseTemplateScope() != null) {
            client.setUseTemplateScope(resourceRep.isUseTemplateScope());
        } else {
            client.setUseTemplateScope(resourceRep.getClientTemplate() != null);
        }
        if (resourceRep.isUseTemplateMappers() != null) {
            client.setUseTemplateMappers(resourceRep.isUseTemplateMappers());
        } else {
            client.setUseTemplateMappers(resourceRep.getClientTemplate() != null);
        }
        return client;
    }

    public static void updateClient(ClientRepresentation rep, ClientModel resource) {
        List webOrigins;
        List redirectUris;
        if (rep.getClientId() != null) {
            resource.setClientId(rep.getClientId());
        }
        if (rep.getName() != null) {
            resource.setName(rep.getName());
        }
        if (rep.getDescription() != null) {
            resource.setDescription(rep.getDescription());
        }
        if (rep.isEnabled() != null) {
            resource.setEnabled(rep.isEnabled());
        }
        if (rep.isBearerOnly() != null) {
            resource.setBearerOnly(rep.isBearerOnly());
        }
        if (rep.isConsentRequired() != null) {
            resource.setConsentRequired(rep.isConsentRequired());
        }
        if (rep.isStandardFlowEnabled() != null) {
            resource.setStandardFlowEnabled(rep.isStandardFlowEnabled());
        }
        if (rep.isImplicitFlowEnabled() != null) {
            resource.setImplicitFlowEnabled(rep.isImplicitFlowEnabled());
        }
        if (rep.isDirectAccessGrantsEnabled() != null) {
            resource.setDirectAccessGrantsEnabled(rep.isDirectAccessGrantsEnabled());
        }
        if (rep.isServiceAccountsEnabled() != null) {
            resource.setServiceAccountsEnabled(rep.isServiceAccountsEnabled());
        }
        if (rep.isPublicClient() != null) {
            resource.setPublicClient(rep.isPublicClient());
        }
        if (rep.isFullScopeAllowed() != null) {
            resource.setFullScopeAllowed(rep.isFullScopeAllowed());
        }
        if (rep.isFrontchannelLogout() != null) {
            resource.setFrontchannelLogout(rep.isFrontchannelLogout());
        }
        if (rep.getRootUrl() != null) {
            resource.setRootUrl(rep.getRootUrl());
        }
        if (rep.getAdminUrl() != null) {
            resource.setManagementUrl(rep.getAdminUrl());
        }
        if (rep.getBaseUrl() != null) {
            resource.setBaseUrl(rep.getBaseUrl());
        }
        if (rep.isSurrogateAuthRequired() != null) {
            resource.setSurrogateAuthRequired(rep.isSurrogateAuthRequired());
        }
        if (rep.getNodeReRegistrationTimeout() != null) {
            resource.setNodeReRegistrationTimeout(rep.getNodeReRegistrationTimeout());
        }
        if (rep.getClientAuthenticatorType() != null) {
            resource.setClientAuthenticatorType(rep.getClientAuthenticatorType());
        }
        resource.updateClient();
        if (rep.getProtocol() != null) {
            resource.setProtocol(rep.getProtocol());
        }
        if (rep.getAttributes() != null) {
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                resource.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (rep.getNotBefore() != null) {
            resource.setNotBefore(rep.getNotBefore());
        }
        if (rep.getDefaultRoles() != null) {
            resource.updateDefaultRoles(rep.getDefaultRoles());
        }
        if ((redirectUris = rep.getRedirectUris()) != null) {
            resource.setRedirectUris(new HashSet<String>(redirectUris));
        }
        if ((webOrigins = rep.getWebOrigins()) != null) {
            resource.setWebOrigins(new HashSet<String>(webOrigins));
        }
        if (rep.getRegisteredNodes() != null) {
            for (Map.Entry entry : rep.getRegisteredNodes().entrySet()) {
                resource.registerNode((String)entry.getKey(), (Integer)entry.getValue());
            }
        }
        if (rep.isUseTemplateConfig() != null) {
            resource.setUseTemplateConfig(rep.isUseTemplateConfig());
        }
        if (rep.isUseTemplateScope() != null) {
            resource.setUseTemplateScope(rep.isUseTemplateScope());
        }
        if (rep.isUseTemplateMappers() != null) {
            resource.setUseTemplateMappers(rep.isUseTemplateMappers());
        }
        if (rep.getClientTemplate() != null) {
            if (rep.getClientTemplate().equals("NONE")) {
                resource.setClientTemplate(null);
            } else {
                RealmModel realm = resource.getRealm();
                for (ClientTemplateModel template : realm.getClientTemplates()) {
                    if (!template.getName().equals(rep.getClientTemplate())) continue;
                    resource.setClientTemplate(template);
                    if (rep.isUseTemplateConfig() == null) {
                        resource.setUseTemplateConfig(true);
                    }
                    if (rep.isUseTemplateScope() == null) {
                        resource.setUseTemplateScope(true);
                    }
                    if (rep.isUseTemplateMappers() != null) break;
                    resource.setUseTemplateMappers(true);
                    break;
                }
            }
        }
    }

    private static Map<String, ClientTemplateModel> createClientTemplates(KeycloakSession session, RealmRepresentation rep, RealmModel realm) {
        HashMap<String, ClientTemplateModel> appMap = new HashMap<String, ClientTemplateModel>();
        for (ClientTemplateRepresentation resourceRep : rep.getClientTemplates()) {
            ClientTemplateModel app = RepresentationToModel.createClientTemplate(session, realm, resourceRep);
            appMap.put(app.getName(), app);
        }
        return appMap;
    }

    public static ClientTemplateModel createClientTemplate(KeycloakSession session, RealmModel realm, ClientTemplateRepresentation resourceRep) {
        ClientTemplateModel client;
        logger.debug((Object)("Create client template: {0}" + resourceRep.getName()));
        ClientTemplateModel clientTemplateModel = client = resourceRep.getId() != null ? realm.addClientTemplate(resourceRep.getId(), resourceRep.getName()) : realm.addClientTemplate(resourceRep.getName());
        if (resourceRep.getName() != null) {
            client.setName(resourceRep.getName());
        }
        if (resourceRep.getDescription() != null) {
            client.setDescription(resourceRep.getDescription());
        }
        if (resourceRep.getProtocol() != null) {
            client.setProtocol(resourceRep.getProtocol());
        }
        if (resourceRep.isFullScopeAllowed() != null) {
            client.setFullScopeAllowed(resourceRep.isFullScopeAllowed());
        }
        if (resourceRep.getProtocolMappers() != null) {
            Set<ProtocolMapperModel> mappers = client.getProtocolMappers();
            for (ProtocolMapperModel mapper : mappers) {
                client.removeProtocolMapper(mapper);
            }
            for (ProtocolMapperModel mapper : resourceRep.getProtocolMappers()) {
                client.addProtocolMapper(RepresentationToModel.toModel((ProtocolMapperRepresentation)mapper));
            }
        }
        if (resourceRep.isBearerOnly() != null) {
            client.setBearerOnly(resourceRep.isBearerOnly());
        }
        if (resourceRep.isConsentRequired() != null) {
            client.setConsentRequired(resourceRep.isConsentRequired());
        }
        if (resourceRep.isStandardFlowEnabled() != null) {
            client.setStandardFlowEnabled(resourceRep.isStandardFlowEnabled());
        }
        if (resourceRep.isImplicitFlowEnabled() != null) {
            client.setImplicitFlowEnabled(resourceRep.isImplicitFlowEnabled());
        }
        if (resourceRep.isDirectAccessGrantsEnabled() != null) {
            client.setDirectAccessGrantsEnabled(resourceRep.isDirectAccessGrantsEnabled());
        }
        if (resourceRep.isServiceAccountsEnabled() != null) {
            client.setServiceAccountsEnabled(resourceRep.isServiceAccountsEnabled());
        }
        if (resourceRep.isPublicClient() != null) {
            client.setPublicClient(resourceRep.isPublicClient());
        }
        if (resourceRep.isFrontchannelLogout() != null) {
            client.setFrontchannelLogout(resourceRep.isFrontchannelLogout());
        }
        if (resourceRep.getAttributes() != null) {
            for (Map.Entry entry : resourceRep.getAttributes().entrySet()) {
                client.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return client;
    }

    public static void updateClientTemplate(ClientTemplateRepresentation rep, ClientTemplateModel resource) {
        if (rep.getName() != null) {
            resource.setName(rep.getName());
        }
        if (rep.getDescription() != null) {
            resource.setDescription(rep.getDescription());
        }
        if (rep.isFullScopeAllowed() != null) {
            resource.setFullScopeAllowed(rep.isFullScopeAllowed());
        }
        if (rep.getProtocol() != null) {
            resource.setProtocol(rep.getProtocol());
        }
        if (rep.isBearerOnly() != null) {
            resource.setBearerOnly(rep.isBearerOnly());
        }
        if (rep.isConsentRequired() != null) {
            resource.setConsentRequired(rep.isConsentRequired());
        }
        if (rep.isStandardFlowEnabled() != null) {
            resource.setStandardFlowEnabled(rep.isStandardFlowEnabled());
        }
        if (rep.isImplicitFlowEnabled() != null) {
            resource.setImplicitFlowEnabled(rep.isImplicitFlowEnabled());
        }
        if (rep.isDirectAccessGrantsEnabled() != null) {
            resource.setDirectAccessGrantsEnabled(rep.isDirectAccessGrantsEnabled());
        }
        if (rep.isServiceAccountsEnabled() != null) {
            resource.setServiceAccountsEnabled(rep.isServiceAccountsEnabled());
        }
        if (rep.isPublicClient() != null) {
            resource.setPublicClient(rep.isPublicClient());
        }
        if (rep.isFullScopeAllowed() != null) {
            resource.setFullScopeAllowed(rep.isFullScopeAllowed());
        }
        if (rep.isFrontchannelLogout() != null) {
            resource.setFrontchannelLogout(rep.isFrontchannelLogout());
        }
        if (rep.getAttributes() != null) {
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                resource.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public static long getClaimsMask(ClaimRepresentation rep) {
        long mask = 1023L;
        mask = rep.getAddress() ? (mask |= 0x100L) : (mask &= 0xFFFFFFFFFFFFFEFFL);
        mask = rep.getEmail() ? (mask |= 0x20L) : (mask &= 0xFFFFFFFFFFFFFFDFL);
        mask = rep.getGender() ? (mask |= 0x40L) : (mask &= 0xFFFFFFFFFFFFFFBFL);
        mask = rep.getLocale() ? (mask |= 0x80L) : (mask &= 0xFFFFFFFFFFFFFF7FL);
        mask = rep.getName() ? (mask |= 1L) : (mask &= 0xFFFFFFFFFFFFFFFEL);
        mask = rep.getPhone() ? (mask |= 0x200L) : (mask &= 0xFFFFFFFFFFFFFDFFL);
        mask = rep.getPicture() ? (mask |= 8L) : (mask &= 0xFFFFFFFFFFFFFFF7L);
        mask = rep.getProfile() ? (mask |= 4L) : (mask &= 0xFFFFFFFFFFFFFFFBL);
        mask = rep.getUsername() ? (mask |= 2L) : (mask &= 0xFFFFFFFFFFFFFFFDL);
        mask = rep.getWebsite() ? (mask |= 0x10L) : (mask &= 0xFFFFFFFFFFFFFFEFL);
        return mask;
    }

    public static void createClientScopeMappings(RealmModel realm, ClientModel clientModel, List<ScopeMappingRepresentation> mappings) {
        for (ScopeMappingRepresentation mapping : mappings) {
            ClientModel client = realm.getClientByClientId(mapping.getClient());
            if (client == null) {
                throw new RuntimeException("Unknown client specified in client scope mappings");
            }
            for (String roleString : mapping.getRoles()) {
                RoleModel role = clientModel.getRole(roleString.trim());
                if (role == null) {
                    role = clientModel.addRole(roleString.trim());
                }
                client.addScopeMapping(role);
            }
        }
    }

    public static UserModel createUser(KeycloakSession session, RealmModel newRealm, UserRepresentation userRep) {
        RepresentationToModel.convertDeprecatedSocialProviders(userRep);
        UserModel user = session.userStorage().addUser(newRealm, userRep.getId(), userRep.getUsername(), false, false);
        user.setEnabled(userRep.isEnabled() != null && userRep.isEnabled() != false);
        user.setCreatedTimestamp(userRep.getCreatedTimestamp());
        user.setEmail(userRep.getEmail());
        if (userRep.isEmailVerified() != null) {
            user.setEmailVerified(userRep.isEmailVerified());
        }
        user.setFirstName(userRep.getFirstName());
        user.setLastName(userRep.getLastName());
        user.setFederationLink(userRep.getFederationLink());
        if (userRep.isTotp() != null) {
            user.setOtpEnabled(userRep.isTotp());
        }
        if (userRep.getAttributes() != null) {
            for (Map.Entry entry : userRep.getAttributes().entrySet()) {
                Object value = entry.getValue();
                if (value instanceof Collection) {
                    Collection colVal = (Collection)value;
                    user.setAttribute((String)entry.getKey(), new ArrayList<String>(colVal));
                    continue;
                }
                if (!(value instanceof String)) continue;
                String stringVal = (String)value;
                user.setSingleAttribute((String)entry.getKey(), stringVal);
            }
        }
        if (userRep.getRequiredActions() != null) {
            for (String requiredAction : userRep.getRequiredActions()) {
                user.addRequiredAction(UserModel.RequiredAction.valueOf(requiredAction));
            }
        }
        RepresentationToModel.createCredentials(userRep, user);
        if (userRep.getFederatedIdentities() != null) {
            for (FederatedIdentityRepresentation identity : userRep.getFederatedIdentities()) {
                FederatedIdentityModel mappingModel = new FederatedIdentityModel(identity.getIdentityProvider(), identity.getUserId(), identity.getUserName());
                session.users().addFederatedIdentity(newRealm, user, mappingModel);
            }
        }
        RepresentationToModel.createRoleMappings(userRep, user, newRealm);
        if (userRep.getClientConsents() != null) {
            for (UserConsentRepresentation consentRep : userRep.getClientConsents()) {
                UserConsentModel consentModel = RepresentationToModel.toModel(newRealm, consentRep);
                user.addConsent(consentModel);
            }
        }
        if (userRep.getServiceAccountClientId() != null) {
            String clientId = userRep.getServiceAccountClientId();
            ClientModel client = newRealm.getClientByClientId(clientId);
            if (client == null) {
                throw new RuntimeException("Unable to find client specified for service account link. Client: " + clientId);
            }
            user.setServiceAccountClientLink(client.getId());
        }
        if (userRep.getGroups() != null) {
            for (String path : userRep.getGroups()) {
                GroupModel group = KeycloakModelUtils.findGroupByPath(newRealm, path);
                if (group == null) {
                    throw new RuntimeException("Unable to find group specified by path: " + path);
                }
                user.joinGroup(group);
            }
        }
        return user;
    }

    public static void createCredentials(UserRepresentation userRep, UserModel user) {
        if (userRep.getCredentials() != null) {
            for (CredentialRepresentation cred : userRep.getCredentials()) {
                RepresentationToModel.updateCredential(user, cred);
            }
        }
    }

    private static void updateCredential(UserModel user, CredentialRepresentation cred) {
        if (cred.getValue() != null) {
            UserCredentialModel plainTextCred = RepresentationToModel.convertCredential(cred);
            user.updateCredential(plainTextCred);
        } else {
            UserCredentialValueModel hashedCred = new UserCredentialValueModel();
            hashedCred.setType(cred.getType());
            hashedCred.setDevice(cred.getDevice());
            if (cred.getHashIterations() != null) {
                hashedCred.setHashIterations(cred.getHashIterations());
            }
            try {
                if (cred.getSalt() != null) {
                    hashedCred.setSalt(Base64.decode((String)cred.getSalt()));
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            hashedCred.setValue(cred.getHashedSaltedValue());
            if (cred.getCounter() != null) {
                hashedCred.setCounter(cred.getCounter());
            }
            if (cred.getDigits() != null) {
                hashedCred.setDigits(cred.getDigits());
            }
            if (cred.getAlgorithm() != null) {
                hashedCred.setAlgorithm(cred.getAlgorithm());
            } else if ("password".equals(cred.getType()) || "password-history".equals(cred.getType())) {
                hashedCred.setAlgorithm("pbkdf2");
            } else if (UserCredentialModel.isOtp(cred.getType())) {
                hashedCred.setAlgorithm("HmacSHA1");
            }
            if (cred.getPeriod() != null) {
                hashedCred.setPeriod(cred.getPeriod());
            }
            if (cred.getDigits() == null && UserCredentialModel.isOtp(cred.getType())) {
                hashedCred.setDigits(6);
            }
            if (cred.getPeriod() == null && "totp".equals(cred.getType())) {
                hashedCred.setPeriod(30);
            }
            hashedCred.setCreatedDate(cred.getCreatedDate());
            user.updateCredentialDirectly(hashedCred);
        }
    }

    public static UserCredentialModel convertCredential(CredentialRepresentation cred) {
        UserCredentialModel credential = new UserCredentialModel();
        credential.setType(cred.getType());
        credential.setValue(cred.getValue());
        return credential;
    }

    public static void createRoleMappings(UserRepresentation userRep, UserModel user, RealmModel realm) {
        if (userRep.getRealmRoles() != null) {
            for (String string : userRep.getRealmRoles()) {
                RoleModel role = realm.getRole(string.trim());
                if (role == null) {
                    role = realm.addRole(string.trim());
                }
                user.grantRole(role);
            }
        }
        if (userRep.getClientRoles() != null) {
            for (Map.Entry entry : userRep.getClientRoles().entrySet()) {
                ClientModel client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("Unable to find client role mappings for client: " + (String)entry.getKey());
                }
                RepresentationToModel.createClientRoleMappings(client, user, (List)entry.getValue());
            }
        }
    }

    public static void createClientRoleMappings(ClientModel clientModel, UserModel user, List<String> roleNames) {
        if (user == null) {
            throw new RuntimeException("User not found");
        }
        for (String roleName : roleNames) {
            RoleModel role = clientModel.getRole(roleName.trim());
            if (role == null) {
                role = clientModel.addRole(roleName.trim());
            }
            user.grantRole(role);
        }
    }

    private static void importIdentityProviders(RealmRepresentation rep, RealmModel newRealm) {
        if (rep.getIdentityProviders() != null) {
            for (IdentityProviderRepresentation representation : rep.getIdentityProviders()) {
                newRealm.addIdentityProvider(RepresentationToModel.toModel(newRealm, representation));
            }
        }
    }

    private static void importIdentityProviderMappers(RealmRepresentation rep, RealmModel newRealm) {
        if (rep.getIdentityProviderMappers() != null) {
            for (IdentityProviderMapperRepresentation representation : rep.getIdentityProviderMappers()) {
                newRealm.addIdentityProviderMapper(RepresentationToModel.toModel(representation));
            }
        }
    }

    public static IdentityProviderModel toModel(RealmModel realm, IdentityProviderRepresentation representation) {
        AuthenticationFlowModel flowModel;
        IdentityProviderModel identityProviderModel = new IdentityProviderModel();
        identityProviderModel.setInternalId(representation.getInternalId());
        identityProviderModel.setAlias(representation.getAlias());
        identityProviderModel.setProviderId(representation.getProviderId());
        identityProviderModel.setEnabled(representation.isEnabled());
        identityProviderModel.setTrustEmail(representation.isTrustEmail());
        identityProviderModel.setAuthenticateByDefault(representation.isAuthenticateByDefault());
        identityProviderModel.setStoreToken(representation.isStoreToken());
        identityProviderModel.setAddReadTokenRoleOnCreate(representation.isAddReadTokenRoleOnCreate());
        identityProviderModel.setConfig(representation.getConfig());
        String flowAlias = representation.getFirstBrokerLoginFlowAlias();
        if (flowAlias == null) {
            flowAlias = "first broker login";
        }
        if ((flowModel = realm.getFlowByAlias(flowAlias)) == null) {
            throw new ModelException("No available authentication flow with alias: " + flowAlias);
        }
        identityProviderModel.setFirstBrokerLoginFlowId(flowModel.getId());
        flowAlias = representation.getPostBrokerLoginFlowAlias();
        if (flowAlias == null || flowAlias.trim().length() == 0) {
            identityProviderModel.setPostBrokerLoginFlowId(null);
        } else {
            flowModel = realm.getFlowByAlias(flowAlias);
            if (flowModel == null) {
                throw new ModelException("No available authentication flow with alias: " + flowAlias);
            }
            identityProviderModel.setPostBrokerLoginFlowId(flowModel.getId());
        }
        return identityProviderModel;
    }

    public static ProtocolMapperModel toModel(ProtocolMapperRepresentation rep) {
        ProtocolMapperModel model = new ProtocolMapperModel();
        model.setId(rep.getId());
        model.setName(rep.getName());
        model.setConsentRequired(rep.isConsentRequired());
        model.setConsentText(rep.getConsentText());
        model.setProtocol(rep.getProtocol());
        model.setProtocolMapper(rep.getProtocolMapper());
        model.setConfig(rep.getConfig());
        return model;
    }

    public static IdentityProviderMapperModel toModel(IdentityProviderMapperRepresentation rep) {
        IdentityProviderMapperModel model = new IdentityProviderMapperModel();
        model.setId(rep.getId());
        model.setName(rep.getName());
        model.setIdentityProviderAlias(rep.getIdentityProviderAlias());
        model.setIdentityProviderMapper(rep.getIdentityProviderMapper());
        model.setConfig(rep.getConfig());
        return model;
    }

    public static UserConsentModel toModel(RealmModel newRealm, UserConsentRepresentation consentRep) {
        ClientModel client = newRealm.getClientByClientId(consentRep.getClientId());
        if (client == null) {
            throw new RuntimeException("Unable to find client consent mappings for client: " + consentRep.getClientId());
        }
        UserConsentModel consentModel = new UserConsentModel(client);
        if (consentRep.getGrantedRealmRoles() != null) {
            for (String string : consentRep.getGrantedRealmRoles()) {
                RoleModel role = newRealm.getRole(string);
                if (role == null) {
                    throw new RuntimeException("Unable to find realm role referenced in consent mappings of user. Role name: " + string);
                }
                consentModel.addGrantedRole(role);
            }
        }
        if (consentRep.getGrantedClientRoles() != null) {
            for (Map.Entry entry : consentRep.getGrantedClientRoles().entrySet()) {
                String clientId2 = (String)entry.getKey();
                ClientModel client2 = newRealm.getClientByClientId(clientId2);
                if (client2 == null) {
                    throw new RuntimeException("Unable to find client referenced in consent mappings. Client ID: " + clientId2);
                }
                for (String clientRoleName : (List)entry.getValue()) {
                    RoleModel clientRole = client2.getRole(clientRoleName);
                    if (clientRole == null) {
                        throw new RuntimeException("Unable to find client role referenced in consent mappings of user. Role name: " + clientRole + ", Client: " + clientId2);
                    }
                    consentModel.addGrantedRole(clientRole);
                }
            }
        }
        if (consentRep.getGrantedProtocolMappers() != null) {
            for (Map.Entry entry : consentRep.getGrantedProtocolMappers().entrySet()) {
                String protocol = (String)entry.getKey();
                for (String protocolMapperName : (List)entry.getValue()) {
                    ProtocolMapperModel protocolMapper = client.getProtocolMapperByName(protocol, protocolMapperName);
                    if (protocolMapper == null) {
                        throw new RuntimeException("Unable to find protocol mapper for protocol " + protocol + ", mapper name " + protocolMapperName);
                    }
                    consentModel.addGrantedProtocolMapper(protocolMapper);
                }
            }
        }
        return consentModel;
    }

    public static AuthenticationFlowModel toModel(AuthenticationFlowRepresentation rep) {
        AuthenticationFlowModel model = new AuthenticationFlowModel();
        model.setId(rep.getId());
        model.setBuiltIn(rep.isBuiltIn());
        model.setTopLevel(rep.isTopLevel());
        model.setProviderId(rep.getProviderId());
        model.setAlias(rep.getAlias());
        model.setDescription(rep.getDescription());
        return model;
    }

    public static AuthenticationExecutionModel toModel(RealmModel realm, AuthenticationExecutionExportRepresentation rep) {
        AuthenticationExecutionModel model = new AuthenticationExecutionModel();
        if (rep.getAuthenticatorConfig() != null) {
            AuthenticatorConfigModel config = realm.getAuthenticatorConfigByAlias(rep.getAuthenticatorConfig());
            model.setAuthenticatorConfig(config.getId());
        }
        model.setAuthenticator(rep.getAuthenticator());
        model.setAuthenticatorFlow(rep.isAutheticatorFlow());
        if (rep.getFlowAlias() != null) {
            AuthenticationFlowModel flow = realm.getFlowByAlias(rep.getFlowAlias());
            model.setFlowId(flow.getId());
        }
        model.setPriority(rep.getPriority());
        model.setRequirement(AuthenticationExecutionModel.Requirement.valueOf(rep.getRequirement()));
        return model;
    }

    public static AuthenticationExecutionModel toModel(RealmModel realm, AuthenticationExecutionRepresentation rep) {
        AuthenticationExecutionModel model = new AuthenticationExecutionModel();
        model.setId(rep.getId());
        model.setFlowId(rep.getFlowId());
        model.setAuthenticator(rep.getAuthenticator());
        model.setPriority(rep.getPriority());
        model.setParentFlow(rep.getParentFlow());
        model.setAuthenticatorFlow(rep.isAutheticatorFlow());
        model.setRequirement(AuthenticationExecutionModel.Requirement.valueOf(rep.getRequirement()));
        if (rep.getAuthenticatorConfig() != null) {
            AuthenticatorConfigModel cfg = realm.getAuthenticatorConfigByAlias(rep.getAuthenticatorConfig());
            model.setAuthenticatorConfig(cfg.getId());
        }
        return model;
    }

    public static AuthenticatorConfigModel toModel(AuthenticatorConfigRepresentation rep) {
        AuthenticatorConfigModel model = new AuthenticatorConfigModel();
        model.setAlias(rep.getAlias());
        model.setConfig(rep.getConfig());
        return model;
    }

    public static RequiredActionProviderModel toModel(RequiredActionProviderRepresentation rep) {
        RequiredActionProviderModel model = new RequiredActionProviderModel();
        model.setConfig(rep.getConfig());
        model.setDefaultAction(rep.isDefaultAction());
        model.setEnabled(rep.isEnabled());
        model.setProviderId(rep.getProviderId());
        model.setName(rep.getName());
        model.setAlias(rep.getAlias());
        return model;
    }
}

